/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item.electricalitem;

import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.item.electricalinterface.IItemEnergyBattery;
import mods.eln.item.electricalitem.LampItem;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;

public class ElectricalLampItem
extends LampItem
implements IItemEnergyBattery {
    int lightMin;
    int rangeMin;
    int lightMax;
    int rangeMax;
    double energyStorage;
    double dischargeMin;
    double dischargeMax;
    double chargePower;
    ResourceLocation on;
    ResourceLocation off;

    public ElectricalLampItem(String name, int lightMin, int rangeMin, double dischargeMin, int lightMax, int rangeMax, double dischargeMax, double energyStorage, double chargePower) {
        super(name);
        this.lightMin = lightMin;
        this.rangeMin = rangeMin;
        this.lightMax = lightMax;
        this.rangeMax = rangeMax;
        this.chargePower = chargePower;
        this.dischargeMin = dischargeMin;
        this.dischargeMax = dischargeMax;
        this.energyStorage = energyStorage;
        this.on = new ResourceLocation("eln", "textures/items/" + name.replace(" ", "").toLowerCase() + "on.png");
        this.off = new ResourceLocation("eln", "textures/items/" + name.replace(" ", "").toLowerCase() + "off.png");
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addPortable(this.newItemStack());
        Data.addLight(this.newItemStack());
    }

    @Override
    int getRange(ItemStack stack) {
        return this.getLightState(stack) == 1 ? this.rangeMin : this.rangeMax;
    }

    @Override
    int getLight(ItemStack stack) {
        double energy = this.getEnergy(stack);
        int state = this.getLightState(stack);
        double power = 0.0;
        switch (state) {
            case 1: {
                power = this.dischargeMin;
                break;
            }
            case 2: {
                power = this.dischargeMax;
            }
        }
        if (energy > power) {
            return this.getLightLevel(stack);
        }
        return 0;
    }

    @Override
    public NBTTagCompound getDefaultNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("energy", 0.0);
        nbt.func_74757_a("powerOn", false);
        nbt.func_74768_a("rand", (int)(Math.random() * 2.68435455E8));
        return nbt;
    }

    @Override
    int getLightState(ItemStack stack) {
        return this.getNbt(stack).func_74762_e("LightState");
    }

    void setLightState(ItemStack stack, int value) {
        this.getNbt(stack).func_74768_a("LightState", value);
    }

    int getLightLevel(ItemStack stack) {
        return this.getLightState(stack) == 1 ? this.lightMin : this.lightMax;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack s, World w, EntityPlayer p) {
        if (!w.field_72995_K) {
            int lightState = this.getLightState(s) + 1;
            if (lightState > 1) {
                lightState = 0;
            }
            switch (lightState) {
                case 0: {
                    Utils.addChatMessage((EntityPlayer)((EntityPlayerMP)p), "Flashlight OFF");
                    break;
                }
                case 1: {
                    Utils.addChatMessage((EntityPlayer)((EntityPlayerMP)p), "Flashlight ON");
                    break;
                }
                case 2: {
                    Utils.addChatMessage((EntityPlayer)((EntityPlayerMP)p), "Flashlight ON-2");
                    break;
                }
            }
            this.setLightState(s, lightState);
        }
        return s;
    }

    @Override
    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Discharge power: %1$W", (int)this.dischargeMin));
        if (itemStack != null) {
            list.add(I18N.tr("Stored Energy: %1$J (%2$%)", this.getEnergy(itemStack), (int)(this.getEnergy(itemStack) / this.energyStorage * 100.0)));
            list.add(I18N.tr("State:", new Object[0]) + " " + (this.getLightState(itemStack) != 0 ? I18N.tr("On", new Object[0]) : I18N.tr("Off", new Object[0])));
        }
    }

    @Override
    public double getEnergy(ItemStack stack) {
        return this.getNbt(stack).func_74769_h("energy");
    }

    @Override
    public void setEnergy(ItemStack stack, double value) {
        this.getNbt(stack).func_74780_a("energy", value);
    }

    @Override
    public double getEnergyMax(ItemStack stack) {
        return this.energyStorage;
    }

    @Override
    public double getChargePower(ItemStack stack) {
        return this.chargePower;
    }

    @Override
    public double getDischagePower(ItemStack stack) {
        return 0.0;
    }

    @Override
    public int getPriority(ItemStack stack) {
        return 0;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            UtilsClient.drawEnergyBare(type, (float)(this.getEnergy(item) / this.getEnergyMax(item)));
        }
        UtilsClient.drawIcon(type, this.getLight(item) != 0 && this.getLightState(item) != 0 ? this.on : this.off);
    }

    @Override
    public void electricalItemUpdate(ItemStack stack, double time) {
        double energy = this.getEnergy(stack);
        int state = this.getLightState(stack);
        double power = 0.0;
        switch (state) {
            case 1: {
                power = this.dischargeMin * time;
                break;
            }
            case 2: {
                power = this.dischargeMax * time;
            }
        }
        if (energy > power) {
            this.setEnergy(stack, energy - power);
        } else {
            this.setEnergy(stack, 0.0);
        }
    }
}

