/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item.electricalitem;

import java.util.List;
import mods.eln.Eln;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.item.electricalinterface.IItemEnergyBattery;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;

public class ElectricalTool
extends GenericItemUsingDamageDescriptor
implements IItemEnergyBattery {
    int light;
    int range;
    double energyStorage;
    double energyPerBlock;
    double chargePower;
    float strengthOff;
    float strengthOn;
    ResourceLocation rIcon;
    public static final Block[] blocksEffectiveAgainst = new Block[]{Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150433_aE, Blocks.field_150433_aE, Blocks.field_150435_aG, Blocks.field_150458_ak, Blocks.field_150425_aM, Blocks.field_150391_bh};

    public ElectricalTool(String name, float strengthOn, float strengthOff, double energyStorage, double energyPerBlock, double chargePower) {
        super(name);
        this.chargePower = chargePower;
        this.energyPerBlock = energyPerBlock;
        this.energyStorage = energyStorage;
        this.strengthOn = strengthOn;
        this.strengthOff = strengthOff;
        this.rIcon = new ResourceLocation("eln", "textures/items/" + name.replace(" ", "").toLowerCase() + ".png");
    }

    @Override
    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (entityLiving.field_70170_p.field_72995_K) {
            return false;
        }
        Eln.itemEnergyInventoryProcess.addExclusion(this, 2.0);
        return super.onEntitySwing(entityLiving, stack);
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World w, Block block, int x, int y, int z, EntityLivingBase entity) {
        if (this.getStrVsBlock(stack, block) == this.strengthOn) {
            double e = this.getEnergy(stack) - this.energyPerBlock;
            if (e < 0.0) {
                e = 0.0;
            }
            this.setEnergy(stack, e);
        }
        Utils.println("destroy");
        return true;
    }

    public float getStrength(ItemStack stack) {
        return this.getEnergy(stack) >= this.energyPerBlock ? this.strengthOn : this.strengthOff;
    }

    @Override
    public NBTTagCompound getDefaultNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("energy", 0.0);
        nbt.func_74757_a("powerOn", false);
        nbt.func_74768_a("rand", (int)(Math.random() * 2.68435455E8));
        return nbt;
    }

    boolean getPowerOn(ItemStack stack) {
        return this.getNbt(stack).func_74767_n("powerOn");
    }

    void setPowerOn(ItemStack stack, boolean value) {
        this.getNbt(stack).func_74757_a("powerOn", value);
    }

    @Override
    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        if (itemStack != null) {
            list.add(I18N.tr("Stored energy: %1$J (%2$%)", this.getEnergy(itemStack), (int)(this.getEnergy(itemStack) / this.energyStorage * 100.0)));
        }
    }

    @Override
    public double getEnergy(ItemStack stack) {
        return this.getNbt(stack).func_74769_h("energy");
    }

    @Override
    public void setEnergy(ItemStack stack, double value) {
        this.getNbt(stack).func_74780_a("energy", value);
    }

    @Override
    public double getEnergyMax(ItemStack stack) {
        return this.energyStorage;
    }

    @Override
    public double getChargePower(ItemStack stack) {
        return this.chargePower;
    }

    @Override
    public double getDischagePower(ItemStack stack) {
        return 0.0;
    }

    @Override
    public int getPriority(ItemStack stack) {
        return 0;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            UtilsClient.drawEnergyBare(type, (float)(this.getEnergy(item) / this.getEnergyMax(item)));
        }
        UtilsClient.drawIcon(type, this.rIcon);
    }

    @Override
    public void electricalItemUpdate(ItemStack stack, double time) {
    }
}

