/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item.electricalitem;

import java.util.List;
import mods.eln.Eln;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.item.electricalinterface.IItemEnergyBattery;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.server.PlayerManager;
import mods.eln.wiki.Data;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class PortableOreScannerItem
extends GenericItemUsingDamageDescriptor
implements IItemEnergyBattery {
    double energyStorage;
    double dischargePower;
    double chargePower;
    float viewRange;
    float viewYAlpha;
    int resWidth;
    int resHeight;
    private Obj3D obj;
    private final ResourceLocation iconResource;
    Obj3D.Obj3DPart base;
    Obj3D.Obj3DPart led;
    Obj3D.Obj3DPart ledHalo;
    Obj3D.Obj3DPart[] textBat;
    Obj3D.Obj3DPart textRun;
    Obj3D.Obj3DPart textInit;
    Obj3D.Obj3DPart buttons;
    Obj3D.Obj3DPart[] screenDamage;
    Obj3D.Obj3DPart screenLuma;
    private byte damagePerBreakLevel = (byte)3;
    static final byte sIdle = 0;
    static final byte sBoot = 1;
    static final byte sRun = 2;
    static final byte sStop = 3;
    static final byte sError = 4;
    static final short bootTime = 80;
    static final short stopTime = 20;
    static final double minimalEnergyTimeToBoot = 1.0;

    public PortableOreScannerItem(String name, Obj3D obj, double energyStorage, double chargePower, double dischargePower, float viewRange, float viewYAlpha, int resWidth, int resHeight) {
        super(name);
        this.chargePower = chargePower;
        this.dischargePower = dischargePower;
        this.energyStorage = energyStorage;
        this.viewRange = viewRange;
        this.viewYAlpha = viewYAlpha;
        this.resWidth = resWidth;
        this.resHeight = resHeight;
        this.obj = obj;
        if (obj != null) {
            int idx;
            this.base = obj.getPart("Base");
            this.led = obj.getPart("Led");
            this.ledHalo = obj.getPart("LedHalo");
            this.textBat = new Obj3D.Obj3DPart[4];
            for (idx = 0; idx < 4; ++idx) {
                this.textBat[idx] = obj.getPart("TextBat" + idx);
            }
            this.textRun = obj.getPart("TextRun");
            this.textInit = obj.getPart("TextInit");
            this.screenDamage = new Obj3D.Obj3DPart[3];
            for (idx = 0; idx < 3; ++idx) {
                this.screenDamage[idx] = obj.getPart("ScreenDamageL" + (idx + 1));
            }
            this.buttons = obj.getPart("Buttons");
            this.screenLuma = obj.getPart("ScreenLuma");
        }
        this.iconResource = new ResourceLocation("eln", "textures/items/x-rayscanner.png");
    }

    @Override
    public boolean use2DIcon() {
        return false;
    }

    @Override
    public void onUpdate(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (world.field_72995_K) {
            return;
        }
        if (!(entity instanceof EntityPlayerMP)) {
            return;
        }
        PlayerManager.PlayerMetadata playerData = Eln.playerManager.get((EntityPlayerMP)entity);
        double energy = this.getEnergy(stack);
        byte state = this.getState(stack);
        short counter = this.getCounter(stack);
        if (this.getDamage(stack) / this.damagePerBreakLevel >= 4) {
            if (state != 0) {
                this.setState(stack, (byte)0);
            }
            return;
        }
        switch (state) {
            case 1: {
                counter = (short)(counter - 1);
                if (counter != 0) {
                    this.setCounter(stack, counter);
                    break;
                }
                this.setState(stack, (byte)2);
                break;
            }
            case 3: {
                counter = (short)(counter - 1);
                if (counter != 0) {
                    this.setCounter(stack, counter);
                    break;
                }
                this.setState(stack, (byte)0);
            }
        }
    }

    @Override
    public ItemStack onItemRightClick(ItemStack s, World w, EntityPlayer p) {
        if (w.field_72995_K) {
            return s;
        }
        boolean playerInteractRise = true;
        double energy = this.getEnergy(s);
        byte state = this.getState(s);
        short counter = this.getCounter(s);
        switch (state) {
            case 0: {
                if (!playerInteractRise || !(energy > this.dischargePower * 1.0)) break;
                this.setState(s, (byte)1);
                this.setCounter(s, (short)80);
                break;
            }
            case 2: {
                if (!playerInteractRise) break;
                this.setState(s, (byte)3);
                this.setCounter(s, (short)20);
            }
        }
        return s;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addPortable(this.newItemStack());
    }

    @Override
    public NBTTagCompound getDefaultNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("e", this.energyStorage * 0.2);
        nbt.func_74774_a("s", (byte)1);
        nbt.func_74777_a("c", (short)80);
        nbt.func_74774_a("d", (byte)0);
        return nbt;
    }

    @Override
    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Discharge power: %1$W", (int)this.dischargePower));
        if (itemStack != null) {
            list.add(I18N.tr("Stored energy: %1$J (%2$%)", this.getEnergy(itemStack), (int)(this.getEnergy(itemStack) / this.energyStorage * 100.0)));
        }
    }

    @Override
    public double getEnergy(ItemStack stack) {
        return this.getNbt(stack).func_74769_h("e");
    }

    @Override
    public void setEnergy(ItemStack stack, double value) {
        this.getNbt(stack).func_74780_a("e", value);
    }

    public byte getState(ItemStack stack) {
        return this.getNbt(stack).func_74771_c("s");
    }

    public void setState(ItemStack stack, byte value) {
        this.getNbt(stack).func_74774_a("s", value);
    }

    public short getCounter(ItemStack stack) {
        return this.getNbt(stack).func_74765_d("c");
    }

    public void setCounter(ItemStack stack, short value) {
        this.getNbt(stack).func_74777_a("c", value);
    }

    public byte getDamage(ItemStack stack) {
        return this.getNbt(stack).func_74771_c("d");
    }

    public void setDamage(ItemStack stack, byte value) {
        this.getNbt(stack).func_74774_a("d", value);
    }

    @Override
    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        this.setState(stack, (byte)0);
        return super.onDroppedByPlayer(stack, player);
    }

    @Override
    public double getEnergyMax(ItemStack stack) {
        return this.energyStorage;
    }

    @Override
    public double getChargePower(ItemStack stack) {
        return this.chargePower;
    }

    @Override
    public double getDischagePower(ItemStack stack) {
        return this.dischargePower;
    }

    @Override
    public int getPriority(ItemStack stack) {
        return 0;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean onBlockStartBreak(ItemStack itemstack, int x, int y, int z, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            this.setDamage(itemstack, (byte)(this.getDamage(itemstack) + 1));
        }
        return super.onBlockStartBreak(itemstack, x, y, z, player);
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        Entity e;
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            UtilsClient.drawEnergyBare(type, (float)(this.getEnergy(item) / this.getEnergyMax(item)));
        }
        double energy = this.getEnergy(item);
        byte state = this.getState(item);
        short counter = this.getCounter(item);
        GL11.glPushMatrix();
        switch (type) {
            case ENTITY: {
                e = null;
                GL11.glTranslatef((float)0.0f, (float)-0.2f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EQUIPPED: {
                e = (Entity)data[1];
                GL11.glRotatef((float)130.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)140.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)1.6f, (float)1.6f, (float)1.6f);
                GL11.glTranslatef((float)-0.2f, (float)0.7f, (float)-0.0f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                e = (Entity)data[1];
                GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)35.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)1.0f, (float)-0.2f);
                break;
            }
            case INVENTORY: {
                UtilsClient.drawIcon(type, this.iconResource);
                GL11.glPopMatrix();
                return;
            }
            case FIRST_PERSON_MAP: {
                e = null;
                break;
            }
            default: {
                e = null;
            }
        }
        boolean drawScreen = e != null && UtilsClient.clientDistanceTo(e) < 10.0;
        boolean drawRay = drawScreen && state == 2;
        this.base.draw();
        if (drawRay) {
            GL11.glPushMatrix();
            Object oRender = Eln.clientLiveDataManager.getData(item, 1);
            if (oRender == null) {
                oRender = Eln.clientLiveDataManager.newData(item, new RenderStorage(this.viewRange, this.viewYAlpha, this.resWidth, this.resHeight), 1);
            }
            RenderStorage render = (RenderStorage)oRender;
            render.generate(e.field_70170_p, e.field_70165_t, Utils.getHeadPosY(e), e.field_70161_v, e.field_70177_z * (float)Math.PI / 180.0f, e.field_70125_A * (float)Math.PI / 180.0f);
            float scale = 1.0f / (float)this.resWidth * 0.5f;
            float p = 0.015625f;
            GL11.glTranslatef((float)0.90668f, (float)0.163f, (float)-0.25078f);
            GL11.glRotatef((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)scale, (float)(-scale), (float)1.0f);
            render.draw();
            GL11.glPopMatrix();
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            int count = 0;
            for (int y = 0; y < this.resHeight; y += 6) {
                for (int x = 0; x < this.resHeight; x += 6) {
                    r += render.screenRed[y][x];
                    g += render.screenGreen[y][x];
                    b += render.screenBlue[y][x];
                    ++count;
                }
            }
            UtilsClient.drawHalo(this.screenLuma, r /= (float)count, g /= (float)count, b /= (float)count, e, false);
        }
        if (drawScreen) {
            if (state == 0) {
                GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                this.led.draw();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.buttons.draw();
            }
            UtilsClient.disableLight();
            if (state != 0) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.buttons.draw();
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                switch (state) {
                    case 1: {
                        r = 0.9f;
                        g = 0.4f;
                        b = 0.0f;
                        break;
                    }
                    case 2: {
                        r = 0.0f;
                        g = 1.0f;
                        b = 0.0f;
                        break;
                    }
                    case 3: {
                        r = 1.0f;
                        g = 0.0f;
                        b = 0.0f;
                        break;
                    }
                }
                GL11.glColor4f((float)(r * 0.6f), (float)(g * 0.6f), (float)(b * 0.6f), (float)1.0f);
                this.led.draw();
                UtilsClient.enableBlend();
                UtilsClient.drawHaloNoLightSetup(this.ledHalo, r, g, b, e, false);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            switch (state) {
                case 1: {
                    this.textInit.draw();
                    break;
                }
                case 2: {
                    this.textRun.draw();
                    int batLevel = Math.min(this.textBat.length - 1, (int)(energy / this.energyStorage * (double)this.textBat.length + 0.5));
                    this.textBat[batLevel].draw();
                    break;
                }
            }
            UtilsClient.enableBlend();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int breakLevel = this.getDamage(item) / this.damagePerBreakLevel;
            if (state == 0) {
                breakLevel = Math.min(breakLevel, this.screenDamage.length - 1);
            }
            for (int idx = 0; idx < breakLevel && idx != this.screenDamage.length; ++idx) {
                this.screenDamage[Math.min(this.screenDamage.length - 1, breakLevel - 1) - idx].draw();
            }
            UtilsClient.disableBlend();
            UtilsClient.enableLight();
        }
        GL11.glPopMatrix();
    }

    @Override
    public void electricalItemUpdate(ItemStack stack, double time) {
        double energy = this.getEnergy(stack);
        byte state = this.getState(stack);
        switch (state) {
            case 0: {
                break;
            }
            default: {
                energy -= this.dischargePower * time;
                if (energy <= 0.0) {
                    this.setState(stack, (byte)0);
                    this.setEnergy(stack, 0.0);
                    return;
                }
                this.setEnergy(stack, energy);
            }
        }
    }

    public static class RenderStorage {
        float camDist;
        float viewRange;
        float viewYAlpha;
        float viewXAlpha;
        public int resWidth;
        public int resHeight;
        float[][] screenRed;
        float[][] screenBlue;
        float[][] screenGreen;
        short[][][] worldBlocks;
        int worldBlocksDim;
        int worldBlocksDim2;
        public static float[] blockKeyFactor;

        public RenderStorage(float viewRange, float viewYAlpha, int resWidth, int resHeight) {
            this.viewRange = viewRange;
            this.viewYAlpha = viewYAlpha;
            this.camDist = (float)((double)(resWidth / 2) / Math.tan(viewYAlpha / 2.0f));
            this.resWidth = resWidth;
            this.resHeight = resHeight;
            this.worldBlocksDim = (int)(viewRange * 2.0f + 3.0f);
            this.worldBlocksDim2 = this.worldBlocksDim / 2;
            this.screenRed = new float[resHeight][resWidth];
            this.screenBlue = new float[resHeight][resWidth];
            this.screenGreen = new float[resHeight][resWidth];
            this.worldBlocks = new short[this.worldBlocksDim][this.worldBlocksDim][this.worldBlocksDim];
        }

        public static float[] getBlockKeyFactor() {
            if (blockKeyFactor == null) {
                blockKeyFactor = new float[65536];
                for (int blockId = 0; blockId < 4096; ++blockId) {
                    for (int meta = 0; meta < 16; ++meta) {
                        RenderStorage.blockKeyFactor[blockId + (meta << 12)] = 0.0f;
                    }
                }
            }
            for (OreScannerConfigElement c : Eln.oreScannerConfig) {
                if (c.blockKey < 0 || c.blockKey >= blockKeyFactor.length) continue;
                RenderStorage.blockKeyFactor[c.blockKey] = c.factor;
            }
            return blockKeyFactor;
        }

        public void generate(World w, double posX, double posY, double posZ, float alphaY, float alphaX) {
            float[] blockKeyFactor = RenderStorage.getBlockKeyFactor();
            long start2 = System.nanoTime();
            int posXint = (int)Math.round(posX);
            int posYint = (int)Math.round(posY);
            int posZint = (int)Math.round(posZ);
            for (int z = 0; z < this.worldBlocksDim; ++z) {
                for (int y = 0; y < this.worldBlocksDim; ++y) {
                    for (int x = 0; x < this.worldBlocksDim; ++x) {
                        this.worldBlocks[x][y][z] = -1;
                    }
                }
            }
            for (int screenY = 0; screenY < this.resHeight; ++screenY) {
                int i = 0;
                ++i;
                for (int screenX = 0; screenX < this.resWidth; ++screenX) {
                    float dBest;
                    float x = (float)(posX - (double)posXint);
                    float y = (float)(posY - (double)posYint);
                    float z = (float)(posZ - (double)posZint);
                    float vx = -(screenX - this.resWidth / 2);
                    float vy = -(screenY - this.resHeight / 2);
                    float vz = this.camDist;
                    float sin = MathHelper.func_76126_a((float)alphaX);
                    float cos = MathHelper.func_76134_b((float)alphaX);
                    float temp = vy;
                    vy = vy * cos - vz * sin;
                    vz = vz * cos + temp * sin;
                    sin = MathHelper.func_76126_a((float)alphaY);
                    cos = MathHelper.func_76134_b((float)alphaY);
                    temp = vx;
                    vx = vx * cos - vz * sin;
                    vz = vz * cos + temp * sin;
                    float normInv = 1.0f / (float)Math.sqrt(vx * vx + vy * vy + vz * vz);
                    vy *= normInv;
                    vz *= normInv;
                    if ((vx *= normInv) == 0.0f) {
                        vx += 1.0E-4f;
                    }
                    if (vy == 0.0f) {
                        vy += 1.0E-4f;
                    }
                    if (vz == 0.0f) {
                        vz += 1.0E-4f;
                    }
                    float vxInv = 1.0f / vx;
                    float vyInv = 1.0f / vy;
                    float vzInv = 1.0f / vz;
                    float stackRed = 0.0f;
                    float stackBlue = 0.0f;
                    float stackGreen = 0.0f;
                    for (float d = 0.0f; d < this.viewRange; d += dBest) {
                        float xFloor = MathHelper.func_76141_d((float)x);
                        float yFloor = MathHelper.func_76141_d((float)y);
                        float zFloor = MathHelper.func_76141_d((float)z);
                        float dx = x - xFloor;
                        float dy = y - yFloor;
                        float dz = z - zFloor;
                        dx = vx > 0.0f ? (1.0f - dx) * vxInv : -dx * vxInv;
                        dy = vy > 0.0f ? (1.0f - dy) * vyInv : -dy * vyInv;
                        dz = vz > 0.0f ? (1.0f - dz) * vzInv : -dz * vzInv;
                        dBest = Math.min(Math.min(dx, dy), dz) + 0.01f;
                        int xInt = (int)xFloor + this.worldBlocksDim2;
                        int yInt = (int)yFloor + this.worldBlocksDim2;
                        int zInt = (int)zFloor + this.worldBlocksDim2;
                        int blockKey = this.worldBlocks[xInt][yInt][zInt];
                        if (blockKey < 0) {
                            blockKey += 65536;
                        }
                        if (blockKey == 65535) {
                            ExtendedBlockStorage storage;
                            Chunk chunk;
                            int xBlock = posXint + (int)xFloor;
                            int yBlock = posYint + (int)yFloor;
                            int zBlock = posZint + (int)zFloor;
                            blockKey = 0;
                            if (yBlock >= 0 && yBlock < 256 && (chunk = w.func_72938_d(xBlock, zBlock)) != null && (storage = chunk.func_76587_i()[yBlock >> 4]) != null) {
                                int xLocal = xBlock & 0xF;
                                int yLocal = yBlock & 0xF;
                                int zLocal = zBlock & 0xF;
                                int blockId = storage.func_76658_g()[yLocal << 8 | zLocal << 4 | xLocal] & 0xFF;
                                if (storage.func_76660_i() != null) {
                                    blockId |= storage.func_76660_i().func_76582_a(xLocal, yLocal, zLocal) << 8;
                                }
                                blockKey = blockId + (storage.func_76665_b(xLocal, yLocal, zLocal) << 12);
                            }
                            if (blockKey >= 65536) {
                                blockKey = 0;
                            }
                            this.worldBlocks[xInt][yInt][zInt] = (short)blockKey;
                        }
                        float dToStack = d + dBest < this.viewRange ? dBest : this.viewRange - d;
                        stackGreen += blockKeyFactor[blockKey] * dToStack;
                        Block b = Block.func_149729_e((int)(blockKey & 0xFFF));
                        if (b != Blocks.field_150350_a && b != Eln.lightBlock) {
                            stackRed = b.func_149662_c() ? (stackRed += 0.2f * dToStack) : (stackRed += 0.1f * dToStack);
                        } else {
                            stackBlue += 0.06f * dToStack;
                        }
                        x += vx * dBest;
                        y += vy * dBest;
                        z += vz * dBest;
                    }
                    this.screenRed[screenY][screenX] = stackRed - stackGreen * 0.0f;
                    this.screenGreen[screenY][screenX] = stackGreen;
                    this.screenBlue[screenY][screenX] = stackBlue - stackGreen * 0.0f;
                }
            }
            long end = System.nanoTime();
        }

        float noiseRand() {
            return ((float)Math.random() - 0.5f) * 0.03f;
        }

        public void draw() {
            this.draw(1.0f, 1.0f, 1.0f);
        }

        public void draw(float redFactor, float greenFactor, float blueFactor) {
            long start2 = System.nanoTime();
            UtilsClient.disableLight();
            UtilsClient.disableTexture();
            for (int screenY = 0; screenY < this.resHeight; ++screenY) {
                GL11.glBegin((int)8);
                for (int screenX = 0; screenX < this.resWidth + 1; ++screenX) {
                    if (screenX != this.resWidth) {
                        GL11.glColor3f((float)(this.screenRed[screenY][screenX] * redFactor + this.noiseRand()), (float)(this.screenGreen[screenY][screenX] * greenFactor + this.noiseRand()), (float)(this.screenBlue[screenY][screenX] * blueFactor + this.noiseRand()));
                    }
                    GL11.glVertex3f((float)screenX, (float)screenY, (float)0.0f);
                    GL11.glVertex3f((float)screenX, (float)(screenY + 1), (float)0.0f);
                }
                GL11.glEnd();
            }
            UtilsClient.enableTexture();
            UtilsClient.enableLight();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            long end = System.nanoTime();
        }

        public static class OreScannerConfigElement {
            public int blockKey;
            public float factor;

            public OreScannerConfigElement(int blockKey, float factor) {
                this.blockKey = blockKey;
                this.factor = factor;
            }
        }
    }
}

