/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.libs.org.apache.commons.math3.analysis.interpolation;

import mods.eln.libs.org.apache.commons.math3.analysis.MultivariateFunction;
import mods.eln.libs.org.apache.commons.math3.analysis.interpolation.MicrosphereInterpolatingFunction;
import mods.eln.libs.org.apache.commons.math3.analysis.interpolation.MultivariateInterpolator;
import mods.eln.libs.org.apache.commons.math3.exception.DimensionMismatchException;
import mods.eln.libs.org.apache.commons.math3.exception.NoDataException;
import mods.eln.libs.org.apache.commons.math3.exception.NotPositiveException;
import mods.eln.libs.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import mods.eln.libs.org.apache.commons.math3.exception.NullArgumentException;
import mods.eln.libs.org.apache.commons.math3.random.UnitSphereRandomVectorGenerator;

public class MicrosphereInterpolator
implements MultivariateInterpolator {
    public static final int DEFAULT_MICROSPHERE_ELEMENTS = 2000;
    public static final int DEFAULT_BRIGHTNESS_EXPONENT = 2;
    private final int microsphereElements;
    private final int brightnessExponent;

    public MicrosphereInterpolator() {
        this(2000, 2);
    }

    public MicrosphereInterpolator(int elements, int exponent) throws NotPositiveException, NotStrictlyPositiveException {
        if (exponent < 0) {
            throw new NotPositiveException(exponent);
        }
        if (elements <= 0) {
            throw new NotStrictlyPositiveException(elements);
        }
        this.microsphereElements = elements;
        this.brightnessExponent = exponent;
    }

    public MultivariateFunction interpolate(double[][] xval, double[] yval) throws DimensionMismatchException, NoDataException, NullArgumentException {
        UnitSphereRandomVectorGenerator rand = new UnitSphereRandomVectorGenerator(xval[0].length);
        return new MicrosphereInterpolatingFunction(xval, yval, this.brightnessExponent, this.microsphereElements, rand);
    }
}

