/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.libs.org.apache.commons.math3.genetics;

import java.util.ArrayList;
import java.util.List;
import mods.eln.libs.org.apache.commons.math3.exception.MathIllegalArgumentException;
import mods.eln.libs.org.apache.commons.math3.exception.util.LocalizedFormats;
import mods.eln.libs.org.apache.commons.math3.genetics.Chromosome;
import mods.eln.libs.org.apache.commons.math3.genetics.GeneticAlgorithm;
import mods.eln.libs.org.apache.commons.math3.genetics.MutationPolicy;
import mods.eln.libs.org.apache.commons.math3.genetics.RandomKey;

public class RandomKeyMutation
implements MutationPolicy {
    public Chromosome mutate(Chromosome original) throws MathIllegalArgumentException {
        if (!(original instanceof RandomKey)) {
            throw new MathIllegalArgumentException(LocalizedFormats.RANDOMKEY_MUTATION_WRONG_CLASS, original.getClass().getSimpleName());
        }
        RandomKey originalRk = (RandomKey)original;
        List repr = originalRk.getRepresentation();
        int rInd = GeneticAlgorithm.getRandomGenerator().nextInt(repr.size());
        ArrayList newRepr = new ArrayList(repr);
        newRepr.set(rInd, GeneticAlgorithm.getRandomGenerator().nextDouble());
        return originalRk.newFixedLengthChromosome(newRepr);
    }
}

