/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.libs.org.apache.commons.math3.geometry.euclidean.twod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mods.eln.libs.org.apache.commons.math3.exception.MathInternalError;
import mods.eln.libs.org.apache.commons.math3.geometry.Point;
import mods.eln.libs.org.apache.commons.math3.geometry.euclidean.oned.Euclidean1D;
import mods.eln.libs.org.apache.commons.math3.geometry.euclidean.oned.Interval;
import mods.eln.libs.org.apache.commons.math3.geometry.euclidean.oned.IntervalsSet;
import mods.eln.libs.org.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import mods.eln.libs.org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import mods.eln.libs.org.apache.commons.math3.geometry.euclidean.twod.Line;
import mods.eln.libs.org.apache.commons.math3.geometry.euclidean.twod.Segment;
import mods.eln.libs.org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import mods.eln.libs.org.apache.commons.math3.geometry.partitioning.AbstractRegion;
import mods.eln.libs.org.apache.commons.math3.geometry.partitioning.AbstractSubHyperplane;
import mods.eln.libs.org.apache.commons.math3.geometry.partitioning.BSPTree;
import mods.eln.libs.org.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import mods.eln.libs.org.apache.commons.math3.geometry.partitioning.BoundaryAttribute;
import mods.eln.libs.org.apache.commons.math3.geometry.partitioning.Side;
import mods.eln.libs.org.apache.commons.math3.geometry.partitioning.SubHyperplane;
import mods.eln.libs.org.apache.commons.math3.geometry.partitioning.utilities.AVLTree;
import mods.eln.libs.org.apache.commons.math3.geometry.partitioning.utilities.OrderedTuple;
import mods.eln.libs.org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonsSet
extends AbstractRegion<Euclidean2D, Euclidean1D> {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;
    private Vector2D[][] vertices;

    public PolygonsSet(double tolerance) {
        super(tolerance);
    }

    public PolygonsSet(BSPTree<Euclidean2D> tree, double tolerance) {
        super(tree, tolerance);
    }

    public PolygonsSet(Collection<SubHyperplane<Euclidean2D>> boundary, double tolerance) {
        super(boundary, tolerance);
    }

    public PolygonsSet(double xMin, double xMax, double yMin, double yMax, double tolerance) {
        super(PolygonsSet.boxBoundary(xMin, xMax, yMin, yMax, tolerance), tolerance);
    }

    public PolygonsSet(double hyperplaneThickness, Vector2D ... vertices) {
        super(PolygonsSet.verticesToTree(hyperplaneThickness, vertices), hyperplaneThickness);
    }

    @Deprecated
    public PolygonsSet() {
        this(1.0E-10);
    }

    @Deprecated
    public PolygonsSet(BSPTree<Euclidean2D> tree) {
        this(tree, 1.0E-10);
    }

    @Deprecated
    public PolygonsSet(Collection<SubHyperplane<Euclidean2D>> boundary) {
        this(boundary, 1.0E-10);
    }

    @Deprecated
    public PolygonsSet(double xMin, double xMax, double yMin, double yMax) {
        this(xMin, xMax, yMin, yMax, 1.0E-10);
    }

    private static Line[] boxBoundary(double xMin, double xMax, double yMin, double yMax, double tolerance) {
        if (xMin >= xMax - tolerance || yMin >= yMax - tolerance) {
            return null;
        }
        Vector2D minMin = new Vector2D(xMin, yMin);
        Vector2D minMax = new Vector2D(xMin, yMax);
        Vector2D maxMin = new Vector2D(xMax, yMin);
        Vector2D maxMax = new Vector2D(xMax, yMax);
        return new Line[]{new Line(minMin, maxMin, tolerance), new Line(maxMin, maxMax, tolerance), new Line(maxMax, minMax, tolerance), new Line(minMax, minMin, tolerance)};
    }

    private static BSPTree<Euclidean2D> verticesToTree(double hyperplaneThickness, Vector2D ... vertices) {
        int n = vertices.length;
        if (n == 0) {
            return new BSPTree<Euclidean2D>(Boolean.TRUE);
        }
        Vertex[] vArray = new Vertex[n];
        for (int i = 0; i < n; ++i) {
            vArray[i] = new Vertex(vertices[i]);
        }
        ArrayList<Edge> edges = new ArrayList<Edge>(n);
        for (int i = 0; i < n; ++i) {
            Vertex start2 = vArray[i];
            Vertex end = vArray[(i + 1) % n];
            Line line = start2.sharedLineWith(end);
            if (line == null) {
                line = new Line(start2.getLocation(), end.getLocation(), hyperplaneThickness);
            }
            edges.add(new Edge(start2, end, line));
            for (Vertex vertex : vArray) {
                if (vertex == start2 || vertex == end || !(FastMath.abs(line.getOffset(vertex.getLocation())) <= hyperplaneThickness)) continue;
                vertex.bindWith(line);
            }
        }
        BSPTree<Euclidean2D> tree = new BSPTree<Euclidean2D>();
        PolygonsSet.insertEdges(hyperplaneThickness, tree, edges);
        return tree;
    }

    private static void insertEdges(double hyperplaneThickness, BSPTree<Euclidean2D> node, List<Edge> edges) {
        int index = 0;
        Edge inserted = null;
        while (inserted == null && index < edges.size()) {
            if ((inserted = edges.get(index++)).getNode() == null) {
                if (node.insertCut(inserted.getLine())) {
                    inserted.setNode(node);
                    continue;
                }
                inserted = null;
                continue;
            }
            inserted = null;
        }
        if (inserted == null) {
            BSPTree<Euclidean2D> parent = node.getParent();
            if (parent == null || node == parent.getMinus()) {
                node.setAttribute(Boolean.TRUE);
            } else {
                node.setAttribute(Boolean.FALSE);
            }
            return;
        }
        ArrayList<Edge> plusList = new ArrayList<Edge>();
        ArrayList<Edge> minusList = new ArrayList<Edge>();
        block5: for (Edge edge : edges) {
            Side startSide;
            if (edge == inserted) continue;
            double startOffset = inserted.getLine().getOffset(edge.getStart().getLocation());
            double endOffset = inserted.getLine().getOffset(edge.getEnd().getLocation());
            Side side = FastMath.abs(startOffset) <= hyperplaneThickness ? Side.HYPER : (startSide = startOffset < 0.0 ? Side.MINUS : Side.PLUS);
            Side endSide = FastMath.abs(endOffset) <= hyperplaneThickness ? Side.HYPER : (endOffset < 0.0 ? Side.MINUS : Side.PLUS);
            switch (startSide) {
                case PLUS: {
                    Vertex splitPoint;
                    if (endSide == Side.MINUS) {
                        splitPoint = edge.split(inserted.getLine());
                        minusList.add(splitPoint.getOutgoing());
                        plusList.add(splitPoint.getIncoming());
                        continue block5;
                    }
                    plusList.add(edge);
                    continue block5;
                }
                case MINUS: {
                    Vertex splitPoint;
                    if (endSide == Side.PLUS) {
                        splitPoint = edge.split(inserted.getLine());
                        minusList.add(splitPoint.getIncoming());
                        plusList.add(splitPoint.getOutgoing());
                        continue block5;
                    }
                    minusList.add(edge);
                    continue block5;
                }
            }
            if (endSide == Side.PLUS) {
                plusList.add(edge);
                continue;
            }
            if (endSide != Side.MINUS) continue;
            minusList.add(edge);
        }
        if (!plusList.isEmpty()) {
            PolygonsSet.insertEdges(hyperplaneThickness, node.getPlus(), plusList);
        } else {
            node.getPlus().setAttribute(Boolean.FALSE);
        }
        if (!minusList.isEmpty()) {
            PolygonsSet.insertEdges(hyperplaneThickness, node.getMinus(), minusList);
        } else {
            node.getMinus().setAttribute(Boolean.TRUE);
        }
    }

    public PolygonsSet buildNew(BSPTree<Euclidean2D> tree) {
        return new PolygonsSet(tree, this.getTolerance());
    }

    @Override
    protected void computeGeometricalProperties() {
        Vector2D[][] v = this.getVertices();
        if (v.length == 0) {
            BSPTree tree = this.getTree(false);
            if (tree.getCut() == null && ((Boolean)tree.getAttribute()).booleanValue()) {
                this.setSize(Double.POSITIVE_INFINITY);
                this.setBarycenter(Vector2D.NaN);
            } else {
                this.setSize(0.0);
                this.setBarycenter(new Vector2D(0.0, 0.0));
            }
        } else if (v[0][0] == null) {
            this.setSize(Double.POSITIVE_INFINITY);
            this.setBarycenter(Vector2D.NaN);
        } else {
            double sum = 0.0;
            double sumX = 0.0;
            double sumY = 0.0;
            for (Vector2D[] loop : v) {
                double x1 = loop[loop.length - 1].getX();
                double y1 = loop[loop.length - 1].getY();
                for (Vector2D point : loop) {
                    double x0 = x1;
                    double y0 = y1;
                    x1 = point.getX();
                    y1 = point.getY();
                    double factor = x0 * y1 - y0 * x1;
                    sum += factor;
                    sumX += factor * (x0 + x1);
                    sumY += factor * (y0 + y1);
                }
            }
            if (sum < 0.0) {
                this.setSize(Double.POSITIVE_INFINITY);
                this.setBarycenter(Vector2D.NaN);
            } else {
                this.setSize(sum / 2.0);
                this.setBarycenter(new Vector2D(sumX / (3.0 * sum), sumY / (3.0 * sum)));
            }
        }
    }

    public Vector2D[][] getVertices() {
        if (this.vertices == null) {
            if (this.getTree(false).getCut() == null) {
                this.vertices = new Vector2D[0][];
            } else {
                SegmentsBuilder visitor = new SegmentsBuilder();
                this.getTree(true).visit(visitor);
                AVLTree<ComparableSegment> sorted2 = visitor.getSorted();
                ArrayList<List<ComparableSegment>> loops = new ArrayList<List<ComparableSegment>>();
                while (!sorted2.isEmpty()) {
                    AVLTree.Node node = sorted2.getSmallest();
                    List<ComparableSegment> loop = this.followLoop(node, sorted2);
                    if (loop == null) continue;
                    loops.add(loop);
                }
                this.vertices = new Vector2D[loops.size()][];
                int i = 0;
                for (List list : loops) {
                    int j;
                    Vector2D[] array;
                    if (list.size() < 2) {
                        Line line = ((ComparableSegment)list.get(0)).getLine();
                        this.vertices[i++] = new Vector2D[]{null, line.toSpace((Point)new Vector1D(-3.4028234663852886E38)), line.toSpace((Point)new Vector1D(3.4028234663852886E38))};
                        continue;
                    }
                    if (((ComparableSegment)list.get(0)).getStart() == null) {
                        array = new Vector2D[list.size() + 2];
                        j = 0;
                        for (Segment segment : list) {
                            double x;
                            if (j == 0) {
                                x = ((Vector1D)segment.getLine().toSubSpace((Point)segment.getEnd())).getX();
                                x -= FastMath.max(1.0, FastMath.abs(x / 2.0));
                                array[j++] = null;
                                array[j++] = segment.getLine().toSpace((Point)new Vector1D(x));
                            }
                            if (j < array.length - 1) {
                                array[j++] = segment.getEnd();
                            }
                            if (j != array.length - 1) continue;
                            x = ((Vector1D)segment.getLine().toSubSpace((Point)segment.getStart())).getX();
                            x += FastMath.max(1.0, FastMath.abs(x / 2.0));
                            array[j++] = segment.getLine().toSpace((Point)new Vector1D(x));
                        }
                        this.vertices[i++] = array;
                        continue;
                    }
                    array = new Vector2D[list.size()];
                    j = 0;
                    for (Segment segment : list) {
                        array[j++] = segment.getStart();
                    }
                    this.vertices[i++] = array;
                }
            }
        }
        return (Vector2D[][])this.vertices.clone();
    }

    private List<ComparableSegment> followLoop(AVLTree.Node node, AVLTree<ComparableSegment> sorted2) {
        boolean open;
        ArrayList<ComparableSegment> loop = new ArrayList<ComparableSegment>();
        ComparableSegment segment = (ComparableSegment)node.getElement();
        loop.add(segment);
        Vector2D globalStart = segment.getStart();
        Vector2D end = segment.getEnd();
        node.delete();
        boolean bl = open = segment.getStart() == null;
        while (end != null && (open || globalStart.distance(end) > 1.0E-10)) {
            AVLTree.Node selectedNode = null;
            Segment selectedSegment = null;
            double selectedDistance = Double.POSITIVE_INFINITY;
            ComparableSegment lowerLeft = new ComparableSegment(end, -1.0E-10, -1.0E-10);
            ComparableSegment upperRight = new ComparableSegment(end, 1.0E-10, 1.0E-10);
            for (AVLTree.Node n = sorted2.getNotSmaller(lowerLeft); n != null && ((ComparableSegment)n.getElement()).compareTo(upperRight) <= 0; n = n.getNext()) {
                segment = (ComparableSegment)n.getElement();
                double distance = end.distance(segment.getStart());
                if (!(distance < selectedDistance)) continue;
                selectedNode = n;
                selectedSegment = segment;
                selectedDistance = distance;
            }
            if (selectedDistance > 1.0E-10) {
                return null;
            }
            end = selectedSegment.getEnd();
            loop.add((ComparableSegment)selectedSegment);
            selectedNode.delete();
        }
        if (loop.size() == 2 && !open) {
            return null;
        }
        if (end == null && !open) {
            throw new MathInternalError();
        }
        return loop;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SegmentsBuilder
    implements BSPTreeVisitor<Euclidean2D> {
        private AVLTree<ComparableSegment> sorted = new AVLTree();

        @Override
        public BSPTreeVisitor.Order visitOrder(BSPTree<Euclidean2D> node) {
            return BSPTreeVisitor.Order.MINUS_SUB_PLUS;
        }

        @Override
        public void visitInternalNode(BSPTree<Euclidean2D> node) {
            BoundaryAttribute attribute = (BoundaryAttribute)node.getAttribute();
            if (attribute.getPlusOutside() != null) {
                this.addContribution(attribute.getPlusOutside(), false);
            }
            if (attribute.getPlusInside() != null) {
                this.addContribution(attribute.getPlusInside(), true);
            }
        }

        @Override
        public void visitLeafNode(BSPTree<Euclidean2D> node) {
        }

        private void addContribution(SubHyperplane<Euclidean2D> sub, boolean reversed) {
            AbstractSubHyperplane absSub = (AbstractSubHyperplane)sub;
            Line line = (Line)sub.getHyperplane();
            List<Interval> intervals = ((IntervalsSet)absSub.getRemainingRegion()).asList();
            for (Interval i : intervals) {
                Point end;
                Point start2 = Double.isInfinite(i.getInf()) ? null : line.toSpace((Point)new Vector1D(i.getInf()));
                Point point = end = Double.isInfinite(i.getSup()) ? null : line.toSpace((Point)new Vector1D(i.getSup()));
                if (reversed) {
                    this.sorted.insert(new ComparableSegment((Vector2D)end, (Vector2D)start2, line.getReverse()));
                    continue;
                }
                this.sorted.insert(new ComparableSegment((Vector2D)start2, (Vector2D)end, line));
            }
        }

        public AVLTree<ComparableSegment> getSorted() {
            return this.sorted;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComparableSegment
    extends Segment
    implements Comparable<ComparableSegment> {
        private OrderedTuple sortingKey;

        public ComparableSegment(Vector2D start2, Vector2D end, Line line) {
            super(start2, end, line);
            this.sortingKey = start2 == null ? new OrderedTuple(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY) : new OrderedTuple(start2.getX(), start2.getY());
        }

        public ComparableSegment(Vector2D start2, double dx, double dy) {
            super(null, null, null);
            this.sortingKey = new OrderedTuple(start2.getX() + dx, start2.getY() + dy);
        }

        @Override
        public int compareTo(ComparableSegment o) {
            return this.sortingKey.compareTo(o.sortingKey);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof ComparableSegment) {
                return this.compareTo((ComparableSegment)other) == 0;
            }
            return false;
        }

        public int hashCode() {
            return this.getStart().hashCode() ^ this.getEnd().hashCode() ^ this.getLine().hashCode() ^ this.sortingKey.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Edge {
        private final Vertex start;
        private final Vertex end;
        private final Line line;
        private BSPTree<Euclidean2D> node;

        public Edge(Vertex start2, Vertex end, Line line) {
            this.start = start2;
            this.end = end;
            this.line = line;
            this.node = null;
            start2.setOutgoing(this);
            end.setIncoming(this);
        }

        public Vertex getStart() {
            return this.start;
        }

        public Vertex getEnd() {
            return this.end;
        }

        public Line getLine() {
            return this.line;
        }

        public void setNode(BSPTree<Euclidean2D> node) {
            this.node = node;
        }

        public BSPTree<Euclidean2D> getNode() {
            return this.node;
        }

        public Vertex split(Line splitLine) {
            Vertex splitVertex = new Vertex(this.line.intersection(splitLine));
            splitVertex.bindWith(splitLine);
            Edge startHalf = new Edge(this.start, splitVertex, this.line);
            Edge endHalf = new Edge(splitVertex, this.end, this.line);
            startHalf.node = this.node;
            endHalf.node = this.node;
            return splitVertex;
        }
    }

    private static class Vertex {
        private final Vector2D location;
        private Edge incoming;
        private Edge outgoing;
        private final List<Line> lines;

        public Vertex(Vector2D location) {
            this.location = location;
            this.incoming = null;
            this.outgoing = null;
            this.lines = new ArrayList<Line>();
        }

        public Vector2D getLocation() {
            return this.location;
        }

        public void bindWith(Line line) {
            this.lines.add(line);
        }

        public Line sharedLineWith(Vertex vertex) {
            for (Line line1 : this.lines) {
                for (Line line2 : vertex.lines) {
                    if (line1 != line2) continue;
                    return line1;
                }
            }
            return null;
        }

        public void setIncoming(Edge incoming) {
            this.incoming = incoming;
            this.bindWith(incoming.getLine());
        }

        public Edge getIncoming() {
            return this.incoming;
        }

        public void setOutgoing(Edge outgoing) {
            this.outgoing = outgoing;
            this.bindWith(outgoing.getLine());
        }

        public Edge getOutgoing() {
            return this.outgoing;
        }
    }
}

