/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.io.DataOutputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import mods.eln.Eln;
import mods.eln.mechanical.GeneratorDescriptor;
import mods.eln.mechanical.ShaftNetwork;
import mods.eln.mechanical.ShaftNetworkKt;
import mods.eln.mechanical.SimpleShaftElement;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.misc.IRootSystemPreStepProcess;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sim.process.heater.ElectricalLoadHeatThermalLoad;
import net.minecraft.entity.player.EntityPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002RSB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000204H\u0016J\u001c\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u0001092\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J\u001a\u0010<\u001a\u0004\u0018\u00010=2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016J\u001c\u0010>\u001a\u00020,2\b\u00108\u001a\u0004\u0018\u0001092\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J\u0014\u0010?\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020A0@H\u0016J\u000e\u0010B\u001a\u0002042\u0006\u0010C\u001a\u00020 J\u0012\u0010D\u001a\u00020A2\b\u00108\u001a\u0004\u0018\u000109H\u0016J\u0010\u0010E\u001a\u0002042\u0006\u0010F\u001a\u00020GH\u0016J4\u0010H\u001a\u00020I2\b\u0010J\u001a\u0004\u0018\u00010K2\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020M2\u0006\u0010O\u001a\u00020MH\u0016J\u001a\u0010P\u001a\n Q*\u0004\u0018\u00010A0A2\b\u00108\u001a\u0004\u0018\u000109H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00060\u0010R\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001aR\u0018\u0010'\u001a\u00060(R\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020,X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u000200X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102\u00a8\u0006T"}, d2={"Lmods/eln/mechanical/GeneratorElement;", "Lmods/eln/mechanical/SimpleShaftElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "desc_", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "desc", "Lmods/eln/mechanical/GeneratorDescriptor;", "getDesc", "()Lmods/eln/mechanical/GeneratorDescriptor;", "electricalPowerSource", "Lmods/eln/sim/mna/component/VoltageSource;", "getElectricalPowerSource$ElectricalAge_release_main", "()Lmods/eln/sim/mna/component/VoltageSource;", "electricalProcess", "Lmods/eln/mechanical/GeneratorElement$GeneratorElectricalProcess;", "getElectricalProcess$ElectricalAge_release_main", "()Lmods/eln/mechanical/GeneratorElement$GeneratorElectricalProcess;", "heater", "Lmods/eln/sim/process/heater/ElectricalLoadHeatThermalLoad;", "getHeater$ElectricalAge_release_main", "()Lmods/eln/sim/process/heater/ElectricalLoadHeatThermalLoad;", "inputLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getInputLoad$ElectricalAge_release_main", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "inputToPositiveResistor", "Lmods/eln/sim/mna/component/Resistor;", "getInputToPositiveResistor$ElectricalAge_release_main", "()Lmods/eln/sim/mna/component/Resistor;", "lastE", "", "getLastE", "()D", "setLastE", "(D)V", "positiveLoad", "getPositiveLoad$ElectricalAge_release_main", "shaftProcess", "Lmods/eln/mechanical/GeneratorElement$GeneratorShaftProcess;", "getShaftProcess$ElectricalAge_release_main", "()Lmods/eln/mechanical/GeneratorElement$GeneratorShaftProcess;", "thermal", "Lmods/eln/sim/nbt/NbtThermalLoad;", "getThermal$ElectricalAge_release_main", "()Lmods/eln/sim/nbt/NbtThermalLoad;", "thermalLoadWatchDog", "Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "getThermalLoadWatchDog$ElectricalAge_release_main", "()Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "connectJob", "", "disconnectJob", "getConnectionMask", "", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "getThermalLoad", "getWaila", "", "", "maybePublishE", "E", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "onBlockActivated", "", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "vx", "", "vy", "vz", "thermoMeterString", "kotlin.jvm.PlatformType", "GeneratorElectricalProcess", "GeneratorShaftProcess", "ElectricalAge-release_main"})
public final class GeneratorElement
extends SimpleShaftElement {
    @NotNull
    private final GeneratorDescriptor desc;
    @NotNull
    private final NbtElectricalLoad inputLoad;
    @NotNull
    private final NbtElectricalLoad positiveLoad;
    @NotNull
    private final Resistor inputToPositiveResistor;
    @NotNull
    private final VoltageSource electricalPowerSource;
    @NotNull
    private final GeneratorElectricalProcess electricalProcess;
    @NotNull
    private final GeneratorShaftProcess shaftProcess;
    @NotNull
    private final NbtThermalLoad thermal;
    @NotNull
    private final ElectricalLoadHeatThermalLoad heater;
    @NotNull
    private final ThermalLoadWatchDog thermalLoadWatchDog;
    private double lastE;

    @NotNull
    public final GeneratorDescriptor getDesc() {
        return this.desc;
    }

    @NotNull
    public final NbtElectricalLoad getInputLoad$ElectricalAge_release_main() {
        return this.inputLoad;
    }

    @NotNull
    public final NbtElectricalLoad getPositiveLoad$ElectricalAge_release_main() {
        return this.positiveLoad;
    }

    @NotNull
    public final Resistor getInputToPositiveResistor$ElectricalAge_release_main() {
        return this.inputToPositiveResistor;
    }

    @NotNull
    public final VoltageSource getElectricalPowerSource$ElectricalAge_release_main() {
        return this.electricalPowerSource;
    }

    @NotNull
    public final GeneratorElectricalProcess getElectricalProcess$ElectricalAge_release_main() {
        return this.electricalProcess;
    }

    @NotNull
    public final GeneratorShaftProcess getShaftProcess$ElectricalAge_release_main() {
        return this.shaftProcess;
    }

    @NotNull
    public final NbtThermalLoad getThermal$ElectricalAge_release_main() {
        return this.thermal;
    }

    @NotNull
    public final ElectricalLoadHeatThermalLoad getHeater$ElectricalAge_release_main() {
        return this.heater;
    }

    @NotNull
    public final ThermalLoadWatchDog getThermalLoadWatchDog$ElectricalAge_release_main() {
        return this.thermalLoadWatchDog;
    }

    public final double getLastE() {
        return this.lastE;
    }

    public final void setLastE(double d) {
        this.lastE = d;
    }

    public final void maybePublishE(double E) {
        if (Math.abs(E - this.lastE) / (double)this.desc.getNominalP() > 0.01) {
            this.lastE = E;
            this.needPublish();
        }
    }

    @Override
    public void connectJob() {
        super.connectJob();
        Eln.simulator.mna.addProcess(this.electricalProcess);
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        Eln.simulator.mna.removeProcess(this.electricalProcess);
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkParameterIsNotNull((Object)side, "side");
        Intrinsics.checkParameterIsNotNull((Object)lrdu, "lrdu");
        if (Intrinsics.areEqual((Object)lrdu, (Object)LRDU.Down) ^ true) {
            return null;
        }
        Direction direction = side;
        return Intrinsics.areEqual((Object)direction, (Object)this.front) ? (ElectricalLoad)this.inputLoad : (Intrinsics.areEqual((Object)direction, (Object)this.front.back()) ? (ElectricalLoad)this.inputLoad : (ElectricalLoad)null);
    }

    @Override
    @NotNull
    public NbtThermalLoad getThermalLoad(@Nullable Direction side, @Nullable LRDU lrdu) {
        return this.thermal;
    }

    @Override
    public int getConnectionMask(@Nullable Direction side, @Nullable LRDU lrdu) {
        if (Intrinsics.areEqual((Object)lrdu, (Object)LRDU.Down) && (Intrinsics.areEqual((Object)side, (Object)this.front) || Intrinsics.areEqual((Object)side, (Object)this.front.back()))) {
            return 1;
        }
        return 0;
    }

    @Override
    @NotNull
    public String multiMeterString(@Nullable Direction side) {
        return Utils.plotER(this.getShaft().getEnergy(), this.getShaft().getRads()) + Utils.plotUIP(this.electricalPowerSource.getU(), this.electricalPowerSource.getI());
    }

    @Override
    public String thermoMeterString(@Nullable Direction side) {
        return Utils.plotCelsius("T", this.thermal.getT());
    }

    @Override
    public boolean onBlockActivated(@Nullable EntityPlayer entityPlayer, @Nullable Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkParameterIsNotNull(stream, "stream");
        super.networkSerialize(stream);
        stream.writeDouble(this.lastE);
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Map<String, String> info = MapsKt.mutableMapOf(new Pair[0]);
        String string = Utils.plotEnergy("", this.getShaft().getEnergy());
        Intrinsics.checkExpressionValueIsNotNull(string, "Utils.plotEnergy(\"\", shaft.energy)");
        info.put("Energy", string);
        String string2 = Utils.plotRads("", this.getShaft().getRads());
        Intrinsics.checkExpressionValueIsNotNull(string2, "Utils.plotRads(\"\", shaft.rads)");
        info.put("Speed", string2);
        if (Eln.wailaEasyMode) {
            String string3 = Utils.plotVolt("", this.electricalPowerSource.getU());
            Intrinsics.checkExpressionValueIsNotNull(string3, "Utils.plotVolt(\"\", electricalPowerSource.getU())");
            info.put("Voltage", string3);
            String string4 = Utils.plotAmpere("", this.electricalPowerSource.getI());
            Intrinsics.checkExpressionValueIsNotNull(string4, "Utils.plotAmpere(\"\", electricalPowerSource.getI())");
            info.put("Current", string4);
            String string5 = Utils.plotCelsius("", this.thermal.getT());
            Intrinsics.checkExpressionValueIsNotNull(string5, "Utils.plotCelsius(\"\", thermal.t)");
            info.put("Temperature", string5);
        }
        return info;
    }

    public GeneratorElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor desc_) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(desc_, "desc_");
        super(node, desc_);
        TransparentNodeDescriptor transparentNodeDescriptor = desc_;
        if (transparentNodeDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type mods.eln.mechanical.GeneratorDescriptor");
        }
        this.desc = (GeneratorDescriptor)transparentNodeDescriptor;
        this.inputLoad = new NbtElectricalLoad("inputLoad");
        this.positiveLoad = new NbtElectricalLoad("positiveLoad");
        this.inputToPositiveResistor = new Resistor(this.inputLoad, this.positiveLoad);
        this.electricalPowerSource = new VoltageSource("PowerSource", this.positiveLoad, null);
        this.electricalProcess = new GeneratorElectricalProcess();
        this.shaftProcess = new GeneratorShaftProcess();
        this.thermal = new NbtThermalLoad("thermal");
        this.thermalLoadWatchDog = new ThermalLoadWatchDog();
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalLoadList.add(this.inputLoad);
        this.electricalComponentList.add(this.electricalPowerSource);
        this.electricalComponentList.add(this.inputToPositiveResistor);
        this.electricalProcessList.add(this.shaftProcess);
        this.desc.getCable().applyTo(this.inputLoad);
        this.desc.getCable().applyTo(this.inputToPositiveResistor);
        this.desc.getCable().applyTo(this.positiveLoad);
        this.desc.getThermalLoadInitializer().applyTo(this.thermal);
        this.desc.getThermalLoadInitializer().applyTo(this.thermalLoadWatchDog);
        this.thermal.setAsSlow();
        this.thermalLoadList.add(this.thermal);
        this.thermalLoadWatchDog.set(this.thermal).set(new WorldExplosion(this).machineExplosion());
        this.heater = new ElectricalLoadHeatThermalLoad(this.inputLoad, this.thermal);
        this.thermalFastProcessList.add(this.heater);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lmods/eln/mechanical/GeneratorElement$GeneratorElectricalProcess;", "Lmods/eln/sim/IProcess;", "Lmods/eln/sim/mna/misc/IRootSystemPreStepProcess;", "(Lmods/eln/mechanical/GeneratorElement;)V", "process", "", "time", "", "rootSystemPreStepProcess", "ElectricalAge-release_main"})
    public final class GeneratorElectricalProcess
    implements IProcess,
    IRootSystemPreStepProcess {
        @Override
        public void process(double time) {
            double Ut;
            double targetU = GeneratorElement.this.getDesc().getRtoU().getValue(GeneratorElement.this.getShaft().getRads());
            SubSystem.Th th = GeneratorElement.this.getPositiveLoad$ElectricalAge_release_main().getSubSystem().getTh(GeneratorElement.this.getPositiveLoad$ElectricalAge_release_main(), GeneratorElement.this.getElectricalPowerSource$ElectricalAge_release_main());
            if (targetU < th.U) {
                Ut = th.U * 0.999 + targetU * 0.001;
            } else if (th.isHighImpedance()) {
                Ut = targetU;
            } else {
                double a = 1.0 / th.R;
                double b = (double)GeneratorElement.this.getDesc().getPowerOutPerDeltaU() - th.U / th.R;
                double c = (double)(-GeneratorElement.this.getDesc().getPowerOutPerDeltaU()) * targetU;
                Ut = (-b + Math.sqrt(b * b - (double)4 * a * c)) / ((double)2 * a);
            }
            GeneratorElement.this.getElectricalPowerSource$ElectricalAge_release_main().setU(Ut);
        }

        @Override
        public void rootSystemPreStepProcess() {
            this.process(0.0);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lmods/eln/mechanical/GeneratorElement$GeneratorShaftProcess;", "Lmods/eln/sim/IProcess;", "(Lmods/eln/mechanical/GeneratorElement;)V", "process", "", "time", "", "ElectricalAge-release_main"})
    public final class GeneratorShaftProcess
    implements IProcess {
        @Override
        public void process(double time) {
            double E = GeneratorElement.this.getElectricalPowerSource$ElectricalAge_release_main().getP() * time;
            if (E < 0.0) {
                E *= 0.75;
            }
            GeneratorElement.this.maybePublishE(E / time);
            ShaftNetwork shaftNetwork = GeneratorElement.this.getShaft();
            shaftNetwork.setEnergy(shaftNetwork.getEnergy() - (E += ShaftNetworkKt.getDefaultDrag() * Math.max(GeneratorElement.this.getShaft().getRads(), 10.0)) * GeneratorElement.this.getDesc().getGenerationEfficiency());
            GeneratorElement.this.getThermal$ElectricalAge_release_main().movePowerTo(E * (1.0 - GeneratorElement.this.getDesc().getGenerationEfficiency()));
        }
    }
}

