/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.util.ArrayList;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import mods.eln.mechanical.ShaftElement;
import mods.eln.mechanical.ShaftNeighbour;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.INBTTReady;
import mods.eln.node.NodeManager;
import mods.eln.node.transparent.TransparentNodeElement;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003J\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u000e\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u0000J\u001a\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\r\u0010+\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b,J\u001a\u0010-\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0013\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000e\"\u0004\b\u0017\u0010\u0010R\u001a\u0010\u0018\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000e\"\u0004\b\u001a\u0010\u0010R\u0014\u0010\u001b\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000e\u00a8\u0006."}, d2={"Lmods/eln/mechanical/ShaftNetwork;", "Lmods/eln/misc/INBTTReady;", "first", "Lmods/eln/mechanical/ShaftElement;", "(Lmods/eln/mechanical/ShaftElement;)V", "()V", "elements", "Ljava/util/HashSet;", "getElements", "()Ljava/util/HashSet;", "value", "", "energy", "getEnergy", "()D", "setEnergy", "(D)V", "joulePerRad", "getJoulePerRad", "mass", "getMass", "rads", "getRads", "setRads", "radsLastPublished", "getRadsLastPublished", "setRadsLastPublished", "shapeFactor", "getShapeFactor", "connectShaft", "", "from", "disconnectShaft", "getNeighbours", "Ljava/util/ArrayList;", "Lmods/eln/mechanical/ShaftNeighbour;", "mergeShafts", "other", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "str", "", "rebuildNetwork", "rebuildNetwork$ElectricalAge_release_main", "writeToNBT", "ElectricalAge-release_main"})
public final class ShaftNetwork
implements INBTTReady {
    @NotNull
    private final HashSet<ShaftElement> elements;
    private final double shapeFactor = 0.5;
    private double rads;
    private double radsLastPublished;

    @NotNull
    public final HashSet<ShaftElement> getElements() {
        return this.elements;
    }

    public final double getShapeFactor() {
        return this.shapeFactor;
    }

    public final double getMass() {
        double sum = 0.0;
        for (ShaftElement e : this.elements) {
            sum += e.getShaftMass();
        }
        return sum;
    }

    public final double getRads() {
        return this.rads;
    }

    public final void setRads(double d) {
        this.rads = d;
    }

    public final double getRadsLastPublished() {
        return this.radsLastPublished;
    }

    public final void setRadsLastPublished(double d) {
        this.radsLastPublished = d;
    }

    public final double getJoulePerRad() {
        return this.getMass() * this.getMass() * this.shapeFactor / (double)2;
    }

    public final double getEnergy() {
        return this.getJoulePerRad() * this.rads;
    }

    public final void setEnergy(double value) {
        this.rads = value / this.getJoulePerRad();
        if (this.rads < 0.0) {
            this.rads = 0.0;
        }
        if (this.radsLastPublished > this.rads * 1.05 || this.radsLastPublished < this.rads * 0.95) {
            Iterable $receiver$iv = this.elements;
            for (Object element$iv : $receiver$iv) {
                ShaftElement it = (ShaftElement)element$iv;
                it.needPublish();
            }
            this.radsLastPublished = this.rads;
        }
    }

    public final void mergeShafts(@NotNull ShaftNetwork other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        this.rads = Math.min(this.rads, other.rads);
        boolean bl = Intrinsics.areEqual(other, this) ^ true;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        for (ShaftElement element : other.elements) {
            this.elements.add(element);
            element.setShaft(this);
        }
        other.elements.clear();
    }

    public final void connectShaft(@NotNull ShaftElement from) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        boolean bl = this.elements.contains(from);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ArrayList<ShaftNeighbour> neighbours = this.getNeighbours(from);
        for (ShaftNeighbour neighbour : neighbours) {
            if (!(Intrinsics.areEqual(neighbour.getElement().getShaft(), this) ^ true)) continue;
            this.mergeShafts(neighbour.getElement().getShaft());
            ShaftElement shaftElement = neighbour.getElement();
            Direction direction = neighbour.getSide().getInverse();
            Intrinsics.checkExpressionValueIsNotNull((Object)direction, "neighbour.side.inverse");
            shaftElement.connectedOnSide(direction);
            from.connectedOnSide(neighbour.getSide());
        }
    }

    public final void disconnectShaft(@NotNull ShaftElement from) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        this.elements.remove(from);
        from.setShaft(new ShaftNetwork(from));
        this.rebuildNetwork$ElectricalAge_release_main();
        for (ShaftNeighbour neighbour : this.getNeighbours(from)) {
            ShaftElement shaftElement = neighbour.getElement();
            Direction direction = neighbour.getSide().getInverse();
            Intrinsics.checkExpressionValueIsNotNull((Object)direction, "neighbour.side.inverse");
            shaftElement.disconnectedOnSide(direction);
            from.disconnectedOnSide(neighbour.getSide());
        }
    }

    public final void rebuildNetwork$ElectricalAge_release_main() {
        HashSet unseen = new HashSet(this.elements);
        HashSet<ShaftElement> queue = new HashSet<ShaftElement>();
        ShaftNetwork shaft = this;
        while (unseen.size() > 0) {
            shaft.elements.clear();
            ShaftElement start2 = (ShaftElement)unseen.iterator().next();
            unseen.remove(start2);
            queue.add(start2);
            while (queue.size() > 0) {
                ShaftElement next = (ShaftElement)queue.iterator().next();
                queue.remove(next);
                shaft.elements.add(next);
                next.setShaft(shaft);
                ShaftElement shaftElement = next;
                Intrinsics.checkExpressionValueIsNotNull(shaftElement, "next");
                ArrayList<ShaftNeighbour> neighbours = this.getNeighbours(shaftElement);
                for (ShaftNeighbour neighbour : neighbours) {
                    if (!unseen.contains(neighbour.getElement())) continue;
                    unseen.remove(neighbour.getElement());
                    queue.add(neighbour.getElement());
                }
            }
            shaft = new ShaftNetwork();
        }
    }

    private final ArrayList<ShaftNeighbour> getNeighbours(ShaftElement from) {
        Coordonate c = new Coordonate();
        ArrayList<ShaftNeighbour> ret = new ArrayList<ShaftNeighbour>(6);
        Direction[] directionArray = from.getShaftConnectivity();
        block0: for (int i = 0; i < directionArray.length; ++i) {
            TransparentNodeElement to;
            Direction dir = directionArray[i];
            c.copyFrom(from.coordonate());
            c.move(dir);
            NodeManager nodeManager = NodeManager.instance;
            if (nodeManager == null) {
                Intrinsics.throwNpe();
            }
            if (!((to = nodeManager.getTransparentNodeFromCoordinate(c)) instanceof ShaftElement)) continue;
            Direction[] directionArray2 = ((ShaftElement)((Object)to)).getShaftConnectivity();
            for (int j = 0; j < directionArray2.length; ++j) {
                Direction dir2 = directionArray2[j];
                if (!Intrinsics.areEqual((Object)dir2.getInverse(), (Object)dir)) continue;
                ret.add(new ShaftNeighbour(dir, (ShaftElement)((Object)to)));
                continue block0;
            }
        }
        return ret;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt, @Nullable String str) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        this.rads = nbt.func_74760_g(Intrinsics.stringPlus(str, "rads"));
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt, @Nullable String str) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        nbt.func_74776_a(Intrinsics.stringPlus(str, "rads"), (float)this.rads);
    }

    public ShaftNetwork() {
        this.elements = new HashSet();
        this.shapeFactor = 0.5;
        this.radsLastPublished = this.rads;
    }

    public ShaftNetwork(@NotNull ShaftElement first) {
        Intrinsics.checkParameterIsNotNull(first, "first");
        this();
        this.elements.add(first);
    }
}

