/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.io.DataInputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mods.eln.cable.CableRender;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.cable.CableRenderType;
import mods.eln.mechanical.ShaftRender;
import mods.eln.mechanical.SimpleShaftDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUMask;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010*\u001a\u00020+H\u0016J\u0014\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020+0-J\u0010\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020+2\u0006\u00102\u001a\u000203H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\n\"\u0004\b$\u0010\fR\u0011\u0010%\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010!R\u001a\u0010'\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\n\"\u0004\b)\u0010\f\u00a8\u00064"}, d2={"Lmods/eln/mechanical/ShaftRender;", "Lmods/eln/node/transparent/TransparentNodeElementRender;", "entity", "Lmods/eln/node/transparent/TransparentNodeEntity;", "desc", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNodeEntity;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "angle", "", "getAngle", "()D", "setAngle", "(D)V", "cableRefresh", "", "getCableRefresh", "()Z", "setCableRefresh", "(Z)V", "cableRender", "Lmods/eln/cable/CableRenderDescriptor;", "getCableRender", "()Lmods/eln/cable/CableRenderDescriptor;", "connectionType", "Lmods/eln/cable/CableRenderType;", "getConnectionType", "()Lmods/eln/cable/CableRenderType;", "setConnectionType", "(Lmods/eln/cable/CableRenderType;)V", "Lmods/eln/mechanical/SimpleShaftDescriptor;", "eConn", "Lmods/eln/misc/LRDUMask;", "getEConn", "()Lmods/eln/misc/LRDUMask;", "logRads", "getLogRads", "setLogRads", "mask", "getMask", "rads", "getRads", "setRads", "draw", "", "extra", "Lkotlin/Function0;", "networkUnserialize", "stream", "Ljava/io/DataInputStream;", "refresh", "deltaT", "", "ElectricalAge-release_main"})
public class ShaftRender
extends TransparentNodeElementRender {
    private final SimpleShaftDescriptor desc;
    private double rads;
    private double logRads;
    private double angle;
    @NotNull
    private final LRDUMask eConn;
    @NotNull
    private final LRDUMask mask;
    @Nullable
    private CableRenderType connectionType;
    @Nullable
    private final CableRenderDescriptor cableRender;
    private boolean cableRefresh;

    public final double getRads() {
        return this.rads;
    }

    public final void setRads(double d) {
        this.rads = d;
    }

    public final double getLogRads() {
        return this.logRads;
    }

    public final void setLogRads(double d) {
        this.logRads = d;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final void setAngle(double d) {
        this.angle = d;
    }

    @NotNull
    public final LRDUMask getEConn() {
        return this.eConn;
    }

    @NotNull
    public final LRDUMask getMask() {
        return this.mask;
    }

    @Nullable
    public final CableRenderType getConnectionType() {
        return this.connectionType;
    }

    public final void setConnectionType(@Nullable CableRenderType cableRenderType) {
        this.connectionType = cableRenderType;
    }

    @Nullable
    public CableRenderDescriptor getCableRender() {
        return this.cableRender;
    }

    public final boolean getCableRefresh() {
        return this.cableRefresh;
    }

    public final void setCableRefresh(boolean bl) {
        this.cableRefresh = bl;
    }

    @Override
    public void draw() {
        this.draw(draw.1.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void draw(@NotNull Function0<Unit> extra) {
        Intrinsics.checkParameterIsNotNull(extra, "extra");
        try {
            GL11.glPushMatrix();
            this.front.glRotateXnRef();
            if (Intrinsics.areEqual((Object)this.front, (Object)Direction.XP) || Intrinsics.areEqual((Object)this.front, (Object)Direction.ZP)) {
                this.desc.draw(this.angle);
            } else {
                this.desc.draw(-this.angle);
            }
            extra.invoke();
            Unit ret$iv = Unit.INSTANCE;
        }
        finally {
            GL11.glPopMatrix();
        }
        if (this.getCableRender() != null) {
            try {
                GL11.glPushMatrix();
                if (this.cableRefresh) {
                    this.cableRefresh = false;
                    this.connectionType = CableRender.connectionType(this.tileEntity, this.eConn, this.front.down());
                }
                this.glCableTransforme(this.front.down());
                CableRenderDescriptor cableRenderDescriptor = this.getCableRender();
                if (cableRenderDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                cableRenderDescriptor.bindCableTexture();
                LRDU[] lRDUArray = LRDU.values();
                for (int i = 0; i < lRDUArray.length; ++i) {
                    LRDU lrdu = lRDUArray[i];
                    CableRenderType cableRenderType = this.connectionType;
                    if (cableRenderType == null) {
                        Intrinsics.throwNpe();
                    }
                    Utils.setGlColorFromDye(cableRenderType.otherdry[lrdu.toInt()]);
                    if (!this.eConn.get(lrdu) || Intrinsics.areEqual((Object)lrdu, (Object)this.front.down().getLRDUGoingTo(this.front)) ^ true && Intrinsics.areEqual((Object)lrdu.inverse(), (Object)this.front.down().getLRDUGoingTo(this.front)) ^ true) continue;
                    this.mask.set(1 << lrdu.ordinal());
                    CableRender.drawCable(this.getCableRender(), this.mask, this.connectionType);
                }
                Unit ret$iv = Unit.INSTANCE;
            }
            finally {
                GL11.glPopMatrix();
            }
        }
    }

    @Override
    public void refresh(float deltaT) {
        super.refresh(deltaT);
        this.angle += this.logRads * (double)deltaT;
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkParameterIsNotNull(stream, "stream");
        super.networkUnserialize(stream);
        this.rads = stream.readFloat();
        this.logRads = Math.log(this.rads + 1.0) / Math.log(1.2);
        this.eConn.deserialize(stream);
        this.cableRefresh = true;
    }

    public ShaftRender(@NotNull TransparentNodeEntity entity, @NotNull TransparentNodeDescriptor desc) {
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        Intrinsics.checkParameterIsNotNull(desc, "desc");
        super(entity, desc);
        TransparentNodeDescriptor transparentNodeDescriptor = desc;
        if (transparentNodeDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type mods.eln.mechanical.SimpleShaftDescriptor");
        }
        this.desc = (SimpleShaftDescriptor)transparentNodeDescriptor;
        this.eConn = new LRDUMask();
        this.mask = new LRDUMask();
        this.cableRefresh = true;
        this.mask.set(LRDU.Down, true);
    }
}

