/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.io.DataOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mods.eln.mechanical.ShaftElement;
import mods.eln.mechanical.ShaftNetwork;
import mods.eln.mechanical.ShaftNetworkKt;
import mods.eln.misc.Direction;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.sim.process.destruct.WorldExplosion;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0018H\u0016J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lmods/eln/mechanical/SimpleShaftElement;", "Lmods/eln/node/transparent/TransparentNodeElement;", "Lmods/eln/mechanical/ShaftElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "desc_", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "shaft", "Lmods/eln/mechanical/ShaftNetwork;", "getShaft", "()Lmods/eln/mechanical/ShaftNetwork;", "setShaft", "(Lmods/eln/mechanical/ShaftNetwork;)V", "shaftConnectivity", "", "Lmods/eln/misc/Direction;", "getShaftConnectivity", "()[Lmods/eln/misc/Direction;", "shaftMass", "", "getShaftMass", "()D", "initialize", "", "multiMeterString", "", "side", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "onBreakElement", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "writeToNBT", "ElectricalAge-release_main"})
public abstract class SimpleShaftElement
extends TransparentNodeElement
implements ShaftElement {
    private final double shaftMass = 5.0;
    @NotNull
    private ShaftNetwork shaft;

    @Override
    public double getShaftMass() {
        return this.shaftMass;
    }

    @Override
    @NotNull
    public ShaftNetwork getShaft() {
        return this.shaft;
    }

    @Override
    public void setShaft(@NotNull ShaftNetwork shaftNetwork) {
        Intrinsics.checkParameterIsNotNull(shaftNetwork, "<set-?>");
        this.shaft = shaftNetwork;
    }

    @Override
    @NotNull
    public Direction[] getShaftConnectivity() {
        Direction[] directionArray = new Direction[2];
        Direction direction = this.front.left();
        Intrinsics.checkExpressionValueIsNotNull((Object)direction, "front.left()");
        directionArray[0] = direction;
        Direction direction2 = this.front.right();
        Intrinsics.checkExpressionValueIsNotNull((Object)direction2, "front.right()");
        directionArray[1] = direction2;
        Direction[] elements$iv = directionArray;
        return (Direction[])((Object[])elements$iv);
    }

    @Override
    public void initialize() {
        this.reconnect();
        this.getShaft().connectShaft(this);
    }

    @Override
    public void onBreakElement() {
        super.onBreakElement();
        this.getShaft().disconnectShaft(this);
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkParameterIsNotNull(stream, "stream");
        super.networkSerialize(stream);
        stream.writeFloat((float)this.getShaft().getRads());
        this.node.lrduCubeMask.getTranslate(this.front.down()).serialize(stream);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        super.writeToNBT(nbt);
        this.getShaft().writeToNBT(nbt, "shaft");
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        super.readFromNBT(nbt);
        this.getShaft().readFromNBT(nbt, "shaft");
    }

    @Override
    @NotNull
    public String multiMeterString(@Nullable Direction side) {
        String string = Utils.plotER(this.getShaft().getEnergy(), this.getShaft().getRads());
        Intrinsics.checkExpressionValueIsNotNull(string, "Utils.plotER(shaft.energy, shaft.rads)");
        return string;
    }

    public SimpleShaftElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor desc_) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(desc_, "desc_");
        super(node, desc_);
        this.shaftMass = 5.0;
        this.shaft = new ShaftNetwork(this);
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        this.slowProcessList.add(ShaftNetworkKt.createShaftWatchdog(this).set(exp));
    }

    @Override
    public void connectedOnSide(@NotNull Direction direction) {
        Intrinsics.checkParameterIsNotNull((Object)direction, "direction");
        ShaftElement.DefaultImpls.connectedOnSide(this, direction);
    }

    @Override
    public void disconnectedOnSide(@NotNull Direction direction) {
        Intrinsics.checkParameterIsNotNull((Object)direction, "direction");
        ShaftElement.DefaultImpls.disconnectedOnSide(this, direction);
    }
}

