/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import mods.eln.Eln;
import mods.eln.mechanical.ShaftNetwork;
import mods.eln.mechanical.SimpleShaftElement;
import mods.eln.mechanical.TurbineDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.FuelRegistryKt;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.LRDU;
import mods.eln.misc.RcInterpolator;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementFluidHandler;
import mods.eln.sim.IProcess;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001:B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010'\u001a\u00020\u0015H\u0016J\u001e\u0010(\u001a\u0004\u0018\u00010)2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0014\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020,0+H\u0016J4\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u0001002\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020\f2\u0006\u00103\u001a\u00020\fH\u0016J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\u0012\u00108\u001a\u00020,2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0010\u00109\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0015\u0010\u001c\u001a\u00060\u001dR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006;"}, d2={"Lmods/eln/mechanical/TurbineElement;", "Lmods/eln/mechanical/SimpleShaftElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "desc_", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "desc", "Lmods/eln/mechanical/TurbineDescriptor;", "getDesc", "()Lmods/eln/mechanical/TurbineDescriptor;", "efficiency", "", "getEfficiency", "()F", "setEfficiency", "(F)V", "steamRate", "getSteamRate", "setSteamRate", "tank", "Lmods/eln/node/transparent/TransparentNodeElementFluidHandler;", "getTank", "()Lmods/eln/node/transparent/TransparentNodeElementFluidHandler;", "throttle", "Lmods/eln/sim/nbt/NbtElectricalGateInput;", "getThrottle$ElectricalAge_release_main", "()Lmods/eln/sim/nbt/NbtElectricalGateInput;", "turbineSlowProcess", "Lmods/eln/mechanical/TurbineElement$TurbineSlowProcess;", "getTurbineSlowProcess", "()Lmods/eln/mechanical/TurbineElement$TurbineSlowProcess;", "getConnectionMask", "", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "getFluidHandler", "getThermalLoad", "", "getWaila", "", "", "onBlockActivated", "", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "vx", "vy", "vz", "readFromNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "thermoMeterString", "writeToNBT", "TurbineSlowProcess", "ElectricalAge-release_main"})
public final class TurbineElement
extends SimpleShaftElement {
    @NotNull
    private final TurbineDescriptor desc;
    @NotNull
    private final TransparentNodeElementFluidHandler tank;
    private float steamRate;
    private float efficiency;
    @NotNull
    private final TurbineSlowProcess turbineSlowProcess;
    @NotNull
    private final NbtElectricalGateInput throttle;

    @NotNull
    public final TurbineDescriptor getDesc() {
        return this.desc;
    }

    @NotNull
    public final TransparentNodeElementFluidHandler getTank() {
        return this.tank;
    }

    public final float getSteamRate() {
        return this.steamRate;
    }

    public final void setSteamRate(float f) {
        this.steamRate = f;
    }

    public final float getEfficiency() {
        return this.efficiency;
    }

    public final void setEfficiency(float f) {
        this.efficiency = f;
    }

    @NotNull
    public final TurbineSlowProcess getTurbineSlowProcess() {
        return this.turbineSlowProcess;
    }

    @NotNull
    public final NbtElectricalGateInput getThrottle$ElectricalAge_release_main() {
        return this.throttle;
    }

    @Override
    @NotNull
    public TransparentNodeElementFluidHandler getFluidHandler() {
        return this.tank;
    }

    @Override
    @NotNull
    public NbtElectricalGateInput getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkParameterIsNotNull((Object)side, "side");
        Intrinsics.checkParameterIsNotNull((Object)lrdu, "lrdu");
        return this.throttle;
    }

    @Nullable
    public Void getThermalLoad(@Nullable Direction side, @Nullable LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkParameterIsNotNull((Object)side, "side");
        Intrinsics.checkParameterIsNotNull((Object)lrdu, "lrdu");
        if (Intrinsics.areEqual((Object)lrdu, (Object)LRDU.Down) && (Intrinsics.areEqual((Object)side, (Object)this.front) || Intrinsics.areEqual((Object)side, (Object)this.front.back()))) {
            return 4;
        }
        return 0;
    }

    @Override
    public boolean onBlockActivated(@Nullable EntityPlayer entityPlayer, @Nullable Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    @NotNull
    public String thermoMeterString(@Nullable Direction side) {
        return Utils.plotPercent(" Eff:", this.efficiency) + String.valueOf(this.steamRate) + "mB/s";
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        super.writeToNBT(nbt);
        this.tank.writeToNBT(nbt, "tank");
        this.turbineSlowProcess.writeToNBT(nbt, "proc");
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        super.readFromNBT(nbt);
        this.tank.readFromNBT(nbt, "tank");
        this.turbineSlowProcess.readFromNBT(nbt, "proc");
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Map<String, String> info = MapsKt.mutableMapOf(new Pair[0]);
        String string = Utils.plotRads("", this.getShaft().getRads());
        Intrinsics.checkExpressionValueIsNotNull(string, "Utils.plotRads(\"\", shaft.rads)");
        info.put("Speed", string);
        String string2 = Utils.plotEnergy("", this.getShaft().getEnergy());
        Intrinsics.checkExpressionValueIsNotNull(string2, "Utils.plotEnergy(\"\", shaft.energy)");
        info.put("Energy", string2);
        if (Eln.wailaEasyMode) {
            String string3 = Utils.plotPercent("", this.efficiency);
            Intrinsics.checkExpressionValueIsNotNull(string3, "Utils.plotPercent(\"\", efficiency.toDouble())");
            info.put("Efficency", string3);
            info.put("Fuel usage", Utils.plotBuckets("", (double)this.steamRate / 1000.0) + "/s");
        }
        return info;
    }

    /*
     * WARNING - void declaration
     */
    public TurbineElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor desc_) {
        String[] stringArray;
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(desc_, "desc_");
        super(node, desc_);
        TransparentNodeDescriptor transparentNodeDescriptor = desc_;
        if (transparentNodeDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type mods.eln.mechanical.TurbineDescriptor");
        }
        this.desc = (TurbineDescriptor)transparentNodeDescriptor;
        this.tank = new TransparentNodeElementFluidHandler(1000);
        this.turbineSlowProcess = new TurbineSlowProcess();
        this.throttle = new NbtElectricalGateInput("throttle");
        Object[] objectArray = this.desc.getFluidTypes();
        if (objectArray.length == 0) {
            void elements$iv;
            objectArray = new String[]{"lava"};
            stringArray = (String[])((Object[])elements$iv);
        } else {
            stringArray = this.desc.getFluidTypes();
        }
        Fluid[] fluids = FuelRegistryKt.fluidListToFluids(stringArray);
        this.tank.setFilter(fluids);
        this.slowProcessList.add(this.turbineSlowProcess);
        this.electricalLoadList.add(this.throttle);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u001c\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lmods/eln/mechanical/TurbineElement$TurbineSlowProcess;", "Lmods/eln/sim/IProcess;", "Lmods/eln/misc/INBTTReady;", "(Lmods/eln/mechanical/TurbineElement;)V", "consumptionFixup", "", "getConsumptionFixup", "()F", "setConsumptionFixup", "(F)V", "rc", "Lmods/eln/misc/RcInterpolator;", "getRc", "()Lmods/eln/misc/RcInterpolator;", "process", "", "time", "", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "str", "", "writeToNBT", "ElectricalAge-release_main"})
    public final class TurbineSlowProcess
    implements IProcess,
    INBTTReady {
        @NotNull
        private final RcInterpolator rc;
        private float consumptionFixup;

        @NotNull
        public final RcInterpolator getRc() {
            return this.rc;
        }

        public final float getConsumptionFixup() {
            return this.consumptionFixup;
        }

        public final void setConsumptionFixup(float f) {
            this.consumptionFixup = f;
        }

        @Override
        public void process(double time) {
            float target;
            double computedEfficiency = Math.pow(Math.cos((TurbineElement.this.getShaft().getRads() - TurbineElement.this.getDesc().getOptimalRads()) / (TurbineElement.this.getDesc().getOptimalRads() * (double)TurbineElement.this.getDesc().getEfficiencyCurve()) * Math.PI / (double)2), 3.0);
            if (computedEfficiency >= (double)TurbineElement.this.getDesc().getEfficiencyCutoff()) {
                TurbineElement.this.setEfficiency((float)computedEfficiency);
                Collection collection = TurbineElement.this.getThrottle$ElectricalAge_release_main().getConnectedComponents();
                double th = collection.size() > 0 ? TurbineElement.this.getThrottle$ElectricalAge_release_main().getNormalized() : 1.0;
                target = (float)((double)TurbineElement.this.getDesc().getFluidConsumption() * time * th);
            } else {
                TurbineElement.this.setEfficiency(0.0f);
                target = 0.0f;
            }
            float drain = (float)Math.ceil(target - this.consumptionFixup);
            FluidStack fluidStack = TurbineElement.this.getTank().drain(ForgeDirection.DOWN, (int)drain, true);
            float drained = fluidStack != null ? (float)fluidStack.amount : 0.0f;
            float usable = drained + this.consumptionFixup;
            float actual = usable < target ? usable : target;
            this.consumptionFixup = Math.max(0.0f, usable - target);
            this.rc.setTarget(actual / (float)time);
            this.rc.step((float)time);
            TurbineElement.this.setSteamRate(this.rc.get());
            float power = TurbineElement.this.getSteamRate() * TurbineElement.this.getDesc().getFluidPower() * TurbineElement.this.getEfficiency();
            ShaftNetwork shaftNetwork = TurbineElement.this.getShaft();
            shaftNetwork.setEnergy(shaftNetwork.getEnergy() + (double)(power * (float)time));
        }

        @Override
        public void readFromNBT(@Nullable NBTTagCompound nbt, @Nullable String str) {
            this.rc.readFromNBT(nbt, str);
        }

        @Override
        public void writeToNBT(@Nullable NBTTagCompound nbt, @Nullable String str) {
            this.rc.writeToNBT(nbt, str);
        }

        public TurbineSlowProcess() {
            this.rc = new RcInterpolator(TurbineElement.this.getDesc().getInertia());
        }
    }
}

