/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import cpw.mods.fml.common.FMLCommonHandler;
import mods.eln.misc.Direction;
import mods.eln.misc.INBTTReady;
import mods.eln.node.NodeBlockEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class Coordonate
implements INBTTReady {
    public int x;
    public int y;
    public int z;
    public int dimention;
    private World w = null;

    public Coordonate() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.dimention = 0;
    }

    public Coordonate(Coordonate coord) {
        this.x = coord.x;
        this.y = coord.y;
        this.z = coord.z;
        this.dimention = coord.dimention;
    }

    public Coordonate(NBTTagCompound nbt, String str) {
        this.readFromNBT(nbt, str);
    }

    public int hashCode() {
        return (this.x + this.y) * 0x10101010 + this.z;
    }

    public int worldDimension() {
        return this.dimention;
    }

    public World world() {
        if (this.w == null) {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.worldDimension());
        }
        return this.w;
    }

    public Coordonate(NodeBlockEntity entity) {
        this.x = entity.field_145851_c;
        this.y = entity.field_145848_d;
        this.z = entity.field_145849_e;
        this.dimention = entity.func_145831_w().field_73011_w.field_76574_g;
    }

    public Coordonate(int x, int y, int z, int dimention) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimention = dimention;
    }

    public Coordonate(int x, int y, int z, World world) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimention = world.field_73011_w.field_76574_g;
        if (world.field_72995_K) {
            this.w = world;
        }
    }

    public Coordonate(TileEntity entity) {
        this.x = entity.field_145851_c;
        this.y = entity.field_145848_d;
        this.z = entity.field_145849_e;
        this.dimention = entity.func_145831_w().field_73011_w.field_76574_g;
        if (entity.func_145831_w().field_72995_K) {
            this.w = entity.func_145831_w();
        }
    }

    public Coordonate newWithOffset(int x, int y, int z) {
        return new Coordonate(this.x + x, this.y + y, this.z + z, this.dimention);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Coordonate)) {
            return false;
        }
        Coordonate id = (Coordonate)obj;
        return id.x == this.x && id.y == this.y && id.z == this.z && id.dimention == this.dimention;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.x = nbt.func_74762_e(str + "x");
        this.y = nbt.func_74762_e(str + "y");
        this.z = nbt.func_74762_e(str + "z");
        this.dimention = nbt.func_74762_e(str + "d");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        nbt.func_74768_a(str + "x", this.x);
        nbt.func_74768_a(str + "y", this.y);
        nbt.func_74768_a(str + "z", this.z);
        nbt.func_74768_a(str + "d", this.dimention);
    }

    public String toString() {
        return "X : " + this.x + " Y : " + this.y + " Z : " + this.z + " D : " + this.dimention;
    }

    public void move(Direction dir) {
        switch (dir) {
            case XN: {
                --this.x;
                break;
            }
            case XP: {
                ++this.x;
                break;
            }
            case YN: {
                --this.y;
                break;
            }
            case YP: {
                ++this.y;
                break;
            }
            case ZN: {
                --this.z;
                break;
            }
            case ZP: {
                ++this.z;
                break;
            }
        }
    }

    public Block getBlock() {
        return this.world().func_147439_a(this.x, this.y, this.z);
    }

    public static AxisAlignedBB getAxisAlignedBB(Coordonate a, Coordonate b) {
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)Math.min(a.x, b.x), (double)Math.min(a.y, b.y), (double)Math.min(a.z, b.z), (double)((double)Math.max(a.x, b.x) + 1.0), (double)((double)Math.max(a.y, b.y) + 1.0), (double)((double)Math.max(a.z, b.z) + 1.0));
        return bb;
    }

    public AxisAlignedBB getAxisAlignedBB(int ray) {
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(this.x - ray), (double)(this.y - ray), (double)(this.z - ray), (double)(this.x + ray + 1), (double)(this.y + ray + 1), (double)(this.z + ray + 1));
        return bb;
    }

    public double distanceTo(Entity e) {
        return Math.abs(e.field_70165_t - ((double)this.x + 0.5)) + Math.abs(e.field_70163_u - ((double)this.y + 0.5)) + Math.abs(e.field_70161_v - ((double)this.z + 0.5));
    }

    public int getMeta() {
        return this.world().func_72805_g(this.x, this.y, this.z);
    }

    public boolean getBlockExist() {
        WorldServer w = DimensionManager.getWorld((int)this.dimention);
        if (w == null) {
            return false;
        }
        return w.func_72899_e(this.x, this.y, this.z);
    }

    public boolean getWorldExist() {
        return DimensionManager.getWorld((int)this.dimention) != null;
    }

    public void copyTo(double[] v) {
        v[0] = (double)this.x + 0.5;
        v[1] = (double)this.y + 0.5;
        v[2] = (double)this.z + 0.5;
    }

    public void setPosition(double[] vp) {
        this.x = (int)vp[0];
        this.y = (int)vp[1];
        this.z = (int)vp[2];
    }

    public void setPosition(Vec3 vp) {
        this.x = (int)vp.field_72450_a;
        this.y = (int)vp.field_72448_b;
        this.z = (int)vp.field_72449_c;
    }

    public TileEntity getTileEntity() {
        return this.world().func_147438_o(this.x, this.y, this.z);
    }

    public void invalidate() {
        this.x = -1;
        this.y = -1;
        this.z = -1;
        this.dimention = -5123;
    }

    public boolean isValid() {
        return this.dimention != -5123;
    }

    public double trueDistanceTo(Coordonate c) {
        long dx = this.x - c.x;
        long dy = this.y - c.y;
        long dz = this.z - c.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public void setDimention(int dimention) {
        this.dimention = dimention;
        this.w = null;
    }

    public void copyFrom(Coordonate c) {
        this.x = c.x;
        this.y = c.y;
        this.z = c.z;
        this.dimention = c.dimention;
    }

    public void applyTransformation(Direction front, Coordonate coordonate) {
        front.rotateFromXN(this);
        this.x += coordonate.x;
        this.y += coordonate.y;
        this.z += coordonate.z;
    }

    public void setWorld(World worldObj) {
        if (worldObj.field_72995_K) {
            this.w = worldObj;
        }
        this.dimention = worldObj.field_73011_w.field_76574_g;
    }

    public void setMetadata(int meta) {
        this.world().func_72921_c(this.x, this.y, this.z, meta, 0);
    }

    public void setBlock(Block b) {
        this.world().func_147449_b(this.x, this.y, this.z, b);
    }

    public int compareTo(Coordonate o) {
        if (this.dimention != o.dimention) {
            return this.dimention - o.dimention;
        }
        if (this.x != o.x) {
            return this.x - o.x;
        }
        if (this.y != o.y) {
            return this.y - o.y;
        }
        if (this.z != o.z) {
            return this.z - o.z;
        }
        return 0;
    }

    public Coordonate subtract(Coordonate b) {
        return this.newWithOffset(-b.x, -b.y, -b.z);
    }

    public Coordonate negate() {
        return new Coordonate(-this.x, -this.y, -this.z, this.dimention);
    }
}

