/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import mods.eln.misc.Coordonate;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public enum Direction {
    XN(0),
    XP(1),
    YN(2),
    YP(3),
    ZN(4),
    ZP(5);

    static final Direction[] intToDir;
    int dir;

    private Direction(int dir) {
        this.dir = dir;
    }

    public int getInt() {
        return this.dir;
    }

    public boolean isNotY() {
        return this != YP && this != YN;
    }

    public boolean isY() {
        return this == YP || this == YN;
    }

    public void applyTo(double[] vector, double distance) {
        if (this.dir == 0) {
            vector[0] = vector[0] - distance;
        }
        if (this.dir == 1) {
            vector[0] = vector[0] + distance;
        }
        if (this.dir == 2) {
            vector[1] = vector[1] - distance;
        }
        if (this.dir == 3) {
            vector[1] = vector[1] + distance;
        }
        if (this.dir == 4) {
            vector[2] = vector[2] - distance;
        }
        if (this.dir == 5) {
            vector[2] = vector[2] + distance;
        }
    }

    public void applyTo(int[] vector, int distance) {
        if (this.dir == 0) {
            vector[0] = vector[0] - distance;
        }
        if (this.dir == 1) {
            vector[0] = vector[0] + distance;
        }
        if (this.dir == 2) {
            vector[1] = vector[1] - distance;
        }
        if (this.dir == 3) {
            vector[1] = vector[1] + distance;
        }
        if (this.dir == 4) {
            vector[2] = vector[2] - distance;
        }
        if (this.dir == 5) {
            vector[2] = vector[2] + distance;
        }
    }

    public int getHorizontalIndex() {
        switch (this) {
            case XN: {
                return 0;
            }
            case XP: {
                return 1;
            }
            case YN: {
                return 0;
            }
            case YP: {
                return 0;
            }
            case ZN: {
                return 2;
            }
            case ZP: {
                return 3;
            }
        }
        return 0;
    }

    public static Direction fromHorizontalIndex(int nbr) {
        switch (nbr) {
            case 0: {
                return XN;
            }
            case 1: {
                return XP;
            }
            case 2: {
                return ZN;
            }
            case 3: {
                return ZP;
            }
        }
        return XN;
    }

    public TileEntity applyToTileEntity(TileEntity tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        int[] coords = new int[]{tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e};
        int n = this.dir / 2;
        coords[n] = coords[n] + this.getSign();
        if (tileEntity.func_145831_w() != null && tileEntity.func_145831_w().func_72899_e(coords[0], coords[1], coords[2])) {
            return tileEntity.func_145831_w().func_147438_o(coords[0], coords[1], coords[2]);
        }
        return null;
    }

    public TileEntity applyToTileEntityAndSameClassThan(TileEntity tileEntity, Class c) {
        if (tileEntity == null) {
            return null;
        }
        TileEntity findedEntity = this.applyToTileEntity(tileEntity);
        if (findedEntity == null) {
            return null;
        }
        if (!Utils.isTheClass(findedEntity, c)) {
            return null;
        }
        return findedEntity;
    }

    public Direction getInverse() {
        int inverseDir = this.dir - this.getSign();
        for (Direction direction : Direction.values()) {
            if (direction.dir != inverseDir) continue;
            return direction;
        }
        return this;
    }

    public int toSideValue() {
        return (this.dir + 4) % 6;
    }

    private int getSign() {
        return this.dir % 2 * 2 - 1;
    }

    public void renderBlockFace(int x, int y, float spriteDim) {
        switch (this) {
            case XN: {
                GL11.glNormal3f((float)-1.0f, (float)0.0f, (float)0.0f);
                GL11.glTexCoord2f((float)((float)(x + 1) * spriteDim), (float)((float)(y + 0) * spriteDim));
                GL11.glVertex3f((float)-0.5f, (float)0.5f, (float)0.5f);
                GL11.glTexCoord2f((float)((float)(x + 0) * spriteDim), (float)((float)(y + 0) * spriteDim));
                GL11.glVertex3f((float)-0.5f, (float)0.5f, (float)-0.5f);
                GL11.glTexCoord2f((float)((float)(x + 0) * spriteDim), (float)((float)(y + 1) * spriteDim));
                GL11.glVertex3f((float)-0.5f, (float)-0.5f, (float)-0.5f);
                GL11.glTexCoord2f((float)((float)(x + 1) * spriteDim), (float)((float)(y + 1) * spriteDim));
                GL11.glVertex3f((float)-0.5f, (float)-0.5f, (float)0.5f);
                break;
            }
            case XP: {
                GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTexCoord2f((float)((float)(x + 1) * spriteDim), (float)((float)(y + 0) * spriteDim));
                GL11.glVertex3f((float)0.5f, (float)0.5f, (float)-0.5f);
                GL11.glTexCoord2f((float)((float)(x + 0) * spriteDim), (float)((float)(y + 0) * spriteDim));
                GL11.glVertex3f((float)0.5f, (float)0.5f, (float)0.5f);
                GL11.glTexCoord2f((float)((float)(x + 0) * spriteDim), (float)((float)(y + 1) * spriteDim));
                GL11.glVertex3f((float)0.5f, (float)-0.5f, (float)0.5f);
                GL11.glTexCoord2f((float)((float)(x + 1) * spriteDim), (float)((float)(y + 1) * spriteDim));
                GL11.glVertex3f((float)0.5f, (float)-0.5f, (float)-0.5f);
                break;
            }
            case YN: {
                GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
                GL11.glTexCoord2f((float)((float)(x + 0) * spriteDim), (float)((float)(y + 0) * spriteDim));
                GL11.glVertex3f((float)0.5f, (float)-0.5f, (float)-0.5f);
                GL11.glTexCoord2f((float)((float)(x + 0) * spriteDim), (float)((float)(y + 1) * spriteDim));
                GL11.glVertex3f((float)0.5f, (float)-0.5f, (float)0.5f);
                GL11.glTexCoord2f((float)((float)(x + 1) * spriteDim), (float)((float)(y + 1) * spriteDim));
                GL11.glVertex3f((float)-0.5f, (float)-0.5f, (float)0.5f);
                GL11.glTexCoord2f((float)((float)(x + 1) * spriteDim), (float)((float)(y + 0) * spriteDim));
                GL11.glVertex3f((float)-0.5f, (float)-0.5f, (float)-0.5f);
                break;
            }
            case YP: {
                GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTexCoord2f((float)((float)(x + 0) * spriteDim), (float)((float)(y + 1) * spriteDim));
                GL11.glVertex3f((float)-0.5f, (float)0.5f, (float)-0.5f);
                GL11.glTexCoord2f((float)((float)(x + 0) * spriteDim), (float)((float)(y + 0) * spriteDim));
                GL11.glVertex3f((float)-0.5f, (float)0.5f, (float)0.5f);
                GL11.glTexCoord2f((float)((float)(x + 1) * spriteDim), (float)((float)(y + 0) * spriteDim));
                GL11.glVertex3f((float)0.5f, (float)0.5f, (float)0.5f);
                GL11.glTexCoord2f((float)((float)(x + 1) * spriteDim), (float)((float)(y + 1) * spriteDim));
                GL11.glVertex3f((float)0.5f, (float)0.5f, (float)-0.5f);
                break;
            }
            case ZN: {
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glTexCoord2f((float)((float)(x + 1) * spriteDim), (float)((float)(y + 0) * spriteDim));
                GL11.glVertex3f((float)-0.5f, (float)0.5f, (float)-0.5f);
                GL11.glTexCoord2f((float)((float)(x + 0) * spriteDim), (float)((float)(y + 0) * spriteDim));
                GL11.glVertex3f((float)0.5f, (float)0.5f, (float)-0.5f);
                GL11.glTexCoord2f((float)((float)(x + 0) * spriteDim), (float)((float)(y + 1) * spriteDim));
                GL11.glVertex3f((float)0.5f, (float)-0.5f, (float)-0.5f);
                GL11.glTexCoord2f((float)((float)(x + 1) * spriteDim), (float)((float)(y + 1) * spriteDim));
                GL11.glVertex3f((float)-0.5f, (float)-0.5f, (float)-0.5f);
                break;
            }
            case ZP: {
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTexCoord2f((float)((float)(x + 1) * spriteDim), (float)((float)(y + 0) * spriteDim));
                GL11.glVertex3f((float)0.5f, (float)0.5f, (float)0.5f);
                GL11.glTexCoord2f((float)((float)(x + 0) * spriteDim), (float)((float)(y + 0) * spriteDim));
                GL11.glVertex3f((float)-0.5f, (float)0.5f, (float)0.5f);
                GL11.glTexCoord2f((float)((float)(x + 0) * spriteDim), (float)((float)(y + 1) * spriteDim));
                GL11.glVertex3f((float)-0.5f, (float)-0.5f, (float)0.5f);
                GL11.glTexCoord2f((float)((float)(x + 1) * spriteDim), (float)((float)(y + 1) * spriteDim));
                GL11.glVertex3f((float)0.5f, (float)-0.5f, (float)0.5f);
                break;
            }
        }
    }

    public static Direction fromInt(int idx) {
        for (Direction direction : Direction.values()) {
            if (direction.dir != idx) continue;
            return direction;
        }
        return null;
    }

    public static Direction fromIntMinecraftSide(int idx) {
        idx = (idx + 2) % 6;
        for (Direction direction : Direction.values()) {
            if (direction.dir != idx) continue;
            return direction;
        }
        return null;
    }

    public Direction right() {
        switch (this) {
            case XN: {
                return ZP;
            }
            case XP: {
                return ZN;
            }
            case YN: {
                return ZN;
            }
            case YP: {
                return ZP;
            }
            case ZN: {
                return XN;
            }
            case ZP: {
                return XP;
            }
        }
        return null;
    }

    public Direction left() {
        return this.right().getInverse();
    }

    public Direction up() {
        switch (this) {
            case XN: {
                return YP;
            }
            case XP: {
                return YP;
            }
            case YN: {
                return XP;
            }
            case YP: {
                return XP;
            }
            case ZN: {
                return YP;
            }
            case ZP: {
                return YP;
            }
        }
        return null;
    }

    public Direction down() {
        return this.up().getInverse();
    }

    public Direction back() {
        return this.getInverse();
    }

    public Direction applyLRDU(LRDU lrdu) {
        switch (lrdu) {
            case Down: {
                return this.down();
            }
            case Left: {
                return this.left();
            }
            case Right: {
                return this.right();
            }
            case Up: {
                return this.up();
            }
        }
        return null;
    }

    public LRDU getLRDUGoingTo(Direction target) {
        for (LRDU lrdu : LRDU.values()) {
            if (target != this.applyLRDU(lrdu)) continue;
            return lrdu;
        }
        return null;
    }

    public void glRotateXnRef() {
        switch (this) {
            case XN: {
                break;
            }
            case XP: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case YN: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
                break;
            }
            case YP: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case ZN: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case ZP: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
    }

    public void glRotateXnRefInv() {
        switch (this) {
            case XN: {
                break;
            }
            case XP: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
                break;
            }
            case YN: {
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case YP: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case ZN: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
                break;
            }
            case ZP: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
                break;
            }
        }
    }

    public void glRotateZnRef() {
        switch (this) {
            case XN: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case XP: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
                break;
            }
            case YN: {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
                break;
            }
            case YP: {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                break;
            }
            case ZN: {
                break;
            }
            case ZP: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
    }

    public TileEntity getTileEntity(Coordonate coordonate) {
        int x = coordonate.x;
        int y = coordonate.y;
        int z = coordonate.z;
        switch (this) {
            case XN: {
                --x;
                break;
            }
            case XP: {
                ++x;
                break;
            }
            case YN: {
                --y;
                break;
            }
            case YP: {
                ++y;
                break;
            }
            case ZN: {
                --z;
                break;
            }
            case ZP: {
                ++z;
                break;
            }
        }
        return coordonate.world().func_147438_o(x, y, z);
    }

    public void writeToNBT(NBTTagCompound nbt, String name) {
        nbt.func_74774_a(name, (byte)this.getInt());
    }

    public static Direction readFromNBT(NBTTagCompound nbt, String name) {
        return Direction.fromInt(nbt.func_74771_c(name));
    }

    public void rotateFromXN(double[] p) {
        double x = p[0];
        double y = p[1];
        double z = p[2];
        switch (this) {
            case XN: {
                break;
            }
            case XP: {
                p[0] = -x;
                p[2] = -z;
                break;
            }
            case YN: {
                p[0] = y;
                p[1] = x;
                p[2] = -z;
                break;
            }
            case YP: {
                p[0] = y;
                p[1] = -x;
                p[2] = z;
                break;
            }
            case ZN: {
                p[0] = -z;
                p[2] = x;
                break;
            }
            case ZP: {
                p[0] = z;
                p[2] = -x;
                break;
            }
        }
    }

    public void rotateFromXN(int[] p) {
        int x = p[0];
        int y = p[1];
        int z = p[2];
        switch (this) {
            case XN: {
                break;
            }
            case XP: {
                p[0] = -x;
                p[2] = -z;
                break;
            }
            case YN: {
                p[0] = y;
                p[1] = x;
                p[2] = -z;
                break;
            }
            case YP: {
                p[0] = y;
                p[1] = -x;
                p[2] = z;
                break;
            }
            case ZN: {
                p[0] = -z;
                p[2] = x;
                break;
            }
            case ZP: {
                p[0] = z;
                p[2] = -x;
                break;
            }
        }
    }

    public void rotateFromXN(Vec3 p) {
        double x = p.field_72450_a;
        double y = p.field_72448_b;
        double z = p.field_72449_c;
        switch (this) {
            case XN: {
                break;
            }
            case XP: {
                p.field_72450_a = -x;
                p.field_72449_c = -z;
                break;
            }
            case YN: {
                p.field_72450_a = y;
                p.field_72448_b = x;
                p.field_72449_c = -z;
                break;
            }
            case YP: {
                p.field_72450_a = y;
                p.field_72448_b = -x;
                p.field_72449_c = z;
                break;
            }
            case ZN: {
                p.field_72450_a = -z;
                p.field_72449_c = x;
                break;
            }
            case ZP: {
                p.field_72450_a = z;
                p.field_72449_c = -x;
                break;
            }
        }
    }

    public void rotateFromXN(Coordonate p) {
        int x = p.x;
        int y = p.y;
        int z = p.z;
        switch (this) {
            case XN: {
                break;
            }
            case XP: {
                p.x = -x;
                p.z = -z;
                break;
            }
            case YN: {
                p.x = y;
                p.y = x;
                p.z = -z;
                break;
            }
            case YP: {
                p.x = y;
                p.y = -x;
                p.z = z;
                break;
            }
            case ZN: {
                p.x = -z;
                p.z = x;
                break;
            }
            case ZP: {
                p.x = z;
                p.z = -x;
                break;
            }
        }
    }

    public void glTranslate(float v) {
        switch (this) {
            case XN: {
                GL11.glTranslatef((float)(-v), (float)0.0f, (float)0.0f);
                break;
            }
            case XP: {
                GL11.glTranslatef((float)v, (float)0.0f, (float)0.0f);
                break;
            }
            case YN: {
                GL11.glTranslatef((float)0.0f, (float)(-v), (float)0.0f);
                break;
            }
            case YP: {
                GL11.glTranslatef((float)0.0f, (float)v, (float)0.0f);
                break;
            }
            case ZN: {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-v));
                break;
            }
            case ZP: {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)v);
                break;
            }
        }
    }

    public static Direction from(ForgeDirection direction) {
        switch (direction) {
            case DOWN: {
                return YN;
            }
            case EAST: {
                return XP;
            }
            case NORTH: {
                return ZN;
            }
            case SOUTH: {
                return ZP;
            }
            case UP: {
                return YP;
            }
            case WEST: {
                return XN;
            }
        }
        return YN;
    }

    public ForgeDirection toForge() {
        switch (this) {
            case YN: {
                return ForgeDirection.DOWN;
            }
            case XP: {
                return ForgeDirection.EAST;
            }
            case ZN: {
                return ForgeDirection.NORTH;
            }
            case ZP: {
                return ForgeDirection.SOUTH;
            }
            case YP: {
                return ForgeDirection.UP;
            }
            case XN: {
                return ForgeDirection.WEST;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    static {
        intToDir = new Direction[]{XN, XP, YN, YP, ZN, ZP};
    }
}

