/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import mods.eln.misc.IFunction;

public class FunctionTable
implements IFunction {
    double[] point;
    double xMax;
    double xMaxInv;
    double xDelta;

    public FunctionTable(double[] point, double xMax) {
        this.point = point;
        this.xMax = xMax;
        this.xMaxInv = 1.0 / xMax;
        this.xDelta = 1.0 / (double)(point.length - 1) * xMax;
    }

    @Override
    public double getValue(double x) {
        if ((x *= this.xMaxInv) < 0.0) {
            return this.point[0] + (this.point[1] - this.point[0]) * (double)(this.point.length - 1) * x;
        }
        if (x >= 1.0) {
            return this.point[this.point.length - 1] + (this.point[this.point.length - 1] - this.point[this.point.length - 2]) * (double)(this.point.length - 1) * (x - 1.0);
        }
        int idx = (int)(x *= (double)(this.point.length - 1));
        return this.point[idx + 1] * (x -= (double)idx) + this.point[idx] * (1.0 - x);
    }

    public FunctionTable duplicate(double xFactor, double yFactor) {
        double[] pointCpy = new double[this.point.length];
        for (int idx = 0; idx < this.point.length; ++idx) {
            pointCpy[idx] = this.point[idx] * yFactor;
        }
        FunctionTable other = new FunctionTable(pointCpy, this.xMax * xFactor);
        return other;
    }
}

