/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import mods.eln.misc.FunctionTable;

public class FunctionTableYProtect
extends FunctionTable {
    double yMin;
    double yMax;

    public FunctionTableYProtect(double[] point, double xMax, double yMin, double yMax) {
        super(point, xMax);
        this.yMax = yMax;
        this.yMin = yMin;
    }

    @Override
    public double getValue(double x) {
        double value = super.getValue(x);
        if (value > this.yMax) {
            return this.yMax;
        }
        if (value < this.yMin) {
            return this.yMin;
        }
        return value;
    }

    @Override
    public FunctionTable duplicate(double xFactor, double yFactor) {
        double[] pointCpy = new double[this.point.length];
        for (int idx = 0; idx < this.point.length; ++idx) {
            pointCpy[idx] = this.point[idx] * yFactor;
        }
        FunctionTableYProtect other = new FunctionTableYProtect(pointCpy, this.xMax * xFactor, this.yMin * yFactor, this.yMax * yFactor);
        return other;
    }
}

