/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mods.eln.misc.BlackBodyColor;
import mods.eln.misc.HSLColor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f\u001a\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000f\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0003\"\u0011\u0010\f\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0003\u00a8\u0006\u0013"}, d2={"BLACK", "Lmods/eln/misc/HSLColor;", "getBLACK", "()Lmods/eln/misc/HSLColor;", "BLUE", "getBLUE", "GREEN", "getGREEN", "RED", "getRED", "WHITE", "getWHITE", "YELLOW", "getYELLOW", "BlackBodyPower", "", "temp", "BlackBodyTemperature", "Lmods/eln/misc/BlackBodyColor;", "ElectricalAge-release_main"})
public final class HSLColorKt {
    @NotNull
    private static final HSLColor RED;
    @NotNull
    private static final HSLColor GREEN;
    @NotNull
    private static final HSLColor BLUE;
    @NotNull
    private static final HSLColor BLACK;
    @NotNull
    private static final HSLColor WHITE;
    @NotNull
    private static final HSLColor YELLOW;

    @NotNull
    public static final HSLColor getRED() {
        return RED;
    }

    @NotNull
    public static final HSLColor getGREEN() {
        return GREEN;
    }

    @NotNull
    public static final HSLColor getBLUE() {
        return BLUE;
    }

    @NotNull
    public static final HSLColor getBLACK() {
        return BLACK;
    }

    @NotNull
    public static final HSLColor getWHITE() {
        return WHITE;
    }

    @NotNull
    public static final HSLColor getYELLOW() {
        return YELLOW;
    }

    @NotNull
    public static final BlackBodyColor BlackBodyTemperature(float temp) {
        float x = temp / 1000.0f;
        float x2 = x * x;
        float x3 = x2 * x;
        float x4 = x3 * x;
        float x5 = x4 * x;
        float R = temp <= (float)6600 ? 1.0f : 2.889E-4f * x5 - 0.01258f * x4 + 0.2148f * x3 - 1.776f * x2 + 6.907f * x - 8.723f;
        float G = temp <= (float)6600 ? -4.593E-5f * x5 + 0.001424f * x4 - 0.01489f * x3 + 0.0498f * x2 + 0.1669f * x - 0.1653f : -1.308E-7f * x5 + 1.745E-5f * x4 - 9.116E-4f * x3 + 0.02348f * x2 - 0.3048f * x + 2.159f;
        float B = temp <= 2000.0f ? 0.0f : (temp < 6600.0f ? 1.764E-5f * x5 + 3.575E-4f * x4 - 0.01554f * x3 + 0.1549f * x2 - 0.3682f * x + 0.2386f : 1.0f);
        return new BlackBodyColor(R, G, B);
    }

    public static final float BlackBodyPower(float temp) {
        float sigma = 5.6703E-8f;
        return sigma * temp * temp * temp * temp;
    }

    static {
        Color color = Color.RED;
        Intrinsics.checkExpressionValueIsNotNull(color, "Color.RED");
        RED = new HSLColor(color);
        Color color2 = Color.GREEN;
        Intrinsics.checkExpressionValueIsNotNull(color2, "Color.GREEN");
        GREEN = new HSLColor(color2);
        Color color3 = Color.BLUE;
        Intrinsics.checkExpressionValueIsNotNull(color3, "Color.BLUE");
        BLUE = new HSLColor(color3);
        Color color4 = Color.BLACK;
        Intrinsics.checkExpressionValueIsNotNull(color4, "Color.BLACK");
        BLACK = new HSLColor(color4);
        Color color5 = Color.WHITE;
        Intrinsics.checkExpressionValueIsNotNull(color5, "Color.WHITE");
        WHITE = new HSLColor(color5);
        Color color6 = Color.YELLOW;
        Intrinsics.checkExpressionValueIsNotNull(color6, "Color.YELLOW");
        YELLOW = new HSLColor(color6);
    }
}

