/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public enum LRDU {
    Left(0),
    Right(1),
    Down(2),
    Up(3);

    public int dir;

    private LRDU(int dir) {
        this.dir = dir;
    }

    public static LRDU fromInt(int value) {
        switch (value) {
            case 0: {
                return Left;
            }
            case 1: {
                return Right;
            }
            case 2: {
                return Down;
            }
            case 3: {
                return Up;
            }
        }
        return Left;
    }

    public int toInt() {
        return this.dir;
    }

    public LRDU inverse() {
        switch (this) {
            case Down: {
                return Up;
            }
            case Left: {
                return Right;
            }
            case Right: {
                return Left;
            }
            case Up: {
                return Down;
            }
        }
        return null;
    }

    public LRDU inverseIfLR() {
        switch (this) {
            case Down: {
                return Down;
            }
            case Left: {
                return Right;
            }
            case Right: {
                return Left;
            }
            case Up: {
                return Up;
            }
        }
        return null;
    }

    public void applyTo(double[] vector, double value) {
        switch (this) {
            case Down: {
                vector[1] = vector[1] - value;
                break;
            }
            case Left: {
                vector[0] = vector[0] - value;
                break;
            }
            case Right: {
                vector[0] = vector[0] + value;
                break;
            }
            case Up: {
                vector[1] = vector[1] + value;
                break;
            }
        }
    }

    public float[] rotate4PinDistances(float[] distances) {
        if (distances.length != 4) {
            return distances;
        }
        switch (this) {
            case Left: {
                return new float[]{distances[3], distances[2], distances[0], distances[1]};
            }
            case Down: {
                return new float[]{distances[1], distances[0], distances[3], distances[2]};
            }
            case Right: {
                return new float[]{distances[2], distances[3], distances[1], distances[0]};
            }
        }
        return distances;
    }

    public LRDU getNextClockwise() {
        switch (this) {
            case Down: {
                return Left;
            }
            case Left: {
                return Up;
            }
            case Right: {
                return Down;
            }
            case Up: {
                return Right;
            }
        }
        return Left;
    }

    public void glRotateOnX() {
        switch (this) {
            case Left: {
                break;
            }
            case Up: {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case Right: {
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case Down: {
                GL11.glRotatef((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
    }

    public void rotateOnXnLeft(double[] v) {
        double y = v[1];
        double z = v[2];
        switch (this) {
            case Left: {
                break;
            }
            case Up: {
                v[1] = -z;
                v[2] = y;
                break;
            }
            case Right: {
                v[1] = -y;
                v[2] = -z;
                break;
            }
            case Down: {
                v[1] = z;
                v[2] = -y;
            }
        }
    }

    public void rotateOnXnLeft(Vec3 v) {
        double y = v.field_72448_b;
        double z = v.field_72449_c;
        switch (this) {
            case Left: {
                break;
            }
            case Up: {
                v.field_72448_b = -z;
                v.field_72449_c = y;
                break;
            }
            case Right: {
                v.field_72448_b = -y;
                v.field_72449_c = -z;
                break;
            }
            case Down: {
                v.field_72448_b = z;
                v.field_72449_c = -y;
            }
        }
    }

    public LRDU left() {
        switch (this) {
            case Down: {
                return Right;
            }
            case Left: {
                return Down;
            }
            case Right: {
                return Up;
            }
            case Up: {
                return Left;
            }
        }
        return Left;
    }

    public LRDU right() {
        switch (this) {
            case Down: {
                return Left;
            }
            case Left: {
                return Up;
            }
            case Right: {
                return Down;
            }
            case Up: {
                return Right;
            }
        }
        return Left;
    }

    public void writeToNBT(NBTTagCompound nbt, String name) {
        nbt.func_74774_a(name, (byte)this.toInt());
    }

    public static LRDU readFromNBT(NBTTagCompound nbt, String name) {
        return LRDU.fromInt(nbt.func_74771_c(name));
    }

    public void serialize(DataOutputStream stream) {
        try {
            stream.writeByte(this.toInt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static LRDU deserialize(DataInputStream stream) {
        try {
            return LRDU.fromInt(stream.readByte());
        }
        catch (IOException e) {
            e.printStackTrace();
            return Up;
        }
    }
}

