/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUMask;

public class LRDUCubeMask {
    public LRDUMask[] lrduMaskArray = new LRDUMask[6];

    public LRDUCubeMask() {
        for (int idx = 0; idx < 6; ++idx) {
            this.lrduMaskArray[idx] = new LRDUMask();
        }
    }

    LRDUMask getSide(Direction direction) {
        return this.lrduMaskArray[direction.getInt()];
    }

    public void clear() {
        for (LRDUMask lrduMask : this.lrduMaskArray) {
            lrduMask.set(0);
        }
    }

    public void set(Direction direction, LRDU lrdu, boolean value) {
        this.get(direction).set(lrdu, value);
    }

    public boolean get(Direction direction, LRDU lrdu) {
        return this.get(direction).get(lrdu);
    }

    public LRDUMask get(Direction direction) {
        return this.lrduMaskArray[direction.getInt()];
    }

    public LRDUMask getTranslate(Direction side) {
        LRDUMask mask = new LRDUMask();
        for (LRDU lrdu : LRDU.values()) {
            Direction otherSide = side.applyLRDU(lrdu);
            LRDU otherLrdu = otherSide.getLRDUGoingTo(side);
            mask.set(lrdu, this.get(otherSide, otherLrdu));
        }
        return mask;
    }
}

