/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.misc.LRDU;

public class LRDUMask {
    public int mask;
    public static final LRDUMask[] array = new LRDUMask[]{new LRDUMask(1), new LRDUMask(2), new LRDUMask(4), new LRDUMask(8)};

    public LRDUMask() {
        this.mask = 0;
    }

    public LRDUMask(int mask) {
        this.mask = mask;
    }

    public boolean left() {
        return (this.mask & 1) != 0;
    }

    public boolean right() {
        return (this.mask & 2) != 0;
    }

    public boolean down() {
        return (this.mask & 4) != 0;
    }

    public boolean up() {
        return (this.mask & 8) != 0;
    }

    public void set(int mask) {
        this.mask = mask;
    }

    public void set(LRDU lrdu, boolean value) {
        this.mask = value ? (this.mask |= 1 << lrdu.dir) : (this.mask &= ~(1 << lrdu.dir));
    }

    public boolean get(LRDU lrdu) {
        return (this.mask & 1 << lrdu.dir) != 0;
    }

    public void serialize(DataOutputStream stream) {
        try {
            stream.writeByte(this.mask);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void deserialize(DataInputStream stream) {
        try {
            this.set(stream.readByte());
        }
        catch (IOException e) {
            e.printStackTrace();
            this.set(0);
        }
    }
}

