/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mods.eln.misc.Utils;

public class LiveDataManager {
    Map<Object, Element> map = new HashMap<Object, Element>();

    public LiveDataManager() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void start() {
    }

    public void stop() {
        this.map.clear();
    }

    public Object getData(Object key, int timeout) {
        Element e = this.map.get(key);
        if (e == null) {
            return null;
        }
        e.timeout = timeout;
        return e.data;
    }

    public Object newData(Object key, Object data, int timeout) {
        this.map.put(key, new Element(data, timeout));
        Utils.println("NewLiveData");
        return data;
    }

    @SubscribeEvent
    public void tick(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        ArrayList<Object> keyToRemove = new ArrayList<Object>();
        for (Map.Entry<Object, Element> entry : this.map.entrySet()) {
            Element e = entry.getValue();
            --e.timeout;
            if (e.timeout >= 0) continue;
            keyToRemove.add(entry.getKey());
            Utils.println("LiveDeleted");
        }
        for (Map.Entry<Object, Element> entry : keyToRemove) {
            this.map.remove(entry);
        }
    }

    static class Element {
        Object data;
        int timeout;

        public Element(Object data, int timeout) {
            this.data = data;
            this.timeout = timeout;
        }
    }
}

