/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import mods.eln.misc.BoundingBox;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class Obj3D {
    private Timer updateTimer = null;
    private boolean locked = false;
    List<Vertex> vertex = new ArrayList<Vertex>();
    List<Uv> uv = new ArrayList<Uv>();
    Map<String, String> nameToStringHash = new Hashtable<String, String>();
    public float xDim;
    public float yDim;
    public float zDim;
    public float xMin = 0.0f;
    public float yMin = 0.0f;
    public float zMin = 0.0f;
    public float xMax = 0.0f;
    public float yMax = 0.0f;
    public float zMax = 0.0f;
    public float dimMax;
    public float dimMaxInv;
    private String dirPath;
    Hashtable<String, Obj3DPart> nameToPartHash = new Hashtable();

    public void bindTexture(String texFilename) {
        ResourceLocation textureResource = new ResourceLocation("eln", "model/" + this.dirPath + "/" + texFilename);
        UtilsClient.bindTexture(textureResource);
    }

    public ResourceLocation getModelResourceLocation(String name) {
        return new ResourceLocation("eln", "model/" + this.dirPath + "/" + name);
    }

    private BufferedReader getResourceAsStream(String filePath) {
        String path = "assets/eln/" + filePath;
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(path);
            return new BufferedReader(new InputStreamReader(in, "UTF-8"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean loadFile(String filePath) {
        return this.loadFile(filePath, false);
    }

    public boolean loadFile(final String filePath, boolean reload) {
        Obj3DPart part = null;
        FaceGroup fg = null;
        if (reload) {
            this.locked = true;
            this.vertex.clear();
            this.uv.clear();
            this.xMax = 0.0f;
            this.yMin = 0.0f;
            this.zMin = 0.0f;
            this.xMax = 0.0f;
            this.yMax = 0.0f;
            this.zMax = 0.0f;
        }
        this.dirPath = filePath.substring(0, filePath.lastIndexOf(47));
        String mtlName = null;
        try {
            String[] words;
            String line;
            BufferedReader bufferedReader = this.getResourceAsStream("model/" + filePath);
            if (bufferedReader == null) {
                Utils.println(String.format(" - failed to load obj '%s'", filePath));
                return false;
            }
            while ((line = bufferedReader.readLine()) != null) {
                words = line.split(" ");
                if (words[0].equals("o")) {
                    if (reload) {
                        part = this.nameToPartHash.get(words[1]);
                        if (part != null) {
                            part.clear();
                            continue;
                        }
                        part = new Obj3DPart(this.vertex, this.uv);
                        this.nameToPartHash.put(words[1], part);
                        continue;
                    }
                    part = new Obj3DPart(this.vertex, this.uv);
                    this.nameToPartHash.put(words[1], part);
                    continue;
                }
                if (words[0].equals("v")) {
                    Vertex v = new Vertex(Float.parseFloat(words[1]), Float.parseFloat(words[2]), Float.parseFloat(words[3]));
                    part.addVertex(v);
                    this.xMin = Math.min(this.xMin, v.x);
                    this.yMin = Math.min(this.yMin, v.y);
                    this.zMin = Math.min(this.zMin, v.z);
                    this.xMax = Math.max(this.xMax, v.x);
                    this.yMax = Math.max(this.yMax, v.y);
                    this.zMax = Math.max(this.zMax, v.z);
                    continue;
                }
                if (words[0].equals("vt")) {
                    part.uv.add(new Uv(Float.parseFloat(words[1]), 1.0f - Float.parseFloat(words[2])));
                    continue;
                }
                if (words[0].equals("f")) {
                    int vertexNbr = words.length - 1;
                    if (vertexNbr == 3) {
                        Vertex[] verticeId = new Vertex[vertexNbr];
                        Uv[] uvId = new Uv[vertexNbr];
                        for (int idx = 0; idx < vertexNbr; ++idx) {
                            String[] id = words[idx + 1].split("/");
                            verticeId[idx] = part.vertex.get(Integer.parseInt(id[0]) - 1);
                            uvId[idx] = id.length > 1 && !id[1].equals("") ? part.uv.get(Integer.parseInt(id[1]) - 1) : null;
                        }
                        fg.face.add(new Face(verticeId, uvId, new Normal(verticeId[0], verticeId[1], verticeId[2])));
                        continue;
                    }
                    Utils.println("obj assert vertexNbr != 3");
                    continue;
                }
                if (words[0].equals("mtllib")) {
                    mtlName = words[1];
                    continue;
                }
                if (!words[0].equals("usemtl")) continue;
                fg = new FaceGroup();
                fg.mtlName = words[1];
                part.faceGroup.add(fg);
            }
            bufferedReader = this.getResourceAsStream("model/" + this.dirPath + "/" + mtlName);
            if (bufferedReader == null) {
                Utils.println(String.format(" - failed to load mtl '%s'", mtlName));
                return false;
            }
            while ((line = bufferedReader.readLine()) != null) {
                words = line.split(" ");
                if (words[0].equals("newmtl")) {
                    mtlName = words[1];
                    continue;
                }
                if (!words[0].equals("map_Kd")) continue;
                for (Obj3DPart partPtr : this.nameToPartHash.values()) {
                    for (FaceGroup fgroup : partPtr.faceGroup) {
                        if (fgroup.mtlName == null || !fgroup.mtlName.equals(mtlName)) continue;
                        fgroup.textureResource = this.getModelResourceLocation(words[1]);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        part = null;
        try {
            String txtPath = filePath.replace(".obj", ".txt").replace(".OBJ", ".txt");
            BufferedReader bufferedReader = this.getResourceAsStream("model/" + txtPath);
            if (bufferedReader == null) {
                Utils.println(String.format(" - failed to load txt '%s'", txtPath));
            } else {
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    int refresh;
                    String[] words = line.split(" ");
                    if (words[0].equals("o")) {
                        part = this.nameToPartHash.get(words[1]);
                        continue;
                    }
                    if (words[0].equals("f")) {
                        if (words[1].equals("originX")) {
                            part.ox = Float.valueOf(words[2]).floatValue();
                            continue;
                        }
                        if (words[1].equals("originY")) {
                            part.oy = Float.valueOf(words[2]).floatValue();
                            continue;
                        }
                        if (words[1].equals("originZ")) {
                            part.oz = Float.valueOf(words[2]).floatValue();
                            continue;
                        }
                        if (words[1].equals("originX2")) {
                            part.ox2 = Float.valueOf(words[2]).floatValue();
                            continue;
                        }
                        if (words[1].equals("originY2")) {
                            part.oy2 = Float.valueOf(words[2]).floatValue();
                            continue;
                        }
                        if (words[1].equals("originZ2")) {
                            part.oz2 = Float.valueOf(words[2]).floatValue();
                            continue;
                        }
                        part.nameToFloatHash.put(words[1], Float.valueOf(words[2]));
                        continue;
                    }
                    if (words[0].equals("s")) {
                        this.nameToStringHash.put(words[1], words[2]);
                        continue;
                    }
                    if (reload || words.length != 2 || !words[0].equals("r") || (refresh = Integer.parseInt(words[1])) == 0) continue;
                    this.updateTimer = new Timer();
                    this.updateTimer.scheduleAtFixedRate(new TimerTask(){

                        @Override
                        public void run() {
                            Utils.println("Reloading model data from " + filePath);
                            Obj3D.this.loadFile(filePath, true);
                        }
                    }, refresh, (long)refresh);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.xDim = this.xMax - this.xMin;
        this.yDim = this.yMax - this.yMin;
        this.zDim = this.zMax - this.zMin;
        this.dimMax = Math.max(Math.max(this.xMax, this.yMax), this.zMax);
        this.dimMaxInv = 1.0f / this.dimMax;
        if (reload) {
            this.locked = false;
        }
        return true;
    }

    public Obj3DPart getPart(String part) {
        return this.nameToPartHash.get(part);
    }

    public void draw(String part) {
        Obj3DPart partPtr = this.getPart(part);
        if (partPtr != null) {
            partPtr.draw();
        }
    }

    public String getString(String name) {
        return this.nameToStringHash.get(name);
    }

    class Face {
        public Vertex[] vertex;
        public Uv[] uv;
        Normal normal;
        public int vertexNbr;

        Face(Vertex[] vertex, Uv[] uv, Normal normal) {
            this.vertex = vertex;
            this.uv = uv;
            this.normal = normal;
            this.vertexNbr = vertex.length;
        }
    }

    class Normal {
        public float x;
        public float y;
        public float z;

        Normal(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        Normal(String[] value) {
            this.x = Float.parseFloat(value[0]);
            this.y = Float.parseFloat(value[1]);
            this.z = Float.parseFloat(value[2]);
        }

        Normal(Vertex o, Vertex a, Vertex b) {
            float a_x = a.x - o.x;
            float a_y = a.y - o.y;
            float a_z = a.z - o.z;
            float b_x = b.x - o.x;
            float b_y = b.y - o.y;
            float b_z = b.z - o.z;
            this.x = a_y * b_z - a_z * b_y;
            this.y = a_z * b_x - a_x * b_z;
            this.z = a_x * b_y - a_y * b_x;
            float norme = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
            this.x /= norme;
            this.y /= norme;
            this.z /= norme;
        }
    }

    class Uv {
        public float u;
        public float v;

        Uv(float u, float v) {
            this.u = u;
            this.v = v;
        }

        Uv(String[] value) {
            this.u = Float.parseFloat(value[0]);
            this.v = Float.parseFloat(value[1]);
        }
    }

    public class Vertex {
        public float x;
        public float y;
        public float z;

        Vertex(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        Vertex(String[] value) {
            this.x = Float.parseFloat(value[0]);
            this.y = Float.parseFloat(value[1]);
            this.z = Float.parseFloat(value[2]);
        }
    }

    public class Obj3DPart {
        List<Vertex> vertex;
        List<Uv> uv;
        List<FaceGroup> faceGroup = new ArrayList<FaceGroup>();
        Map<String, Float> nameToFloatHash = new Hashtable<String, Float>();
        public float xMin = 0.0f;
        public float yMin = 0.0f;
        public float zMin = 0.0f;
        public float xMax = 0.0f;
        public float yMax = 0.0f;
        public float zMax = 0.0f;
        private BoundingBox boundingBox = null;
        float ox;
        float oy;
        float oz;
        float ox2;
        float oy2;
        float oz2;

        public Obj3DPart(List<Vertex> vertex, List<Uv> uv) {
            this.vertex = vertex;
            this.uv = uv;
        }

        void clear() {
            this.faceGroup.clear();
            this.boundingBox = null;
            this.xMin = 0.0f;
            this.yMin = 0.0f;
            this.zMin = 0.0f;
            this.xMax = 0.0f;
            this.yMax = 0.0f;
            this.zMax = 0.0f;
        }

        void addVertex(Vertex v) {
            this.vertex.add(v);
            this.xMin = Math.min(this.xMin, v.x);
            this.yMin = Math.min(this.yMin, v.y);
            this.zMin = Math.min(this.zMin, v.z);
            this.xMax = Math.max(this.xMax, v.x);
            this.yMax = Math.max(this.yMax, v.y);
            this.zMax = Math.max(this.zMax, v.z);
            this.boundingBox = null;
        }

        public float getFloat(String name) {
            return this.nameToFloatHash.get(name).floatValue();
        }

        public void draw(float angle, float x, float y, float z) {
            if (Obj3D.this.locked) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.ox, (float)this.oy, (float)this.oz);
            GL11.glRotatef((float)angle, (float)x, (float)y, (float)z);
            GL11.glTranslatef((float)(-this.ox), (float)(-this.oy), (float)(-this.oz));
            this.draw();
            GL11.glPopMatrix();
        }

        public void draw(float angle, float x, float y, float z, float texOffsetX, float texOffsetY) {
            if (Obj3D.this.locked) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.ox, (float)this.oy, (float)this.oz);
            GL11.glRotatef((float)angle, (float)x, (float)y, (float)z);
            GL11.glTranslatef((float)(-this.ox), (float)(-this.oy), (float)(-this.oz));
            this.draw(texOffsetX, texOffsetY);
            GL11.glPopMatrix();
        }

        public void draw(float angle, float x, float y, float z, float angle2, float x2, float y2, float z2) {
            if (Obj3D.this.locked) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.ox, (float)this.oy, (float)this.oz);
            GL11.glRotatef((float)angle, (float)x, (float)y, (float)z);
            GL11.glTranslatef((float)this.ox2, (float)this.oy2, (float)this.oz2);
            GL11.glRotatef((float)angle2, (float)x2, (float)y2, (float)z2);
            GL11.glTranslatef((float)(-this.ox2), (float)(-this.oy2), (float)(-this.oz2));
            GL11.glTranslatef((float)(-this.ox), (float)(-this.oy), (float)(-this.oz));
            this.draw();
            GL11.glPopMatrix();
        }

        public void drawNoBind(float angle, float x, float y, float z) {
            if (Obj3D.this.locked) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.ox, (float)this.oy, (float)this.oz);
            GL11.glRotatef((float)angle, (float)x, (float)y, (float)z);
            GL11.glTranslatef((float)(-this.ox), (float)(-this.oy), (float)(-this.oz));
            this.drawNoBind();
            GL11.glPopMatrix();
        }

        public void drawNoBind() {
            if (Obj3D.this.locked) {
                return;
            }
            for (FaceGroup fg : this.faceGroup) {
                fg.drawNoBind();
            }
        }

        public void draw() {
            if (Obj3D.this.locked) {
                return;
            }
            for (FaceGroup fg : this.faceGroup) {
                fg.draw();
            }
        }

        public void draw(float texOffsetX, float texOffsetY) {
            if (Obj3D.this.locked) {
                return;
            }
            for (FaceGroup fg : this.faceGroup) {
                fg.drawVertex(texOffsetX, texOffsetY);
            }
        }

        public BoundingBox boundingBox() {
            if (this.boundingBox == null) {
                BoundingBox box = BoundingBox.mergeIdentity();
                for (FaceGroup fg : this.faceGroup) {
                    box = box.merge(fg.boundingBox());
                }
                this.boundingBox = box;
            }
            return this.boundingBox;
        }
    }

    public static class FaceGroup {
        String mtlName = null;
        public ResourceLocation textureResource;
        List<Face> face = new ArrayList<Face>();
        boolean listReady = false;
        int glList;

        public void bindTexture() {
            UtilsClient.bindTexture(this.textureResource);
        }

        public BoundingBox boundingBox() {
            float xMin = 0.0f;
            float xMax = 0.0f;
            float yMin = 0.0f;
            float yMax = 0.0f;
            float zMin = 0.0f;
            float zMax = 0.0f;
            for (Face f : this.face) {
                int n = 0;
                Vertex[] vertexArray = f.vertex;
                int n2 = vertexArray.length;
                if (n >= n2) continue;
                Vertex v = vertexArray[n];
                xMin = xMax = v.x;
                yMin = yMax = v.y;
                zMin = zMax = v.z;
            }
            for (Face f : this.face) {
                for (Vertex v : f.vertex) {
                    xMin = Math.min(xMin, v.x);
                    xMax = Math.max(xMax, v.x);
                    yMin = Math.min(yMin, v.y);
                    yMax = Math.max(yMax, v.y);
                    zMin = Math.min(zMin, v.z);
                    zMax = Math.max(zMax, v.z);
                }
            }
            return new BoundingBox(xMin, xMax, yMin, yMax, zMin, zMax);
        }

        public void draw() {
            if (this.textureResource != null) {
                this.bindTexture();
                this.drawNoBind();
            } else {
                GL11.glDisable((int)3553);
                this.drawNoBind();
                GL11.glEnable((int)3553);
            }
        }

        private void drawVertex() {
            this.drawVertex(0.0f, 0.0f);
        }

        private void drawVertex(float offsetX, float offsetY) {
            int mode = 0;
            for (Face f : this.face) {
                if (f.vertexNbr != mode) {
                    if (mode != 0) {
                        GL11.glEnd();
                    }
                    switch (f.vertexNbr) {
                        case 3: {
                            GL11.glBegin((int)4);
                            break;
                        }
                        case 4: {
                            GL11.glBegin((int)7);
                            break;
                        }
                        case 6: {
                            break;
                        }
                    }
                    mode = f.vertexNbr;
                }
                GL11.glNormal3f((float)f.normal.x, (float)f.normal.y, (float)f.normal.z);
                for (int idx = 0; idx < mode; ++idx) {
                    if (f.uv[idx] != null) {
                        GL11.glTexCoord2f((float)(f.uv[idx].u + offsetX), (float)(f.uv[idx].v + offsetY));
                    }
                    GL11.glVertex3f((float)f.vertex[idx].x, (float)f.vertex[idx].y, (float)f.vertex[idx].z);
                }
            }
            if (mode != 0) {
                GL11.glEnd();
            }
        }

        public void drawNoBind() {
            if (!this.listReady) {
                this.listReady = true;
                this.glList = GL11.glGenLists((int)1);
                GL11.glNewList((int)this.glList, (int)4864);
                this.drawVertex();
                GL11.glEndList();
            }
            GL11.glCallList((int)this.glList);
        }
    }
}

