/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import mods.eln.Eln;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;

public class Obj3DFolder {
    private Map<String, Obj3D> nameToObjHash = new HashMap<String, Obj3D>();

    public void loadAllElnModels() {
        try {
            CodeSource codeSource = Obj3DFolder.class.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                String jarFilePath = codeSource.getLocation().getPath();
                if (jarFilePath.contains("!")) {
                    jarFilePath = jarFilePath.substring(5, jarFilePath.indexOf("!"));
                    JarFile jarFile = new JarFile(URLDecoder.decode(jarFilePath, "UTF-8"));
                    Enumeration<JarEntry> entries = jarFile.entries();
                    int modelCount = 0;
                    while (entries.hasMoreElements()) {
                        String filename = entries.nextElement().getName();
                        if (!filename.startsWith("assets/eln/model/") || !filename.toLowerCase().endsWith(".obj")) continue;
                        filename = filename.substring(filename.indexOf("/model/") + 7, filename.length());
                        Utils.println(String.format("Loading model %03d '%s'", ++modelCount, filename));
                        this.loadObj(filename);
                    }
                } else {
                    Integer modelCount = 0;
                    File modelFolder = new File(Eln.class.getResource("/assets/eln/model").toURI());
                    if (modelFolder.isDirectory()) {
                        this.loadModelsRecursive(modelFolder, modelCount);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private void loadModelsRecursive(File folder, Integer modelCount) {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                this.loadModelsRecursive(file, modelCount);
                continue;
            }
            if (!file.getName().toLowerCase().endsWith(".obj")) continue;
            String filename = file.getPath().replaceAll("\\\\", "/");
            filename = filename.substring(filename.indexOf("/model/") + 7, filename.length());
            Object[] objectArray = new Object[2];
            modelCount = modelCount + 1;
            objectArray[0] = modelCount;
            objectArray[1] = filename;
            Utils.println(String.format("Loading model %03d '%s'", objectArray));
            this.loadObj(filename);
        }
    }

    private void loadObj(String modelPath) {
        Obj3D obj = new Obj3D();
        if (obj.loadFile(modelPath)) {
            String tag = modelPath.replaceAll(".obj", "").replaceAll(".OBJ", "");
            if (this.nameToObjHash.containsKey(tag = tag.substring(tag.lastIndexOf(47) + 1, tag.length()))) {
                Utils.println("Double load of model " + tag);
            }
            this.nameToObjHash.put(tag, obj);
            Utils.println(String.format(" - model '%s' loaded", modelPath));
        } else {
            Utils.println(String.format(" - unable to load model '%s'", modelPath));
        }
    }

    public Obj3D getObj(String obj3DName) {
        return this.nameToObjHash.get(obj3DName);
    }

    public Obj3D.Obj3DPart getPart(String objName, String partName) {
        Obj3D obj = this.getObj(objName);
        if (obj == null) {
            return null;
        }
        return obj.getPart(partName);
    }

    public void draw(String objName, String partName) {
        Obj3D.Obj3DPart part = this.getPart(objName, partName);
        if (part != null) {
            part.draw();
        }
    }
}

