/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

public class PhysicalInterpolatorNoRebound {
    float factor;
    float factorSpeed = 0.0f;
    float factorPos = 0.0f;
    float factorFiltred = 0.0f;
    float accPerSPerError;
    float slowPerS;
    float ff;
    float maxSpeed = 1000.0f;

    public PhysicalInterpolatorNoRebound(float preTao, float accPerSPerError, float slowPerS) {
        this.ff = 1.0f / preTao;
        this.accPerSPerError = accPerSPerError;
        this.slowPerS = slowPerS;
    }

    public void step(float deltaT) {
        this.factorFiltred += (this.factor - this.factorFiltred) * this.ff * deltaT;
        float error = this.factorFiltred - this.factorPos;
        this.factorSpeed *= 1.0f - this.slowPerS * deltaT;
        this.factorSpeed += error * this.accPerSPerError * deltaT;
        if (this.factorSpeed > this.maxSpeed) {
            this.factorSpeed = this.maxSpeed;
        }
        if (this.factorSpeed < -this.maxSpeed) {
            this.factorSpeed = -this.maxSpeed;
        }
        this.factorPos += this.factorSpeed * deltaT;
    }

    public float get() {
        return this.factorPos;
    }

    public void setPos(float value) {
        this.factorPos = value;
        this.factorFiltred = value;
        this.setTarget(value);
    }

    public void setTarget(float value) {
        this.factor = value;
    }

    public float getTarget() {
        return this.factor;
    }

    public void setMaxSpeed(float d) {
        this.maxSpeed = d;
    }
}

