/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import mods.eln.misc.INBTTReady;
import net.minecraft.nbt.NBTTagCompound;

public class RcRcInterpolator
implements INBTTReady {
    float c1;
    float c2;
    float target;
    float tao1Inv;
    float tao2Inv;

    public RcRcInterpolator(float tao1, float tao2) {
        this.tao1Inv = 1.0f / tao1;
        this.tao2Inv = 1.0f / tao2;
        this.c1 = 0.0f;
        this.c2 = 0.0f;
        this.target = 0.0f;
    }

    public void step(float deltaT) {
        this.c1 += (this.target - this.c1) * this.tao1Inv * deltaT;
        this.c2 += (this.c1 - this.c2) * this.tao2Inv * deltaT;
    }

    public float get() {
        return this.c2;
    }

    public void setTarget(float value) {
        this.target = value;
    }

    public void setValue(float value) {
        this.c2 = value;
        this.c1 = value;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.c1 = nbt.func_74760_g(str + "c1");
        this.c2 = nbt.func_74760_g(str + "c2");
        this.target = nbt.func_74760_g(str + "target");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        nbt.func_74776_a(str + "c1", this.c1);
        nbt.func_74776_a(str + "c2", this.c2);
        nbt.func_74776_a(str + "target", this.target);
    }
}

