/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.misc.Recipe;
import mods.eln.misc.Utils;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class RecipesList {
    public static final ArrayList<RecipesList> listOfList = new ArrayList();
    private ArrayList<Recipe> recipeList = new ArrayList();
    private ArrayList<ItemStack> machineList = new ArrayList();

    public RecipesList() {
        listOfList.add(this);
    }

    public ArrayList<Recipe> getRecipes() {
        return this.recipeList;
    }

    public ArrayList<ItemStack> getMachines() {
        return this.machineList;
    }

    public void addRecipe(Recipe recipe) {
        this.recipeList.add(recipe);
        recipe.setMachineList(this.machineList);
    }

    public void addMachine(ItemStack machine) {
        this.machineList.add(machine);
    }

    public Recipe getRecipe(ItemStack input) {
        for (Recipe r : this.recipeList) {
            if (!r.canBeCraftedBy(input)) continue;
            return r;
        }
        return null;
    }

    public ArrayList<Recipe> getRecipeFromOutput(ItemStack output) {
        ArrayList<Recipe> list = new ArrayList<Recipe>();
        block0: for (Recipe r : this.recipeList) {
            for (ItemStack stack : r.getOutputCopy()) {
                if (!Utils.areSame(stack, output)) continue;
                list.add(r);
                continue block0;
            }
        }
        return list;
    }

    public static ArrayList<Recipe> getGlobalRecipeWithOutput(ItemStack output) {
        output = output.func_77946_l();
        output.field_77994_a = 1;
        ArrayList<Recipe> list = new ArrayList<Recipe>();
        for (RecipesList recipesList : listOfList) {
            list.addAll(recipesList.getRecipeFromOutput(output));
        }
        FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
        Iterator it = furnaceRecipes.func_77599_b().entrySet().iterator();
        while (it.hasNext()) {
            try {
                Map.Entry pairs = it.next();
                ItemStack stack = (ItemStack)pairs.getValue();
                ItemStack li = (ItemStack)pairs.getKey();
                if (!Utils.areSame(output, stack)) continue;
                Recipe recipe = new Recipe(li.func_77946_l(), output, 1000.0);
                list.add(recipe);
                recipe.setMachineList(Eln.instance.furnaceList);
            }
            catch (Exception exception) {}
        }
        return list;
    }

    public static ArrayList<Recipe> getGlobalRecipeWithInput(ItemStack input) {
        input = input.func_77946_l();
        input.field_77994_a = 64;
        ArrayList<Recipe> list = new ArrayList<Recipe>();
        for (RecipesList recipesList : listOfList) {
            Recipe r = recipesList.getRecipe(input);
            if (r == null) continue;
            list.add(r);
        }
        FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
        ItemStack smeltResult = furnaceRecipes.func_151395_a(input);
        if (smeltResult != null) {
            try {
                ItemStack input1 = input.func_77946_l();
                input1.field_77994_a = 1;
                Recipe smeltRecipe = new Recipe(input1, smeltResult, 1000.0);
                list.add(smeltRecipe);
                smeltRecipe.machineList.addAll(Eln.instance.furnaceList);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }
}

