/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

public class SlewLimiter {
    private float positiveSlewRate;
    private float negativeSlewRate;
    private float target = 0.0f;
    private float position = 0.0f;

    public SlewLimiter(float slewRate) {
        this.setSlewRate(slewRate);
    }

    public SlewLimiter(float positive, float negative) {
        this.setSlewRate(positive, negative);
    }

    public float getTarget() {
        return this.target;
    }

    public void setTarget(float target) {
        this.target = target;
    }

    public float getPosition() {
        return this.position;
    }

    public void setPosition(float position) {
        this.position = position;
    }

    public boolean targetReached() {
        return this.position == this.target;
    }

    public boolean targetReached(float tolerance) {
        return Math.abs(this.position - this.target) <= tolerance;
    }

    public float getPositiveSlewRate() {
        return this.positiveSlewRate;
    }

    public float getNegativeSlewRate() {
        return this.negativeSlewRate;
    }

    public void setSlewRate(float slewRate) {
        this.positiveSlewRate = Math.abs(slewRate);
        this.negativeSlewRate = Math.abs(slewRate);
    }

    public void setSlewRate(float positive, float negative) {
        this.positiveSlewRate = Math.abs(positive);
        this.negativeSlewRate = Math.abs(negative);
    }

    public void step(float deltaTime) {
        float delta = this.target - this.position;
        if (delta > 0.0f) {
            delta = Math.min(delta, this.positiveSlewRate * deltaTime);
        } else if (delta < 0.0f) {
            delta = Math.max(delta, -this.negativeSlewRate * deltaTime);
        }
        this.position += delta;
    }
}

