/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import mods.eln.Eln;
import mods.eln.generic.GenericItemBlockUsingDamage;
import mods.eln.generic.GenericItemUsingDamage;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.FunctionTable;
import mods.eln.misc.Obj3D;
import mods.eln.node.ITileEntitySpawnClient;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.lwjgl.opengl.GL11;

public class Utils {
    public static final Object[] d = new Object[5];
    public static final double minecraftDay = 1440.0;
    public static final Random random = new Random();
    public static final double burnTimeToEnergyFactor = 1.0;
    public static final double voltageMageFactor = 0.1;
    private static int uuid = 1;

    private Utils() {
    }

    public static double rand(double min, double max) {
        return random.nextDouble() * (max - min) + min;
    }

    public static void println(String str) {
        if (!Eln.debugEnabled) {
            return;
        }
        System.out.println(str);
    }

    public static void println(Object str) {
        if (!Eln.debugEnabled) {
            return;
        }
        System.out.println(str.toString());
    }

    public static void print(String str) {
        if (!Eln.debugEnabled) {
            return;
        }
        System.out.print(str);
    }

    public static void print(Object str) {
        if (!Eln.debugEnabled) {
            return;
        }
        System.out.print(str.toString());
    }

    static String floatToStr(double f, int high, int low) {
        int idx;
        String temp = "";
        for (idx = 0; idx < high; ++idx) {
            temp = temp + "0";
        }
        temp = temp + ".";
        for (idx = 0; idx < low; ++idx) {
            temp = temp + "0";
        }
        String str = new DecimalFormat(temp).format(f);
        char[] ch = str.toCharArray();
        for (int idx2 = 0; str.length() != idx2; ++idx2) {
            if (ch[idx2] == '.') {
                ch[idx2 - 1] = 48;
                break;
            }
            if (ch[idx2] != '0' && ch[idx2] != ' ') break;
            ch[idx2] = 95;
        }
        return new String(ch);
    }

    public static boolean isTheClass(Object o, Class c) {
        if (o.getClass() == c) {
            return true;
        }
        for (Class<?> classIterator = o.getClass().getSuperclass(); classIterator != null; classIterator = classIterator.getSuperclass()) {
            if (classIterator != c) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTheInterface(Object o, Class c) {
        for (Class<?> i : o.getClass().getInterfaces()) {
            if (i != c) continue;
            return true;
        }
        return false;
    }

    public static Direction entityLivingViewDirection(EntityLivingBase entityLiving) {
        if (entityLiving.field_70125_A > 45.0f) {
            return Direction.YN;
        }
        if (entityLiving.field_70125_A < -45.0f) {
            return Direction.YP;
        }
        int dirx = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (dirx == 3) {
            return Direction.XP;
        }
        if (dirx == 0) {
            return Direction.ZP;
        }
        if (dirx == 1) {
            return Direction.XN;
        }
        return Direction.ZN;
    }

    public static Direction entityLivingHorizontalViewDirection(EntityLivingBase entityLiving) {
        int dirx = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (dirx == 3) {
            return Direction.XP;
        }
        if (dirx == 0) {
            return Direction.ZP;
        }
        if (dirx == 1) {
            return Direction.XN;
        }
        return Direction.ZN;
    }

    public static double getItemEnergie(ItemStack par0ItemStack) {
        return 50.0 * (double)TileEntityFurnace.func_145952_a((ItemStack)par0ItemStack);
    }

    public static double getCoalEnergyReference() {
        return 80000.0;
    }

    public static byte booleanSideMaskToByte(boolean[] side) {
        byte b = 0;
        if (side[0]) {
            b = (byte)(b | 1);
        }
        if (side[1]) {
            b = (byte)(b | 2);
        }
        if (side[2]) {
            b = (byte)(b | 4);
        }
        if (side[3]) {
            b = (byte)(b | 8);
        }
        if (side[4]) {
            b = (byte)(b | 0x10);
        }
        if (side[5]) {
            b = (byte)(b | 0x20);
        }
        return b;
    }

    public static void ByteTobooleanSideMask(byte b, boolean[] side) {
        for (int idx = 0; idx < 6; ++idx) {
            side[idx] = false;
            if ((b >> idx & 1) == 0) continue;
            side[idx] = true;
        }
    }

    public static String plotValue(double value) {
        double valueAbs = Math.abs(value);
        if (valueAbs < 0.001) {
            return "0";
        }
        if (valueAbs < 0.00999) {
            return String.format("%1.2fm", value * 1000.0);
        }
        if (valueAbs < 0.0999) {
            return String.format("%2.1fm", value * 1000.0);
        }
        if (valueAbs < 0.999) {
            return String.format("%3.0fm", value * 1000.0);
        }
        if (valueAbs < 9.99) {
            return String.format("%1.2f", value);
        }
        if (valueAbs < 99.9) {
            return String.format("%2.1f", value);
        }
        if (valueAbs < 999.0) {
            return String.format("%3.0f", value);
        }
        if (valueAbs < 9999.0) {
            return String.format("%1.2fk", value / 1000.0);
        }
        if (valueAbs < 99999.0) {
            return String.format("%2.1fk", value / 1000.0);
        }
        return String.format("%3.0fk", value / 1000.0);
    }

    public static String plotValue(double value, String unit) {
        return Utils.plotValue(value) + unit;
    }

    public static String plotVolt(String header, double value) {
        if (!header.equals("")) {
            header = header + " ";
        }
        return header + Utils.plotValue(value, "V  ");
    }

    public static String plotAmpere(String header, double value) {
        if (!header.equals("")) {
            header = header + " ";
        }
        return header + Utils.plotValue(value, "A  ");
    }

    public static String plotCelsius(String header, double value) {
        value += 20.0;
        if (!header.equals("")) {
            header = header + " ";
        }
        return header + Utils.plotValue(value, "\u00b0C ");
    }

    public static String plotPercent(String header, double value) {
        if (!header.equals("")) {
            header = header + " ";
        }
        if (value >= 1.0) {
            return header + String.format("%3.0f", value * 100.0) + "%   ";
        }
        return header + String.format("%3.1f", value * 100.0) + "%   ";
    }

    public static String plotEnergy(String header, double value) {
        if (!header.equals("")) {
            header = header + " ";
        }
        return header + Utils.plotValue(value, "J  ");
    }

    public static String plotRads(String header, double value) {
        if (!header.equals("")) {
            header = header + " ";
        }
        return header + Utils.plotValue(value, "rad/s ");
    }

    public static String plotER(double E, double R) {
        return Utils.plotEnergy("E", E) + Utils.plotRads("R", R);
    }

    public static String plotPower(String header, double value) {
        if (!header.equals("")) {
            header = header + " ";
        }
        return header + Utils.plotValue(value, "W  ");
    }

    public static String plotOhm(String header, double value) {
        if (!header.equals("")) {
            header = header + " ";
        }
        return header + Utils.plotValue(value, "ohm  ");
    }

    public static String plotUIP(double U, double I) {
        return Utils.plotVolt("U", U) + Utils.plotAmpere("I", I) + Utils.plotPower("P", Math.abs(U * I));
    }

    public static String plotTime(double value) {
        String str = "";
        if (value == 0.0) {
            return str + "0''";
        }
        int h = (int)(value / 3600.0);
        int mn = (int)((value %= 3600.0) / 60.0);
        int s = (int)((value %= 60.0) / 1.0);
        if (h != 0) {
            str = str + h + "h";
        }
        if (mn != 0) {
            str = str + mn + "'";
        }
        if (s != 0) {
            str = str + s + "''";
        }
        return str;
    }

    public static String plotTime(String header, double value) {
        if (!header.equals("")) {
            header = header + " ";
        }
        return header + Utils.plotTime(value);
    }

    public static String plotBuckets(String header, double buckets) {
        if (!header.equals("")) {
            header = header + " ";
        }
        return header + Utils.plotValue(buckets, "B ");
    }

    public static void readFromNBT(NBTTagCompound nbt, String str, IInventory inventory) {
        NBTTagList var2 = nbt.func_150295_c(str, 10);
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 < 0 || var5 >= inventory.func_70302_i_()) continue;
            inventory.func_70299_a(var5, ItemStack.func_77949_a((NBTTagCompound)var4));
        }
    }

    public static void writeToNBT(NBTTagCompound nbt, String str, IInventory inventory) {
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < inventory.func_70302_i_(); ++var3) {
            if (inventory.func_70301_a(var3) == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            inventory.func_70301_a(var3).func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a(str, (NBTBase)var2);
    }

    public static void sendPacketToClient(ByteArrayOutputStream bos, EntityPlayerMP player) {
        S3FPacketCustomPayload packet = new S3FPacketCustomPayload("miaouMod", bos.toByteArray());
        player.field_71135_a.func_147359_a((Packet)packet);
    }

    public static void setGlColorFromDye(int damage) {
        Utils.setGlColorFromDye(damage, 1.0f);
    }

    public static void setGlColorFromDye(int damage, float gain) {
        switch (damage) {
            default: {
                GL11.glColor3f((float)(0.05f * gain), (float)(0.05f * gain), (float)(0.05f * gain));
                break;
            }
            case 0: {
                GL11.glColor3f((float)(0.2f * gain), (float)(0.2f * gain), (float)(0.2f * gain));
                break;
            }
            case 1: {
                GL11.glColor3f((float)(1.0f * gain), (float)(0.05f * gain), (float)(0.05f * gain));
                break;
            }
            case 2: {
                GL11.glColor3f((float)(0.2f * gain), (float)(0.5f * gain), (float)(0.1f * gain));
                break;
            }
            case 3: {
                GL11.glColor3f((float)(0.3f * gain), (float)(0.2f * gain), (float)(0.1f * gain));
                break;
            }
            case 4: {
                GL11.glColor3f((float)(0.2f * gain), (float)(0.2f * gain), (float)(1.0f * gain));
                break;
            }
            case 5: {
                GL11.glColor3f((float)(0.7f * gain), (float)(0.05f * gain), (float)(1.0f * gain));
                break;
            }
            case 6: {
                GL11.glColor3f((float)(0.2f * gain), (float)(0.7f * gain), (float)(0.9f * gain));
                break;
            }
            case 7: {
                GL11.glColor3f((float)(0.7f * gain), (float)(0.7f * gain), (float)(0.7f * gain));
                break;
            }
            case 8: {
                GL11.glColor3f((float)(0.4f * gain), (float)(0.4f * gain), (float)(0.4f * gain));
                break;
            }
            case 9: {
                GL11.glColor3f((float)(1.0f * gain), (float)(0.5f * gain), (float)(0.5f * gain));
                break;
            }
            case 10: {
                GL11.glColor3f((float)(0.05f * gain), (float)(1.0f * gain), (float)(0.05f * gain));
                break;
            }
            case 11: {
                GL11.glColor3f((float)(0.9f * gain), (float)(0.8f * gain), (float)(0.1f * gain));
                break;
            }
            case 12: {
                GL11.glColor3f((float)(0.4f * gain), (float)(0.5f * gain), (float)(1.0f * gain));
                break;
            }
            case 13: {
                GL11.glColor3f((float)(0.9f * gain), (float)(0.3f * gain), (float)(0.9f * gain));
                break;
            }
            case 14: {
                GL11.glColor3f((float)(1.0f * gain), (float)(0.6f * gain), (float)(0.3f * gain));
                break;
            }
            case 15: {
                GL11.glColor3f((float)(1.0f * gain), (float)(1.0f * gain), (float)(1.0f * gain));
            }
        }
    }

    public static void setGlColorFromLamp(int colorIdx) {
        switch (colorIdx) {
            default: {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                break;
            }
            case 0: {
                GL11.glColor3f((float)0.25f, (float)0.25f, (float)0.25f);
                break;
            }
            case 1: {
                GL11.glColor3f((float)1.0f, (float)0.5f, (float)0.5f);
                break;
            }
            case 2: {
                GL11.glColor3f((float)0.5f, (float)1.0f, (float)0.5f);
                break;
            }
            case 3: {
                GL11.glColor3f((float)0.5647f, (float)0.36f, (float)0.36f);
                break;
            }
            case 4: {
                GL11.glColor3f((float)0.5f, (float)0.5f, (float)1.0f);
                break;
            }
            case 5: {
                GL11.glColor3f((float)0.78125f, (float)0.46666f, (float)1.0f);
                break;
            }
            case 6: {
                GL11.glColor3f((float)0.5f, (float)1.0f, (float)1.0f);
                break;
            }
            case 7: {
                GL11.glColor3f((float)0.75f, (float)0.75f, (float)0.75f);
                break;
            }
            case 8: {
                GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
                break;
            }
            case 9: {
                GL11.glColor3f((float)1.0f, (float)0.5f, (float)0.65882f);
                break;
            }
            case 10: {
                GL11.glColor3f((float)0.75f, (float)1.0f, (float)0.5f);
                break;
            }
            case 11: {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)0.5f);
                break;
            }
            case 12: {
                GL11.glColor3f((float)0.5f, (float)0.75f, (float)1.0f);
                break;
            }
            case 13: {
                GL11.glColor3f((float)1.0f, (float)0.5f, (float)1.0f);
                break;
            }
            case 14: {
                GL11.glColor3f((float)1.0f, (float)0.8f, (float)0.5f);
            }
        }
    }

    public static double getWeatherNoLoad(int dim) {
        if (!Utils.getWorldExist(dim)) {
            return 0.0;
        }
        World world = Utils.getWorld(dim);
        if (world.func_72911_I()) {
            return 1.0;
        }
        if (world.func_72896_J()) {
            return 0.5;
        }
        return 0.0;
    }

    public static World getWorld(int dim) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dim);
    }

    public static boolean getWorldExist(int dim) {
        return DimensionManager.getWorld((int)dim) != null;
    }

    public static double getWind(int worldId, int y) {
        if (!Utils.getWorldExist(worldId)) {
            return Math.max(0.0, Eln.wind.getWind(y));
        }
        World world = Utils.getWorld(worldId);
        float factor = 1.0f + world.func_72867_j(0.0f) * 0.2f + world.func_72819_i(0.0f) * 0.2f;
        return Math.max(0.0, Eln.wind.getWind(y) * (double)factor + (double)(world.func_72867_j(0.0f) * 1.0f) + (double)(world.func_72819_i(0.0f) * 2.0f));
    }

    public static void dropItem(ItemStack itemStack, int x, int y, int z, World world) {
        if (itemStack == null) {
            return;
        }
        if (world.func_82736_K().func_82766_b("doTileDrops")) {
            float var6 = 0.7f;
            double var7 = (double)(world.field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
            double var9 = (double)(world.field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
            double var11 = (double)(world.field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
            EntityItem var13 = new EntityItem(world, (double)x + var7, (double)y + var9, (double)z + var11, itemStack);
            var13.field_145804_b = 10;
            world.func_72838_d((Entity)var13);
        }
    }

    public static void dropItem(ItemStack itemStack, Coordonate coordonate) {
        Utils.dropItem(itemStack, coordonate.x, coordonate.y, coordonate.z, coordonate.world());
    }

    public static boolean tryPutStackInInventory(ItemStack stack, IInventory inventory, int start2, int count) {
        if (inventory == null) {
            return false;
        }
        for (int idx = start2; idx < start2 + count; ++idx) {
            ItemStack targetStack = inventory.func_70301_a(idx);
            if (targetStack == null) {
                inventory.func_70299_a(idx, stack.func_77946_l());
                stack.field_77994_a = 0;
                return true;
            }
            if (!targetStack.func_77969_a(stack)) continue;
            int transferMax = inventory.func_70297_j_() - targetStack.field_77994_a;
            if (transferMax > 0) {
                int transfer = stack.field_77994_a;
                if (transfer > transferMax) {
                    transfer = transferMax;
                }
                inventory.func_70298_a(idx, -transfer);
                stack.field_77994_a -= transfer;
            }
            if (stack.field_77994_a != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean canPutStackInInventory(ItemStack[] stackList, IInventory inventory, int[] slotsIdList) {
        int idx;
        int limit = inventory.func_70297_j_();
        ItemStack[] outputStack = new ItemStack[slotsIdList.length];
        ItemStack[] inputStack = new ItemStack[stackList.length];
        for (idx = 0; idx < outputStack.length; ++idx) {
            if (inventory.func_70301_a(slotsIdList[idx]) == null) continue;
            outputStack[idx] = inventory.func_70301_a(slotsIdList[idx]).func_77946_l();
        }
        for (idx = 0; idx < stackList.length; ++idx) {
            inputStack[idx] = stackList[idx].func_77946_l();
        }
        for (ItemStack stack : inputStack) {
            boolean oneStackDone = false;
            for (int idx2 = 0; idx2 < slotsIdList.length; ++idx2) {
                ItemStack targetStack = outputStack[idx2];
                if (targetStack == null) {
                    outputStack[idx2] = stack;
                    oneStackDone = true;
                    break;
                }
                if (!targetStack.func_77969_a(stack)) continue;
                int transferMax = limit - targetStack.field_77994_a;
                if (transferMax > 0) {
                    int transfer = stack.field_77994_a;
                    if (transfer > transferMax) {
                        transfer = transferMax;
                    }
                    outputStack[idx2].field_77994_a += transfer;
                    stack.field_77994_a -= transfer;
                }
                if (stack.field_77994_a != 0) continue;
                oneStackDone = true;
                break;
            }
            if (oneStackDone) continue;
            return false;
        }
        return true;
    }

    public static boolean tryPutStackInInventory(ItemStack[] stackList, IInventory inventory, int[] slotsIdList) {
        int limit = inventory.func_70297_j_();
        block0: for (ItemStack stack : stackList) {
            for (int idx = 0; idx < slotsIdList.length; ++idx) {
                ItemStack targetStack = inventory.func_70301_a(slotsIdList[idx]);
                if (targetStack == null) {
                    inventory.func_70299_a(slotsIdList[idx], stack.func_77946_l());
                    stack.field_77994_a = 0;
                    continue block0;
                }
                if (!targetStack.func_77969_a(stack)) continue;
                int transferMax = limit - targetStack.field_77994_a;
                if (transferMax > 0) {
                    int transfer = stack.field_77994_a;
                    if (transfer > transferMax) {
                        transfer = transferMax;
                    }
                    inventory.func_70298_a(slotsIdList[idx], -transfer);
                    stack.field_77994_a -= transfer;
                }
                if (stack.field_77994_a == 0) continue block0;
            }
        }
        return true;
    }

    public static double voltageMargeFactorSub(double value) {
        if (value > 1.1) {
            return value - 0.1;
        }
        if (value > 1.0) {
            return 1.0;
        }
        return value;
    }

    public static void serialiseItemStack(DataOutputStream stream, ItemStack stack) throws IOException {
        if (stack == null) {
            stream.writeShort(-1);
            stream.writeShort(-1);
        } else {
            stream.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            stream.writeShort(stack.func_77960_j());
        }
    }

    public static ItemStack unserialiseItemStack(DataInputStream stream) throws IOException {
        short id = stream.readShort();
        short damage = stream.readShort();
        if (id == -1) {
            return null;
        }
        return Utils.newItemStack(id, 1, (int)damage);
    }

    public static EntityItem unserializeItemStackToEntityItem(DataInputStream stream, EntityItem old, TileEntity tileEntity) throws IOException {
        short itemId = stream.readShort();
        if (itemId == -1) {
            stream.readShort();
            return null;
        }
        short ItemDamage = stream.readShort();
        if (old == null || Item.func_150891_b((Item)old.func_92059_d().func_77973_b()) != itemId || old.func_92059_d().func_77960_j() != ItemDamage) {
            return new EntityItem(tileEntity.func_145831_w(), (double)tileEntity.field_145851_c + 0.5, (double)tileEntity.field_145848_d + 0.5, (double)tileEntity.field_145849_e + 1.2, Utils.newItemStack(itemId, 1, (int)ItemDamage));
        }
        return old;
    }

    public static boolean isGameInPause() {
        return Minecraft.func_71410_x().func_147113_T();
    }

    public static int getLight(World w, EnumSkyBlock e, int x, int y, int z) {
        return w.func_72972_b(e, x, y, z);
    }

    public static void notifyNeighbor(TileEntity t) {
        int x = t.field_145851_c;
        int y = t.field_145848_d;
        int z = t.field_145849_e;
        World w = t.func_145831_w();
        TileEntity o = w.func_147438_o(x + 1, y, z);
        if (o != null && o instanceof ITileEntitySpawnClient) {
            ((ITileEntitySpawnClient)o).tileEntityNeighborSpawn();
        }
        if ((o = w.func_147438_o(x - 1, y, z)) != null && o instanceof ITileEntitySpawnClient) {
            ((ITileEntitySpawnClient)o).tileEntityNeighborSpawn();
        }
        if ((o = w.func_147438_o(x, y + 1, z)) != null && o instanceof ITileEntitySpawnClient) {
            ((ITileEntitySpawnClient)o).tileEntityNeighborSpawn();
        }
        if ((o = w.func_147438_o(x, y - 1, z)) != null && o instanceof ITileEntitySpawnClient) {
            ((ITileEntitySpawnClient)o).tileEntityNeighborSpawn();
        }
        if ((o = w.func_147438_o(x, y, z + 1)) != null && o instanceof ITileEntitySpawnClient) {
            ((ITileEntitySpawnClient)o).tileEntityNeighborSpawn();
        }
        if ((o = w.func_147438_o(x, y, z - 1)) != null && o instanceof ITileEntitySpawnClient) {
            ((ITileEntitySpawnClient)o).tileEntityNeighborSpawn();
        }
    }

    public static boolean playerHasMeter(EntityPlayer entityPlayer) {
        if (Eln.multiMeterElement.checkSameItemStack(entityPlayer.func_71045_bC())) {
            return true;
        }
        if (Eln.thermoMeterElement.checkSameItemStack(entityPlayer.func_71045_bC())) {
            return true;
        }
        return Eln.allMeterElement.checkSameItemStack(entityPlayer.func_71045_bC());
    }

    public static int getRedstoneLevelAround(Coordonate coord) {
        int level = 0;
        if ((level = Math.max(level, coord.world().func_94572_D(coord.x, coord.y, coord.z))) == 15) {
            return 15;
        }
        if ((level = Math.max(level, coord.world().func_94572_D(coord.x + 1, coord.y, coord.z))) == 15) {
            return 15;
        }
        if ((level = Math.max(level, coord.world().func_94572_D(coord.x, coord.y + 1, coord.z))) == 15) {
            return 15;
        }
        if ((level = Math.max(level, coord.world().func_94572_D(coord.x, coord.y - 1, coord.z))) == 15) {
            return 15;
        }
        if ((level = Math.max(level, coord.world().func_94572_D(coord.x, coord.y, coord.z + 1))) == 15) {
            return 15;
        }
        if ((level = Math.max(level, coord.world().func_94572_D(coord.x, coord.y, coord.z - 1))) == 15) {
            return 15;
        }
        if ((level = Math.max(level, coord.world().func_94572_D(coord.x, coord.y, coord.z))) == 15) {
            return 15;
        }
        return level;
    }

    public static int getRedstoneLevelAround(World w, int x, int y, int z) {
        int level = 0;
        if ((level = Math.max(level, w.func_94572_D(x, y, z))) == 15) {
            return 15;
        }
        if ((level = Math.max(level, w.func_94572_D(x + 1, y, z))) == 15) {
            return 15;
        }
        if ((level = Math.max(level, w.func_94572_D(x, y + 1, z))) == 15) {
            return 15;
        }
        if ((level = Math.max(level, w.func_94572_D(x, y - 1, z))) == 15) {
            return 15;
        }
        if ((level = Math.max(level, w.func_94572_D(x, y, z + 1))) == 15) {
            return 15;
        }
        if ((level = Math.max(level, w.func_94572_D(x, y, z - 1))) == 15) {
            return 15;
        }
        if ((level = Math.max(level, w.func_94572_D(x, y, z))) == 15) {
            return 15;
        }
        return level;
    }

    public static boolean isPlayerAround(World world, AxisAlignedBB axisAlignedBB) {
        return !world.func_72872_a(EntityPlayer.class, axisAlignedBB).isEmpty();
    }

    public static Object getItemObject(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Item i = stack.func_77973_b();
        if (i instanceof GenericItemUsingDamage) {
            return ((GenericItemUsingDamage)i).getDescriptor(stack);
        }
        if (i instanceof GenericItemBlockUsingDamage) {
            return ((GenericItemBlockUsingDamage)i).getDescriptor(stack);
        }
        return i;
    }

    public static void getItemStack(String name, List list) {
        Iterator aitem = Item.field_150901_e.iterator();
        ArrayList tempList = new ArrayList(3000);
        while (aitem.hasNext()) {
            Item item = (Item)aitem.next();
            if (item == null || item.func_77640_w() == null) continue;
            item.func_150895_a(item, (CreativeTabs)null, tempList);
        }
        String s = name.toLowerCase();
        for (ItemStack itemstack : tempList) {
            if (!itemstack.func_82833_r().toLowerCase().contains(s)) continue;
            list.add(itemstack);
        }
    }

    public static Side getSide() {
        return FMLCommonHandler.instance().getEffectiveSide();
    }

    public static boolean isServer() {
        return Utils.getSide() == Side.SERVER;
    }

    public static void printSide(String string) {
        Utils.println(string);
    }

    public static short modbusToShort(double outputNormalized, int i) {
        int bit = Float.floatToRawIntBits((float)outputNormalized);
        if (i == 1) {
            return (short)bit;
        }
        return (short)(bit >>> 16);
    }

    public static float modbusToFloat(short first, short second) {
        int bit = ((first & 0xFFFF) << 16) + (second & 0xFFFF);
        return Float.intBitsToFloat(bit);
    }

    public static boolean areSame(ItemStack stack, ItemStack output) {
        try {
            int[] outputIds;
            if (stack.func_77973_b() == output.func_77973_b() && stack.func_77960_j() == output.func_77960_j()) {
                return true;
            }
            int[] stackIds = OreDictionary.getOreIDs((ItemStack)stack);
            for (int i : outputIds = OreDictionary.getOreIDs((ItemStack)output)) {
                for (int j : stackIds) {
                    if (i != j) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static Vec3 getVec05(Coordonate c) {
        return Vec3.func_72443_a((double)((double)c.x + (double)(c.x < 0 ? -1 : 1) * 0.5), (double)((double)c.y + (double)(c.y < 0 ? -1 : 1) * 0.5), (double)((double)c.z + (double)(c.z < 0 ? -1 : 1) * 0.5));
    }

    public static double getHeadPosY(Entity e) {
        if (e instanceof EntityOtherPlayerMP) {
            return e.field_70163_u + (double)e.func_70047_e();
        }
        return e.field_70163_u;
    }

    public static boolean isCreative(EntityPlayerMP entityPlayer) {
        return entityPlayer.field_71134_c.func_73083_d();
    }

    public static boolean mustDropItem(EntityPlayerMP entityPlayer) {
        if (entityPlayer == null) {
            return true;
        }
        return !Utils.isCreative(entityPlayer);
    }

    public static void serverTeleport(Entity e, double x, double y, double z) {
        if (e instanceof EntityPlayerMP) {
            ((EntityPlayerMP)e).func_70634_a(x, y, z);
        } else {
            e.func_70107_b(x, y, z);
        }
    }

    public static ArrayList<Block> traceRay(World world, double x, double y, double z, double tx, double ty, double tz) {
        ArrayList<Block> blockList = new ArrayList<Block>();
        double dx = tx - x;
        double dy = ty - y;
        double dz = tz - z;
        double norm = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double normInv = 1.0 / (norm + 1.0E-9);
        dx *= normInv;
        dy *= normInv;
        dz *= normInv;
        for (double d = 0.0; d < norm; d += 1.0) {
            Block b;
            if (Utils.isBlockLoaded(world, x, y, z) && (b = Utils.getBlock(world, x, y, z)) != null) {
                blockList.add(b);
            }
            x += dx;
            y += dy;
            z += dz;
        }
        return blockList;
    }

    public static float traceRay(World w, double posX, double posY, double posZ, double targetX, double targetY, double targetZ, TraceRayWeight weight) {
        float dBest;
        int posXint = (int)Math.round(posX);
        int posYint = (int)Math.round(posY);
        int posZint = (int)Math.round(posZ);
        float x = (float)(posX - (double)posXint);
        float y = (float)(posY - (double)posYint);
        float z = (float)(posZ - (double)posZint);
        float vx = (float)(targetX - posX);
        float vy = (float)(targetY - posY);
        float vz = (float)(targetZ - posZ);
        float rangeMax = (float)Math.sqrt(vx * vx + vy * vy + vz * vz);
        float normInv = 1.0f / rangeMax;
        vy *= normInv;
        vz *= normInv;
        if ((vx *= normInv) == 0.0f) {
            vx += 1.0E-4f;
        }
        if (vy == 0.0f) {
            vy += 1.0E-4f;
        }
        if (vz == 0.0f) {
            vz += 1.0E-4f;
        }
        float vxInv = 1.0f / vx;
        float vyInv = 1.0f / vy;
        float vzInv = 1.0f / vz;
        float stackRed = 0.0f;
        for (float d = 0.0f; d < rangeMax; d += dBest) {
            float xFloor = MathHelper.func_76141_d((float)x);
            float yFloor = MathHelper.func_76141_d((float)y);
            float zFloor = MathHelper.func_76141_d((float)z);
            float dx = x - xFloor;
            float dy = y - yFloor;
            float dz = z - zFloor;
            dx = vx > 0.0f ? (1.0f - dx) * vxInv : -dx * vxInv;
            dy = vy > 0.0f ? (1.0f - dy) * vyInv : -dy * vyInv;
            dz = vz > 0.0f ? (1.0f - dz) * vzInv : -dz * vzInv;
            dBest = Math.min(Math.min(dx, dy), dz) + 0.01f;
            int xInt = (int)xFloor;
            int yInt = (int)yFloor;
            int zInt = (int)zFloor;
            Block block = Blocks.field_150350_a;
            if (w.func_72899_e(xInt + posXint, yInt + posYint, zInt + posZint)) {
                block = w.func_147439_a(xInt + posXint, yInt + posYint, zInt + posZint);
            }
            float dToStack = d + dBest < rangeMax ? dBest : rangeMax - d;
            stackRed += weight.getWeight(block) * dToStack;
            x += vx * dBest;
            y += vy * dBest;
            z += vz * dBest;
        }
        return stackRed;
    }

    public static boolean isBlockLoaded(World world, double x, double y, double z) {
        return world.func_72899_e(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
    }

    public static Block getBlock(World world, double x, double y, double z) {
        Block block = world.func_147439_a(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
        return block;
    }

    public static double getLength(double x, double y, double z, double tx, double ty, double tz) {
        double dx = tx - x;
        double dy = ty - y;
        double dz = tz - z;
        double norm = Math.sqrt(dx * dx + dy * dy + dz * dz);
        return norm;
    }

    public static <T> int readPrivateInt(Object o, String feildName) {
        try {
            Field f = o.getClass().getDeclaredField(feildName);
            f.setAccessible(true);
            return f.getInt(o);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static <T> double readPrivateDouble(Object o, String feildName) {
        try {
            Field f = o.getClass().getDeclaredField(feildName);
            f.setAccessible(true);
            return f.getDouble(o);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    public static ItemStack[][] getItemStackGrid(IRecipe r) {
        ItemStack[][] stacks = new ItemStack[3][3];
        try {
            if (r instanceof ShapedRecipes) {
                ShapedRecipes s = (ShapedRecipes)r;
                for (int idx2 = 0; idx2 < 3; ++idx2) {
                    for (int idx = 0; idx < 3; ++idx) {
                        ItemStack rStack = null;
                        if (idx < s.field_77576_b && idx2 < s.field_77577_c) {
                            rStack = s.field_77574_d[idx + idx2 * s.field_77576_b];
                        }
                        stacks[idx2][idx] = rStack;
                    }
                }
                return stacks;
            }
            if (r instanceof ShapedOreRecipe) {
                ShapedOreRecipe s = (ShapedOreRecipe)r;
                int width = Utils.readPrivateInt(s, "width");
                int height = Utils.readPrivateInt(s, "height");
                Object[] inputs = s.getInput();
                for (int idx2 = 0; idx2 < height; ++idx2) {
                    for (int idx = 0; idx < width; ++idx) {
                        Object o = inputs[idx + idx2 * width];
                        ItemStack stack = null;
                        if (o instanceof List && o instanceof List && !((List)o).isEmpty()) {
                            stack = (ItemStack)((List)o).get(0);
                        }
                        if (o instanceof ItemStack) {
                            stack = (ItemStack)o;
                        }
                        stacks[idx2][idx] = stack;
                    }
                }
                return stacks;
            }
            if (r instanceof ShapelessRecipes) {
                ShapelessRecipes s = (ShapelessRecipes)r;
                int idx = 0;
                for (Object o : s.field_77579_b) {
                    ItemStack stack;
                    stacks[idx / 3][idx % 3] = stack = (ItemStack)o;
                    ++idx;
                }
                return stacks;
            }
            if (r instanceof ShapelessOreRecipe) {
                ShapelessOreRecipe s = (ShapelessOreRecipe)r;
                int idx = 0;
                for (Object o : s.getInput()) {
                    ItemStack stack = null;
                    if (o instanceof List && !((List)o).isEmpty()) {
                        stack = (ItemStack)((List)o).get(0);
                    }
                    if (o instanceof ItemStack) {
                        stack = (ItemStack)o;
                    }
                    stacks[idx / 3][idx % 3] = stack;
                    ++idx;
                }
                return stacks;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ArrayList<ItemStack> getRecipeInputs(IRecipe r) {
        try {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (r instanceof ShapedRecipes) {
                for (ItemStack stack : ((ShapedRecipes)r).field_77574_d) {
                    stacks.add(stack);
                }
            }
            if (r instanceof ShapelessRecipes) {
                for (Object stack : ((ShapelessRecipes)r).field_77579_b) {
                    stacks.add((ItemStack)stack);
                }
            }
            if (r instanceof ShapedOreRecipe) {
                for (Object o : ((ShapedOreRecipe)r).getInput()) {
                    if (o instanceof List) {
                        stacks.addAll((List)o);
                    }
                    if (!(o instanceof ItemStack)) continue;
                    stacks.add((ItemStack)o);
                }
            }
            if (r instanceof ShapelessOreRecipe) {
                for (Object o : ((ShapelessOreRecipe)r).getInput()) {
                    if (o instanceof List) {
                        stacks.addAll((List)o);
                    }
                    if (!(o instanceof ItemStack)) continue;
                    stacks.add((ItemStack)o);
                }
            }
            return stacks;
        }
        catch (Exception e) {
            return new ArrayList<ItemStack>();
        }
    }

    public static double getWorldTime(World world) {
        return (double)world.func_72820_D() / 23999.0;
    }

    public static boolean isWater(Coordonate waterCoord) {
        Block block = waterCoord.getBlock();
        return block == Blocks.field_150358_i || block == Blocks.field_150355_j;
    }

    public static void addChatMessage(EntityPlayer entityPlayer, String string) {
        entityPlayer.func_145747_a((IChatComponent)new ChatComponentText(string));
    }

    public static ItemStack newItemStack(int i, int size, int damage) {
        return new ItemStack(Item.func_150899_d((int)i), size, damage);
    }

    public static ItemStack newItemStack(Item i, int size, int damage) {
        return new ItemStack(i, size, damage);
    }

    public static List<NBTTagCompound> getTags(NBTTagCompound nbt) {
        Object[] set = nbt.func_150296_c().toArray();
        ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
        for (int idx = 0; idx < set.length; ++idx) {
            tags.add(nbt.func_74775_l((String)set[idx]));
        }
        return tags;
    }

    public static boolean isRemote(IBlockAccess world) {
        if (!(world instanceof World)) {
            Utils.fatal();
        }
        return ((World)world).field_72995_K;
    }

    public static boolean nullCheck(Object o) {
        return o == null;
    }

    public static void nullFatal(Object o) {
        if (o == null) {
            Utils.fatal();
        }
    }

    public static void fatal() {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static Block getBlock(int blockId) {
        return Block.func_149729_e((int)blockId);
    }

    public static void updateSkylight(Chunk chunk) {
        chunk.func_150804_b(false);
    }

    public static void updateAllLightTypes(World worldObj, int xCoord, int yCoord, int zCoord) {
        worldObj.func_147451_t(xCoord, yCoord, zCoord);
        worldObj.func_72975_g(xCoord, zCoord, 0, 255);
    }

    public static int getItemId(ItemStack stack) {
        return Item.func_150891_b((Item)stack.func_77973_b());
    }

    public static int getItemId(Block block) {
        return Item.func_150891_b((Item)Item.func_150898_a((Block)block));
    }

    public static void addSmelting(Item parentItem, int parentItemDamage, ItemStack findItemStack, float f) {
        FurnaceRecipes.func_77602_a().func_151394_a(Utils.newItemStack(parentItem, 1, parentItemDamage), findItemStack, f);
    }

    public static void addSmelting(Block parentBlock, int parentItemDamage, ItemStack findItemStack, float f) {
        FurnaceRecipes.func_77602_a().func_151394_a(Utils.newItemStack(Item.func_150898_a((Block)parentBlock), 1, parentItemDamage), findItemStack, f);
    }

    public static void addSmelting(Item parentItem, int parentItemDamage, ItemStack findItemStack) {
        Utils.addSmelting(parentItem, parentItemDamage, findItemStack, 0.3f);
    }

    public static void addSmelting(Block parentBlock, int parentItemDamage, ItemStack findItemStack) {
        Utils.addSmelting(parentBlock, parentItemDamage, findItemStack, 0.3f);
    }

    public static NBTTagCompound newNbtTagCompund(NBTTagCompound nbt, String string) {
        NBTTagCompound cmp = new NBTTagCompound();
        nbt.func_74782_a(string, (NBTBase)cmp);
        return cmp;
    }

    public static String getMapFolder() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        String savesAt = !server.func_71262_S() ? "saves/" : "";
        return savesAt + server.func_71270_I() + "/";
    }

    public static File getMapFile(String name) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        File f = server.func_71209_f(Utils.getMapFolder() + name);
        return f;
    }

    public static String readMapFile(String name) throws IOException {
        File file = Utils.getMapFile(name);
        FileInputStream fis = new FileInputStream(file);
        byte[] data = new byte[(int)file.length()];
        fis.read(data);
        fis.close();
        String s = new String(data, "UTF-8");
        return s;
    }

    public static void generateHeightMap(Chunk chunk) {
    }

    public static int getUuid() {
        if (uuid < 1) {
            uuid = 1;
        }
        return uuid++;
    }

    public static float[] getSixNodePinDistance(Obj3D.Obj3DPart obj) {
        return new float[]{Math.abs(obj.zMin * 16.0f), Math.abs(obj.zMax * 16.0f), Math.abs(obj.yMin * 16.0f), Math.abs(obj.yMax * 16.0f)};
    }

    public static boolean isWrench(ItemStack stack) {
        return Utils.areSame(stack, Eln.wrenchItemStack) || stack.func_82833_r().toLowerCase().contains("wrench");
    }

    public static boolean isPlayerUsingWrench(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        if (Eln.playerManager.get(player).getInteractEnable()) {
            return true;
        }
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack == null) {
            return false;
        }
        return Utils.isWrench(stack);
    }

    public static boolean isClassLoaded(String name) {
        try {
            Class<?> cc = Class.forName(name);
            if (cc != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static String plotSignal(double U, double I) {
        return Utils.plotVolt("U", U) + Utils.plotAmpere("I", I) + Utils.plotPercent("Value", U / 50.0);
    }

    public static float limit(float value, float min, float max) {
        return Math.max(Math.min(value, max), min);
    }

    public static double limit(double value, double min, double max) {
        return Math.max(Math.min(value, max), min);
    }

    public static void printFunction(FunctionTable func, double start2, double end, double step) {
        Utils.println("********");
        int idx = 0;
        while (true) {
            double d;
            double x = start2 + step * (double)idx;
            if (!(d < end + 1.0E-5)) break;
            Utils.println(func.getValue(x));
            ++idx;
        }
        Utils.println("********");
    }

    public static class TraceRayWeightOpaque
    implements TraceRayWeight {
        @Override
        public float getWeight(Block block) {
            if (block == null) {
                return 0.0f;
            }
            return block.func_149662_c() ? 1.0f : 0.0f;
        }
    }

    static interface TraceRayWeight {
        public float getWeight(Block var1);
    }
}

