/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.util.HashSet;
import java.util.List;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.node.transparent.TransparentNodeEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class UtilsClient {
    public static GuiScreen guiLastOpen;
    static boolean lightmapTexUnitTextureEnable;
    protected static RenderItem itemRenderer;
    private static int uuid;
    static final ResourceLocation whiteTexture;
    static final HashSet<Integer> glListsAllocated;

    private UtilsClient() {
    }

    public static float distanceFromClientPlayer(World world, int xCoord, int yCoord, int zCoord) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        return (float)Math.sqrt(((double)xCoord - player.field_70165_t) * ((double)xCoord - player.field_70165_t) + ((double)yCoord - player.field_70163_u) * ((double)yCoord - player.field_70163_u) + ((double)zCoord - player.field_70161_v) * ((double)zCoord - player.field_70161_v));
    }

    public static float distanceFromClientPlayer(SixNodeEntity tileEntity) {
        return UtilsClient.distanceFromClientPlayer(tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
    }

    public static EntityClientPlayerMP getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static void drawHaloNoLightSetup(Obj3D.Obj3DPart halo, float r, float g, float b, World w, int x, int y, int z, boolean bilinear) {
        if (halo == null) {
            return;
        }
        if (bilinear) {
            UtilsClient.enableBilinear();
        }
        int light = UtilsClient.getLight(w, x, y, z) * 19 / 15 - 4;
        EntityClientPlayerMP e = UtilsClient.getClientPlayer();
        float d = (float)(Math.abs((double)x - e.field_70165_t) + Math.abs((double)y - e.field_70163_u) + Math.abs((double)z - e.field_70161_v));
        GL11.glColor4f((float)r, (float)g, (float)b, (float)(1.0f - (float)light / 15.0f));
        halo.draw(d * 20.0f, 1.0f, 0.0f, 0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (bilinear) {
            UtilsClient.disableBilinear();
        }
    }

    public static void clientOpenGui(GuiScreen gui) {
        guiLastOpen = gui;
        EntityClientPlayerMP clientPlayer = UtilsClient.getClientPlayer();
        clientPlayer.openGui((Object)Eln.instance, 5977, clientPlayer.field_70170_p, 0, 0, 0);
    }

    public static void drawHalo(Obj3D.Obj3DPart halo, float r, float g, float b, World w, int x, int y, int z, boolean bilinear) {
        UtilsClient.disableLight();
        UtilsClient.enableBlend();
        UtilsClient.drawHaloNoLightSetup(halo, r, g, b, w, x, y, z, bilinear);
        UtilsClient.enableLight();
        UtilsClient.disableBlend();
    }

    public static void drawHaloNoLightSetup(Obj3D.Obj3DPart halo, float r, float g, float b, TileEntity e, boolean bilinear) {
        UtilsClient.drawHaloNoLightSetup(halo, r, g, b, e.func_145831_w(), e.field_145851_c, e.field_145848_d, e.field_145849_e, bilinear);
    }

    public static void drawHalo(Obj3D.Obj3DPart halo, float r, float g, float b, TileEntity e, boolean bilinear) {
        UtilsClient.drawHalo(halo, r, g, b, e.func_145831_w(), e.field_145851_c, e.field_145848_d, e.field_145849_e, bilinear);
    }

    public static void drawHaloNoLightSetup(Obj3D.Obj3DPart halo, float distance) {
        if (halo == null) {
            return;
        }
        halo.faceGroup.get(0).bindTexture();
        UtilsClient.enableBilinear();
        halo.drawNoBind();
    }

    public static void drawHalo(Obj3D.Obj3DPart halo, float distance) {
        UtilsClient.disableLight();
        UtilsClient.enableBlend();
        UtilsClient.drawHaloNoLightSetup(halo, distance);
        UtilsClient.enableLight();
        UtilsClient.disableBlend();
    }

    public static void drawHaloNoLightSetup(Obj3D.Obj3DPart halo, float r, float g, float b, Entity e, boolean bilinear) {
        if (halo == null) {
            return;
        }
        if (bilinear) {
            UtilsClient.enableBilinear();
        }
        int light = UtilsClient.getLight(e.field_70170_p, MathHelper.func_76128_c((double)e.field_70165_t), MathHelper.func_76128_c((double)e.field_70163_u), MathHelper.func_76128_c((double)e.field_70161_v));
        GL11.glColor4f((float)r, (float)g, (float)b, (float)(1.0f - (float)light / 15.0f));
        halo.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (bilinear) {
            UtilsClient.disableBilinear();
        }
    }

    public static void drawHalo(Obj3D.Obj3DPart halo, float r, float g, float b, Entity e, boolean bilinear) {
        UtilsClient.disableLight();
        UtilsClient.enableBlend();
        UtilsClient.drawHaloNoLightSetup(halo, r, g, b, e, bilinear);
        UtilsClient.enableLight();
        UtilsClient.disableBlend();
    }

    public static void enableBilinear() {
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
    }

    public static void disableBilinear() {
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
    }

    public static void disableCulling() {
        GL11.glDisable((int)2884);
    }

    public static void enableCulling() {
        GL11.glEnable((int)2884);
    }

    public static void disableTexture() {
        UtilsClient.bindTexture(whiteTexture);
    }

    public static void enableTexture() {
    }

    public static void disableLight() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        lightmapTexUnitTextureEnable = GL11.glGetBoolean((int)3553);
        if (lightmapTexUnitTextureEnable) {
            GL11.glDisable((int)3553);
        }
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        GL11.glDisable((int)2896);
    }

    public static void enableLight() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        if (lightmapTexUnitTextureEnable) {
            GL11.glEnable((int)3553);
        }
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        GL11.glEnable((int)2896);
    }

    public static void enableBlend() {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.02f);
    }

    public static void disableBlend() {
        GL11.glDisable((int)3042);
    }

    public static void drawIcon(IItemRenderer.ItemRenderType type) {
        UtilsClient.enableBlend();
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            UtilsClient.disableCulling();
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)16.0f, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)0.0f, (float)16.0f, (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)16.0f, (float)16.0f, (float)0.0f);
            GL11.glEnd();
            UtilsClient.enableCulling();
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            UtilsClient.disableCulling();
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.5f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)-0.5f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)1.0f, (float)-0.5f);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.5f);
            GL11.glEnd();
            UtilsClient.enableCulling();
        } else {
            GL11.glTranslatef((float)0.5f, (float)-0.3f, (float)0.5f);
            UtilsClient.disableCulling();
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)0.0f, (float)0.5f, (float)0.5f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)0.0f, (float)0.5f, (float)-0.5f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)1.5f, (float)-0.5f);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)1.5f, (float)0.5f);
            GL11.glEnd();
            UtilsClient.enableCulling();
        }
        UtilsClient.disableBlend();
    }

    public static void drawIcon(IItemRenderer.ItemRenderType type, ResourceLocation icon) {
        UtilsClient.bindTexture(icon);
        UtilsClient.drawIcon(type);
    }

    public static void drawEnergyBare(IItemRenderer.ItemRenderType type, float e) {
        UtilsClient.drawIcon(type, new ResourceLocation("eln", "sprites/portablebatteryoverlay.png"));
        float x = 13.0f;
        float y = 14.0f - e * 12.0f;
        GL11.glDisable((int)3553);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glBegin((int)7);
        GL11.glVertex3f((float)(x + 1.0f), (float)2.0f, (float)0.01f);
        GL11.glVertex3f((float)x, (float)2.0f, (float)0.0f);
        GL11.glVertex3f((float)x, (float)14.0f, (float)0.0f);
        GL11.glVertex3f((float)(x + 1.0f), (float)14.0f, (float)0.01f);
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)e, (float)0.0f);
        GL11.glBegin((int)7);
        GL11.glVertex3f((float)(x + 1.0f), (float)y, (float)0.01f);
        GL11.glVertex3f((float)x, (float)y, (float)0.0f);
        GL11.glVertex3f((float)x, (float)14.0f, (float)0.0f);
        GL11.glVertex3f((float)(x + 1.0f), (float)14.0f, (float)0.01f);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void bindTexture(ResourceLocation resource) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resource);
    }

    public static void ledOnOffColor(boolean on) {
        if (!on) {
            GL11.glColor3f((float)0.7f, (float)0.0f, (float)0.0f);
        } else {
            GL11.glColor3f((float)0.0f, (float)0.7f, (float)0.0f);
        }
    }

    public static Color ledOnOffColorC(boolean on) {
        if (!on) {
            return new Color(0.7f, 0.0f, 0.0f);
        }
        return new Color(0.0f, 0.7f, 0.0f);
    }

    public static void drawLight(Obj3D.Obj3DPart part) {
        if (part == null) {
            return;
        }
        UtilsClient.disableLight();
        UtilsClient.enableBlend();
        part.draw();
        UtilsClient.enableLight();
        UtilsClient.disableBlend();
    }

    public static void drawLightNoBind(Obj3D.Obj3DPart part) {
        if (part == null) {
            return;
        }
        UtilsClient.disableLight();
        UtilsClient.enableBlend();
        part.drawNoBind();
        UtilsClient.enableLight();
        UtilsClient.disableBlend();
    }

    public static void drawGuiBackground(ResourceLocation ressource, GuiScreen guiScreen, int xSize, int ySize) {
        UtilsClient.bindTexture(ressource);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (guiScreen.field_146294_l - xSize) / 2;
        int y = (guiScreen.field_146295_m - ySize) / 2;
        guiScreen.func_73729_b(x, y, 0, 0, xSize, ySize);
    }

    public static void drawLight(Obj3D.Obj3DPart part, float angle, float x, float y, float z) {
        if (part == null) {
            return;
        }
        UtilsClient.disableLight();
        UtilsClient.enableBlend();
        part.draw(angle, x, y, z);
        UtilsClient.enableLight();
        UtilsClient.disableBlend();
    }

    public static void glDefaultColor() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawEntityItem(EntityItem entityItem, double x, double y, double z, float roty, float scale) {
        if (entityItem == null) {
            return;
        }
        entityItem.field_70290_d = 0.0f;
        entityItem.field_70177_z = 0.0f;
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = 0.0;
        entityItem.field_70179_y = 0.0;
        Render var10 = RenderManager.field_78727_a.func_78713_a((Entity)entityItem);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)roty, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        var10.func_76986_a((Entity)entityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GL11.glPopMatrix();
    }

    public static void drawConnectionPinSixNode(float d, float w, float h) {
        d += 0.1f;
        h *= 0.0625f;
        float w2 = (w *= 0.0625f) * 0.5f;
        UtilsClient.disableTexture();
        GL11.glBegin((int)7);
        GL11.glVertex3f((float)(-w2), (float)(d *= 0.0625f), (float)0.0f);
        GL11.glVertex3f((float)w2, (float)d, (float)0.0f);
        GL11.glVertex3f((float)w2, (float)d, (float)h);
        GL11.glVertex3f((float)(-w2), (float)d, (float)h);
        GL11.glEnd();
        UtilsClient.enableTexture();
    }

    public static void drawConnectionPinSixNode(LRDU front, float[] dList, float w, float h) {
        float d = dList[front.toInt()];
        d += 0.04f;
        d *= 0.0625f;
        h *= 0.0625f;
        float w2 = (w *= 0.0625f) * 0.5f;
        UtilsClient.disableTexture();
        GL11.glBegin((int)7);
        switch (front) {
            case Left: {
                GL11.glVertex3f((float)0.0f, (float)(-w2), (float)(-d));
                GL11.glVertex3f((float)0.0f, (float)w2, (float)(-d));
                GL11.glVertex3f((float)h, (float)w2, (float)(-d));
                GL11.glVertex3f((float)h, (float)(-w2), (float)(-d));
                break;
            }
            case Right: {
                GL11.glVertex3f((float)h, (float)(-w2), (float)d);
                GL11.glVertex3f((float)h, (float)w2, (float)d);
                GL11.glVertex3f((float)0.0f, (float)w2, (float)d);
                GL11.glVertex3f((float)0.0f, (float)(-w2), (float)d);
                break;
            }
            case Down: {
                GL11.glVertex3f((float)h, (float)(-d), (float)(-w2));
                GL11.glVertex3f((float)h, (float)(-d), (float)w2);
                GL11.glVertex3f((float)0.0f, (float)(-d), (float)w2);
                GL11.glVertex3f((float)0.0f, (float)(-d), (float)(-w2));
                break;
            }
            case Up: {
                GL11.glVertex3f((float)0.0f, (float)d, (float)(-w2));
                GL11.glVertex3f((float)0.0f, (float)d, (float)w2);
                GL11.glVertex3f((float)h, (float)d, (float)w2);
                GL11.glVertex3f((float)h, (float)d, (float)(-w2));
                break;
            }
        }
        GL11.glEnd();
        UtilsClient.enableTexture();
    }

    static RenderItem getItemRender() {
        if (itemRenderer == null) {
            itemRenderer = new RenderItem();
        }
        return itemRenderer;
    }

    static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    public static void guiScale() {
        GL11.glScalef((float)16.0f, (float)16.0f, (float)1.0f);
    }

    public static void drawItemStack(ItemStack par1ItemStack, int x, int y, String par4Str, boolean gui) {
        RenderItem itemRenderer = UtilsClient.getItemRender();
        if (gui) {
            GL11.glEnable((int)32826);
            RenderHelper.func_74520_c();
        }
        itemRenderer.field_77023_b = 400.0f;
        FontRenderer font = null;
        if (par1ItemStack != null) {
            Item i = par1ItemStack.func_77973_b();
            if (i == null) {
                return;
            }
            font = i.getFontRenderer(par1ItemStack);
        }
        if (font == null) {
            font = UtilsClient.mc().field_71466_p;
        }
        itemRenderer.func_82406_b(font, UtilsClient.mc().func_110434_K(), par1ItemStack, x, y);
        itemRenderer.field_77023_b = 0.0f;
        if (gui) {
            RenderHelper.func_74518_a();
            GL11.glDisable((int)32826);
        }
        if (par1ItemStack.field_77994_a > 1) {
            UtilsClient.disableDepthTest();
            Minecraft.func_71410_x().field_71466_p.func_78261_a("" + par1ItemStack.field_77994_a, x + 10, y + 9, -1);
            UtilsClient.enableDepthTest();
        }
    }

    public static double clientDistanceTo(Entity e) {
        if (e == null) {
            return 1.0E8;
        }
        EntityClientPlayerMP c = Minecraft.func_71410_x().field_71439_g;
        double x = c.field_70165_t - e.field_70165_t;
        double y = c.field_70163_u - e.field_70163_u;
        double z = c.field_70161_v - e.field_70161_v;
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static double clientDistanceTo(TransparentNodeEntity t) {
        if (t == null) {
            return 1.0E8;
        }
        EntityClientPlayerMP c = Minecraft.func_71410_x().field_71439_g;
        double x = c.field_70165_t - (double)t.field_145851_c;
        double y = c.field_70163_u - (double)t.field_145848_d;
        double z = c.field_70161_v - (double)t.field_145849_e;
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static int getLight(World w, int x, int y, int z) {
        int b = w.func_72925_a(EnumSkyBlock.Block, x, y, z);
        int s = w.func_72925_a(EnumSkyBlock.Sky, x, y, z) - w.func_72967_a(0.0f);
        return Math.max(b, s);
    }

    public static void disableDepthTest() {
        GL11.glDisable((int)2929);
    }

    public static void enableDepthTest() {
        GL11.glEnable((int)2929);
    }

    public static void sendPacketToServer(ByteArrayOutputStream bos) {
        C17PacketCustomPayload packet = new C17PacketCustomPayload("miaouMod", bos.toByteArray());
        Eln.eventChannel.sendToServer(new FMLProxyPacket(packet));
    }

    public static int getUuid() {
        if (uuid > -1) {
            uuid = Integer.MIN_VALUE;
        }
        return uuid++;
    }

    public static int glGenListsSafe() {
        int id = GL11.glGenLists((int)1);
        glListsAllocated.add(id);
        return id;
    }

    public static void glDeleteListsSafe(int id) {
        glListsAllocated.remove(id);
        GL11.glDeleteLists((int)id, (int)1);
    }

    public static void glDeleteListsAllSafe() {
        try {
            for (Integer id : glListsAllocated) {
                GL11.glDeleteLists((int)id, (int)1);
            }
            glListsAllocated.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showItemTooltip(List src, List dst) {
        if (src.isEmpty()) {
            return;
        }
        if (UtilsClient.showItemTooltip()) {
            dst.addAll(src);
        } else {
            dst.add("\u00a7F\u00a7o<" + I18N.tr("Hold shift", new Object[0]) + ">");
        }
    }

    public static boolean showItemTooltip() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static double getWeather(World world) {
        if (world.func_72911_I()) {
            return 1.0;
        }
        if (world.func_72896_J()) {
            return 0.5;
        }
        return 0.0;
    }

    static {
        uuid = Integer.MIN_VALUE;
        whiteTexture = new ResourceLocation("eln", "sprites/cable.png");
        glListsAllocated = new HashSet();
    }
}

