/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import mods.eln.misc.UtilsClient;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public enum VoltageLevelColor {
    None(null),
    Neutral("neutral"),
    SignalVoltage("signal"),
    LowVoltage("low"),
    MediumVoltage("medium"),
    HighVoltage("high"),
    VeryHighVoltage("veryhigh"),
    Thermal("thermal");

    private String voltageLevel;

    private VoltageLevelColor(String voltageLevel) {
        this.voltageLevel = voltageLevel;
    }

    public void drawIconBackground(IItemRenderer.ItemRenderType type) {
        if (this.voltageLevel != null && type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.FIRST_PERSON_MAP) {
            UtilsClient.drawIcon(type, new ResourceLocation("eln", "textures/voltages/" + this.voltageLevel + ".png"));
        }
    }

    public static VoltageLevelColor fromVoltage(double voltage) {
        if (voltage < 0.0) {
            return None;
        }
        if (voltage <= 100.0) {
            return LowVoltage;
        }
        if (voltage <= 400.0) {
            return MediumVoltage;
        }
        if (voltage <= 1600.0) {
            return HighVoltage;
        }
        if (voltage <= 6400.0) {
            return VeryHighVoltage;
        }
        return None;
    }

    public static VoltageLevelColor fromMaxCurrent(double maxCurrent) {
        if (maxCurrent <= 0.0) {
            return None;
        }
        if (maxCurrent <= 4.6875) {
            return VeryHighVoltage;
        }
        if (maxCurrent <= 6.25) {
            return HighVoltage;
        }
        if (maxCurrent <= 10.0) {
            return MediumVoltage;
        }
        if (maxCurrent <= 20.0) {
            return LowVoltage;
        }
        return None;
    }

    public static VoltageLevelColor fromCable(ElectricalCableDescriptor descriptor) {
        if (descriptor != null) {
            if (descriptor.signalWire) {
                return SignalVoltage;
            }
            return VoltageLevelColor.fromVoltage(descriptor.electricalNominalVoltage);
        }
        return None;
    }

    public void setGLColor() {
        switch (this) {
            case None: 
            case Neutral: {
                break;
            }
            case SignalVoltage: {
                GL11.glColor3f((float)0.8f, (float)0.87f, (float)0.82f);
                break;
            }
            case LowVoltage: {
                GL11.glColor3f((float)0.55f, (float)0.84f, (float)0.68f);
                break;
            }
            case MediumVoltage: {
                GL11.glColor3f((float)0.55f, (float)0.74f, (float)0.85f);
                break;
            }
            case HighVoltage: {
                GL11.glColor3f((float)0.96f, (float)0.8f, (float)0.56f);
                break;
            }
            case VeryHighVoltage: {
                GL11.glColor3f((float)0.86f, (float)0.58f, (float)0.55f);
            }
        }
    }
}

