/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import mods.eln.misc.INBTTReady;
import mods.eln.misc.RcInterpolator;
import mods.eln.sim.IProcess;
import net.minecraft.nbt.NBTTagCompound;

public class WindProcess
implements IProcess,
INBTTReady {
    double windHit = 5.0;
    double windTarget = 5.0;
    double windVariation = 0.0;
    double windTargetNoose = 0.0;
    RcInterpolator windTargetFiltred = new RcInterpolator(60.0f);

    @Override
    public void process(double time) {
        double varF = 0.01;
        this.windHit += this.windVariation * time;
        this.windVariation += (this.getTarget() - this.windHit) * varF * time + (Math.random() * 2.0 - 1.0) * 0.1 * time;
        this.windVariation *= 1.0 - 0.01 * time;
        if (Math.random() < time / 1200.0) {
            this.newWindTarget();
        }
        if (Math.random() < time / 120.0) {
            this.windTargetNoose = (Math.random() * 2.0 - 1.0) * 1.2;
        }
        this.windTargetFiltred.setTarget((float)this.windTarget);
        this.windTargetFiltred.step((float)time);
    }

    public void newWindTarget() {
        float next = (float)(Math.pow(Math.random(), 3.0) * 20.0);
        this.windTarget += ((double)next - this.windTarget) * 0.7;
    }

    public double getTarget() {
        return this.windTargetNoose + (double)this.windTargetFiltred.get();
    }

    public double getTargetNotFiltred() {
        return this.windTargetNoose + (double)this.windTargetFiltred.getTarget();
    }

    public double getWind(int y) {
        y = Math.min(y, 100);
        return Math.max(0.0, this.windHit * (double)y / 100.0);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.windHit = nbt.func_74769_h(str + "windHit");
        this.windTarget = nbt.func_74769_h(str + "windTarget");
        this.windVariation = nbt.func_74769_h(str + "windVariation");
        this.windTargetFiltred.setValue(nbt.func_74760_g(str + "windTargetFiltred"));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        nbt.func_74780_a(str + "windHit", this.windHit);
        nbt.func_74780_a(str + "windTarget", this.windTarget);
        nbt.func_74780_a(str + "windVariation", this.windVariation);
        nbt.func_74776_a(str + "windTargetFiltred", this.windTargetFiltred.get());
    }
}

