/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node;

import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.misc.Direction;
import mods.eln.node.NodeBase;
import mods.eln.node.NodeBlockEntity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.EnumSkyBlock;

public abstract class Node
extends NodeBase {
    private int lastLight = 0;
    boolean oldSendedRedstone = false;

    public void setLightValue(int light) {
        if (light > 15) {
            light = 15;
        }
        if (light < 0) {
            light = 0;
        }
        if (this.lastLight != light) {
            this.lastLight = light;
            this.coordonate.world().func_147463_c(EnumSkyBlock.Block, this.coordonate.x, this.coordonate.y, this.coordonate.z);
            this.setNeedPublish(true);
        }
    }

    public int getLightValue() {
        return this.lastLight;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.lastLight = nbt.func_74771_c("lastLight");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("lastLight", (byte)this.lastLight);
    }

    @Override
    public void publishSerialize(DataOutputStream stream) {
        super.publishSerialize(stream);
        try {
            boolean redstone = this.canConnectRedstone();
            stream.writeByte(this.lastLight | (redstone ? 16 : 0));
            if (redstone != this.oldSendedRedstone) {
                this.needNotify = true;
            }
            this.oldSendedRedstone = redstone;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public NodeBlockEntity getEntity() {
        return (NodeBlockEntity)this.coordonate.world().func_147438_o(this.coordonate.x, this.coordonate.y, this.coordonate.z);
    }

    public int isProvidingWeakPower(Direction side) {
        return 0;
    }

    public boolean canConnectRedstone() {
        return false;
    }
}

