/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node;

import cpw.mods.fml.common.FMLCommonHandler;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import mods.eln.Eln;
import mods.eln.ghost.GhostBlock;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUCubeMask;
import mods.eln.misc.Utils;
import mods.eln.node.NodeConnection;
import mods.eln.node.NodeManager;
import mods.eln.node.six.SixNode;
import mods.eln.sim.ElectricalConnection;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalConnection;
import mods.eln.sim.ThermalLoad;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public abstract class NodeBase {
    public static final int maskElectricalPower = 1;
    public static final int maskThermal = 2;
    public static final int maskElectricalGate = 4;
    public static final int maskElectricalAll = 5;
    public static final int maskElectricalInputGate = 4;
    public static final int maskElectricalOutputGate = 4;
    public static final int maskWire = 0;
    public static final int maskElectricalWire = 8;
    public static final int maskThermalWire = 2;
    public static final int maskSignal = 512;
    public static final int maskRs485 = 1024;
    public static final int maskColorData = 983040;
    public static final int maskColorShift = 16;
    public static final int maskColorCareShift = 20;
    public static final int maskColorCareData = 0x100000;
    public static final double networkSerializeUFactor = 10.0;
    public static final double networkSerializeIFactor = 100.0;
    public static final double networkSerializeTFactor = 10.0;
    public byte neighborOpaque;
    public byte neighborWrapable;
    public static int teststatic;
    public Coordonate coordonate;
    public ArrayList<NodeConnection> nodeConnectionList = new ArrayList(4);
    private boolean initialized = false;
    private boolean isAdded = false;
    private boolean needPublish = false;
    public LRDUCubeMask lrduCubeMask = new LRDUCubeMask();
    boolean destructed = false;
    boolean needNotify = false;

    public boolean mustBeSaved() {
        return true;
    }

    public int getBlockMetadata() {
        return 0;
    }

    public void networkUnserialize(DataInputStream stream, EntityPlayerMP player) {
    }

    public void notifyNeighbor() {
        this.coordonate.world().func_147444_c(this.coordonate.x, this.coordonate.y, this.coordonate.z, this.coordonate.getBlock());
    }

    public abstract String getNodeUuid();

    public void neighborBlockRead() {
        int[] vector = new int[3];
        World world = this.coordonate.world();
        this.neighborOpaque = 0;
        this.neighborWrapable = 0;
        for (Direction direction : Direction.values()) {
            vector[0] = this.coordonate.x;
            vector[1] = this.coordonate.y;
            vector[2] = this.coordonate.z;
            direction.applyTo(vector, 1);
            Block b = world.func_147439_a(vector[0], vector[1], vector[2]);
            if (b.func_149662_c()) {
                // empty if block
            }
            this.neighborOpaque = (byte)(this.neighborOpaque | 1 << direction.getInt());
            if (!NodeBase.isBlockWrappable(b, world, this.coordonate.x, this.coordonate.y, this.coordonate.z)) continue;
            this.neighborWrapable = (byte)(this.neighborWrapable | 1 << direction.getInt());
        }
    }

    public boolean hasGui(Direction side) {
        return false;
    }

    public void onNeighborBlockChange() {
        this.neighborBlockRead();
        if (this.isAdded) {
            this.reconnect();
        }
    }

    public boolean isBlockWrappable(Direction direction) {
        return (this.neighborWrapable >> direction.getInt() & 1) != 0;
    }

    public boolean isBlockOpaque(Direction direction) {
        return (this.neighborOpaque >> direction.getInt() & 1) != 0;
    }

    public static boolean isBlockWrappable(Block block, World w, int x, int y, int z) {
        if (block.isReplaceable((IBlockAccess)w, x, y, z)) {
            return true;
        }
        if (block == Blocks.field_150350_a) {
            return true;
        }
        if (block == Eln.sixNodeBlock) {
            return true;
        }
        if (block instanceof GhostBlock) {
            return true;
        }
        if (block == Blocks.field_150478_aa) {
            return true;
        }
        if (block == Blocks.field_150429_aA) {
            return true;
        }
        if (block == Blocks.field_150437_az) {
            return true;
        }
        return block == Blocks.field_150488_af;
    }

    public NodeBase() {
        this.coordonate = new Coordonate();
    }

    public void physicalSelfDestruction(float explosionStrength) {
        if (this.destructed) {
            return;
        }
        this.destructed = true;
        if (!Eln.instance.explosionEnable) {
            explosionStrength = 0.0f;
        }
        this.disconnect();
        this.coordonate.world().func_147468_f(this.coordonate.x, this.coordonate.y, this.coordonate.z);
        NodeManager.instance.removeNode(this);
        if (explosionStrength != 0.0f) {
            this.coordonate.world().func_72876_a((Entity)null, (double)this.coordonate.x, (double)this.coordonate.y, (double)this.coordonate.z, explosionStrength, true);
        }
    }

    public void onBlockPlacedBy(Coordonate coordonate, Direction front, EntityLivingBase entityLiving, ItemStack itemStack) {
        this.coordonate = coordonate;
        this.neighborBlockRead();
        NodeManager.instance.addNode(this);
        this.initializeFromThat(front, entityLiving, itemStack);
        if (itemStack != null) {
            Utils.println("Node::constructor( meta = " + itemStack.func_77960_j() + ")");
        }
    }

    public abstract void initializeFromThat(Direction var1, EntityLivingBase var2, ItemStack var3);

    public NodeBase getNeighbor(Direction direction) {
        int[] position = new int[]{this.coordonate.x, this.coordonate.y, this.coordonate.z};
        direction.applyTo(position, 1);
        Coordonate nodeCoordonate = new Coordonate(position[0], position[1], position[2], this.coordonate.dimention);
        return NodeManager.instance.getNodeFromCoordonate(nodeCoordonate);
    }

    public void onBreakBlock() {
        this.disconnect();
        NodeManager.instance.removeNode(this);
        Utils.println("Node::onBreakBlock()");
    }

    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (!entityPlayer.field_70170_p.field_72995_K && entityPlayer.func_71045_bC() != null) {
            if (Eln.multiMeterElement.checkSameItemStack(entityPlayer.func_71045_bC())) {
                String str = this.multiMeterString(side);
                if (str != null) {
                    Utils.addChatMessage(entityPlayer, str);
                }
                return true;
            }
            if (Eln.thermoMeterElement.checkSameItemStack(entityPlayer.func_71045_bC())) {
                String str = this.thermoMeterString(side);
                if (str != null) {
                    Utils.addChatMessage(entityPlayer, str);
                }
                return true;
            }
            if (Eln.allMeterElement.checkSameItemStack(entityPlayer.func_71045_bC())) {
                String str1 = this.multiMeterString(side);
                String str2 = this.thermoMeterString(side);
                String str = "";
                if (str1 != null) {
                    str = str + str1;
                }
                if (str2 != null) {
                    str = str + str2;
                }
                if (!str.equals("")) {
                    Utils.addChatMessage(entityPlayer, str);
                }
                return true;
            }
        }
        if (this.hasGui(side)) {
            entityPlayer.openGui((Object)Eln.instance, 6935 + side.getInt(), this.coordonate.world(), this.coordonate.x, this.coordonate.y, this.coordonate.z);
            return true;
        }
        return false;
    }

    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    public static void tryConnectTwoNode(NodeBase nodeA, Direction directionA, LRDU lrduA, NodeBase nodeB, Direction directionB, LRDU lrduB) {
        if (NodeBase.compareConnectionMask(nodeA.getSideConnectionMask(directionA, lrduA), nodeB.getSideConnectionMask(directionB, lrduB))) {
            ThermalLoad otherTLoad;
            ThermalLoad tLoad;
            ElectricalLoad otherELoad;
            ElectricalConnection eCon = null;
            ThermalConnection tCon = null;
            nodeA.lrduCubeMask.set(directionA, lrduA, true);
            nodeB.lrduCubeMask.set(directionB, lrduB, true);
            nodeA.newConnectionAt(directionA, lrduA);
            nodeB.newConnectionAt(directionB, lrduB);
            ElectricalLoad eLoad = nodeA.getElectricalLoad(directionA, lrduA);
            if (eLoad != null && (otherELoad = nodeB.getElectricalLoad(directionB, lrduB)) != null) {
                eCon = new ElectricalConnection(eLoad, otherELoad);
                Eln.simulator.addElectricalComponent(eCon);
            }
            if ((tLoad = nodeA.getThermalLoad(directionA, lrduA)) != null && (otherTLoad = nodeB.getThermalLoad(directionB, lrduB)) != null) {
                tCon = new ThermalConnection(tLoad, otherTLoad);
                Eln.simulator.addThermalConnection(tCon);
            }
            NodeConnection nodeConnection = new NodeConnection(nodeA, directionA, lrduA, nodeB, directionB, lrduB, eCon, tCon);
            nodeA.nodeConnectionList.add(nodeConnection);
            nodeB.nodeConnectionList.add(nodeConnection);
            nodeA.setNeedPublish(true);
            nodeB.setNeedPublish(true);
        }
    }

    public abstract int getSideConnectionMask(Direction var1, LRDU var2);

    public abstract ThermalLoad getThermalLoad(Direction var1, LRDU var2);

    public abstract ElectricalLoad getElectricalLoad(Direction var1, LRDU var2);

    public void checkCanStay(boolean onCreate) {
    }

    public void connectJob() {
        int[] emptyBlockCoord = new int[3];
        int[] otherBlockCoord = new int[3];
        for (Direction direction : Direction.values()) {
            if (!this.isBlockWrappable(direction)) continue;
            emptyBlockCoord[0] = this.coordonate.x;
            emptyBlockCoord[1] = this.coordonate.y;
            emptyBlockCoord[2] = this.coordonate.z;
            direction.applyTo(emptyBlockCoord, 1);
            LRDU[] lRDUArray = LRDU.values();
            int n = lRDUArray.length;
            for (int i = 0; i < n; ++i) {
                LRDU lrdu = lRDUArray[i];
                Direction elementSide = direction.applyLRDU(lrdu);
                otherBlockCoord[0] = emptyBlockCoord[0];
                otherBlockCoord[1] = emptyBlockCoord[1];
                otherBlockCoord[2] = emptyBlockCoord[2];
                elementSide.applyTo(otherBlockCoord, 1);
                NodeBase otherNode = NodeManager.instance.getNodeFromCoordonate(new Coordonate(otherBlockCoord[0], otherBlockCoord[1], otherBlockCoord[2], this.coordonate.dimention));
                if (otherNode == null) continue;
                Direction otherDirection = elementSide.getInverse();
                LRDU otherLRDU = otherDirection.getLRDUGoingTo(direction).inverse();
                if (!(this instanceof SixNode) && !(otherNode instanceof SixNode)) continue;
                NodeBase.tryConnectTwoNode(this, direction, lrdu, otherNode, otherDirection, otherLRDU);
            }
        }
        for (Direction dir : Direction.values()) {
            NodeBase otherNode = this.getNeighbor(dir);
            if (otherNode == null || !otherNode.isAdded) continue;
            for (LRDU lrdu : LRDU.values()) {
                NodeBase.tryConnectTwoNode(this, dir, lrdu, otherNode, dir.getInverse(), lrdu.inverseIfLR());
            }
        }
    }

    public void disconnectJob() {
        for (NodeConnection c : this.nodeConnectionList) {
            if (c.N1 != this) {
                c.N1.nodeConnectionList.remove(c);
                c.N1.setNeedPublish(true);
                c.N1.lrduCubeMask.set(c.dir1, c.lrdu1, false);
            } else {
                c.N2.nodeConnectionList.remove(c);
                c.N2.setNeedPublish(true);
                c.N2.lrduCubeMask.set(c.dir2, c.lrdu2, false);
            }
            c.destroy();
        }
        this.lrduCubeMask.clear();
        this.nodeConnectionList.clear();
    }

    public static boolean compareConnectionMask(int mask1, int mask2) {
        if ((mask1 & 0xFFFF & (mask2 & 0xFFFF)) == 0) {
            return false;
        }
        if ((mask1 & 0x100000 & (mask2 & 0x100000)) == 0) {
            return true;
        }
        return (mask1 & 0xF0000) == (mask2 & 0xF0000);
    }

    public void externalDisconnect(Direction side, LRDU lrdu) {
    }

    public void newConnectionAt(Direction side, LRDU lrdu) {
    }

    public void connectInit() {
        this.lrduCubeMask.clear();
        this.nodeConnectionList.clear();
    }

    public void connect() {
        if (this.isAdded) {
            this.disconnect();
        }
        this.connectInit();
        this.connectJob();
        this.isAdded = true;
        this.setNeedPublish(true);
    }

    public void disconnect() {
        if (!this.isAdded) {
            Utils.println("Node destroy error already destroy");
            return;
        }
        this.disconnectJob();
        this.isAdded = false;
    }

    public boolean nodeAutoSave() {
        return true;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.coordonate.readFromNBT(nbt, "c");
        this.neighborOpaque = nbt.func_74771_c("NBOpaque");
        this.neighborWrapable = nbt.func_74771_c("NBWrap");
        this.initialized = true;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.coordonate.writeToNBT(nbt, "c");
        nbt.func_74774_a("NBOpaque", this.neighborOpaque);
        nbt.func_74774_a("NBWrap", this.neighborWrapable);
    }

    public String multiMeterString(Direction side) {
        return "";
    }

    public String thermoMeterString(Direction side) {
        return "";
    }

    public void setNeedPublish(boolean needPublish) {
        this.needPublish = needPublish;
    }

    public boolean getNeedPublish() {
        return this.needPublish;
    }

    private boolean isINodeProcess(IProcess process) {
        for (Class<?> c : process.getClass().getInterfaces()) {
            if (c != INBTTReady.class) continue;
            return true;
        }
        return false;
    }

    public void publishSerialize(DataOutputStream stream) {
    }

    public void preparePacketForClient(DataOutputStream stream) {
        try {
            stream.writeByte(18);
            stream.writeInt(this.coordonate.x);
            stream.writeInt(this.coordonate.y);
            stream.writeInt(this.coordonate.z);
            stream.writeByte(this.coordonate.dimention);
            stream.writeUTF(this.getNodeUuid());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sendPacketToClient(ByteArrayOutputStream bos, EntityPlayerMP player) {
        Utils.sendPacketToClient(bos, player);
    }

    public void sendPacketToAllClient(ByteArrayOutputStream bos) {
        this.sendPacketToAllClient(bos, 100000.0);
    }

    public void sendPacketToAllClient(ByteArrayOutputStream bos, double range) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        for (Object obj : server.func_71203_ab().field_72404_b) {
            EntityPlayerMP player = (EntityPlayerMP)obj;
            WorldServer worldServer = MinecraftServer.func_71276_C().func_71218_a(player.field_71093_bK);
            PlayerManager playerManager = worldServer.func_73040_p();
            if (player.field_71093_bK != this.coordonate.dimention || !playerManager.func_72694_a(player, this.coordonate.x / 16, this.coordonate.z / 16) || this.coordonate.distanceTo((Entity)player) > range) continue;
            Utils.sendPacketToClient(bos, player);
        }
    }

    public ByteArrayOutputStream getPublishPacket() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
        DataOutputStream stream = new DataOutputStream(bos);
        try {
            stream.writeByte(15);
            stream.writeInt(this.coordonate.x);
            stream.writeInt(this.coordonate.y);
            stream.writeInt(this.coordonate.z);
            stream.writeByte(this.coordonate.dimention);
            stream.writeUTF(this.getNodeUuid());
            this.publishSerialize(stream);
            return bos;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void publishToAllPlayer() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        for (Object obj : server.func_71203_ab().field_72404_b) {
            EntityPlayerMP player = (EntityPlayerMP)obj;
            WorldServer worldServer = MinecraftServer.func_71276_C().func_71218_a(player.field_71093_bK);
            PlayerManager playerManager = worldServer.func_73040_p();
            if (player.field_71093_bK != this.coordonate.dimention || !playerManager.func_72694_a(player, this.coordonate.x / 16, this.coordonate.z / 16)) continue;
            Utils.sendPacketToClient(this.getPublishPacket(), player);
        }
        if (this.needNotify) {
            this.needNotify = false;
            this.notifyNeighbor();
        }
        this.needPublish = false;
    }

    public void publishToPlayer(EntityPlayerMP player) {
        Utils.sendPacketToClient(this.getPublishPacket(), player);
    }

    public void dropItem(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        if (this.coordonate.world().func_82736_K().func_82766_b("doTileDrops")) {
            float var6 = 0.7f;
            double var7 = (double)(this.coordonate.world().field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
            double var9 = (double)(this.coordonate.world().field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
            double var11 = (double)(this.coordonate.world().field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
            EntityItem var13 = new EntityItem(this.coordonate.world(), (double)this.coordonate.x + var7, (double)this.coordonate.y + var9, (double)this.coordonate.z + var11, itemStack);
            var13.field_145804_b = 10;
            this.coordonate.world().func_72838_d((Entity)var13);
        }
    }

    public void dropInventory(IInventory inventory) {
        if (inventory == null) {
            return;
        }
        for (int idx = 0; idx < inventory.func_70302_i_(); ++idx) {
            this.dropItem(inventory.func_70301_a(idx));
        }
    }

    public abstract void initializeFromNBT();

    public void globalBoot() {
    }

    public void needPublish() {
        this.setNeedPublish(true);
    }

    public void unload() {
        this.disconnect();
    }
}

