/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import mods.eln.misc.Direction;
import mods.eln.misc.Utils;
import mods.eln.node.NodeBlockEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class NodeBlock
extends Block {
    public int blockItemNbr;
    Class tileEntityClass;

    public NodeBlock(Material material, Class tileEntityClass, int blockItemNbr) {
        super(material);
        this.func_149663_c("NodeBlock");
        this.tileEntityClass = tileEntityClass;
        this.field_149783_u = true;
        this.blockItemNbr = blockItemNbr;
        this.func_149711_c(1.0f);
        this.func_149752_b(1.0f);
    }

    public float func_149712_f(World par1World, int par2, int par3, int par4) {
        return 1.0f;
    }

    public int func_149709_b(IBlockAccess block, int x, int y, int z, int side) {
        NodeBlockEntity entity = (NodeBlockEntity)block.func_147438_o(x, y, z);
        return entity.isProvidingWeakPower(Direction.fromIntMinecraftSide(side));
    }

    public boolean canConnectRedstone(IBlockAccess block, int x, int y, int z, int side) {
        NodeBlockEntity entity = (NodeBlockEntity)block.func_147438_o(x, y, z);
        return entity.canConnectRedstone(Direction.XN);
    }

    public boolean func_149744_f() {
        return super.func_149744_f();
    }

    public boolean func_149662_c() {
        return true;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity == null || !(entity instanceof NodeBlockEntity)) {
            return 0;
        }
        NodeBlockEntity tileEntity = (NodeBlockEntity)entity;
        return tileEntity.getLightValue();
    }

    public boolean onBlockPlacedBy(World world, int x, int y, int z, Direction front, EntityLivingBase entityLiving, int metadata) {
        NodeBlockEntity tileEntity = (NodeBlockEntity)world.func_147438_o(x, y, z);
        tileEntity.onBlockPlacedBy(front, entityLiving, metadata);
        return true;
    }

    public void func_149726_b(World par1World, int x, int y, int z) {
        if (!par1World.field_72995_K) {
            NodeBlockEntity entity = (NodeBlockEntity)par1World.func_147438_o(x, y, z);
            entity.onBlockAdded();
        }
    }

    public void func_149749_a(World par1World, int x, int y, int z, Block par5, int par6) {
        NodeBlockEntity entity = (NodeBlockEntity)par1World.func_147438_o(x, y, z);
        entity.onBreakBlock();
        super.func_149749_a(par1World, x, y, z, par5, par6);
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        if (!Utils.isRemote((IBlockAccess)world)) {
            NodeBlockEntity entity = (NodeBlockEntity)world.func_147438_o(x, y, z);
            entity.onNeighborBlockChange();
        }
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public void getSubBlocks(int par1, CreativeTabs tab, List subItems) {
        for (int ix = 0; ix < this.blockItemNbr; ++ix) {
            subItems.add(new ItemStack((Block)this, 1, ix));
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float vx, float vy, float vz) {
        NodeBlockEntity entity = (NodeBlockEntity)world.func_147438_o(x, y, z);
        return entity.onBlockActivated(entityPlayer, Direction.fromIntMinecraftSide(side), vx, vy, vz);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World var1, int meta) {
        try {
            return (TileEntity)this.tileEntityClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        while (true) {
            // Infinite loop
        }
    }
}

