/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.node.INodeEntity;
import mods.eln.node.ITileEntitySpawnClient;
import mods.eln.node.Node;
import mods.eln.node.NodeBlock;
import mods.eln.node.NodeManager;
import mods.eln.server.DelayedBlockRemove;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.EnumSkyBlock;

public abstract class NodeBlockEntity
extends TileEntity
implements ITileEntitySpawnClient,
INodeEntity {
    public static final LinkedList<NodeBlockEntity> clientList = new LinkedList();
    boolean redstone = false;
    int lastLight = 255;
    boolean firstUnserialize = true;
    Node node = null;
    boolean updateEntityFirst = true;

    public NodeBlock getBlock() {
        return (NodeBlock)this.func_145838_q();
    }

    @Override
    public void serverPublishUnserialize(DataInputStream stream) {
        int light = 0;
        try {
            boolean newRedstone;
            if (this.firstUnserialize) {
                this.firstUnserialize = false;
                Utils.notifyNeighbor(this);
            }
            Byte b = stream.readByte();
            light = b & 0xF;
            boolean bl = newRedstone = (b & 0x10) != 0;
            if (this.redstone != newRedstone) {
                this.redstone = newRedstone;
                this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            } else {
                this.redstone = newRedstone;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.lastLight != light) {
            this.lastLight = light;
            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void serverPacketUnserialize(DataInputStream stream) {
    }

    public abstract int isProvidingWeakPower(Direction var1);

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return null;
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.cameraDrawOptimisation()) {
            return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
        }
        return INFINITE_EXTENT_AABB;
    }

    public boolean cameraDrawOptimisation() {
        return true;
    }

    public int getLightValue() {
        if (this.field_145850_b.field_72995_K) {
            if (this.lastLight == 255) {
                return 0;
            }
            return this.lastLight;
        }
        Node node = this.getNode();
        if (node == null) {
            return 0;
        }
        return this.getNode().getLightValue();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    void onBlockPlacedBy(Direction front, EntityLivingBase entityLiving, int metadata) {
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (this.updateEntityFirst) {
            this.updateEntityFirst = false;
            if (this.field_145850_b.field_72995_K) {
                clientList.add(this);
            }
        }
    }

    public void onBlockAdded() {
        if (!this.field_145850_b.field_72995_K && this.getNode() == null) {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void onBreakBlock() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.getNode() == null) {
                return;
            }
            this.getNode().onBreakBlock();
        }
    }

    public void onChunkUnload() {
        if (this.field_145850_b.field_72995_K) {
            this.destructor();
        }
    }

    public void destructor() {
        clientList.remove(this);
    }

    public void func_145843_s() {
        if (this.field_145850_b.field_72995_K) {
            this.destructor();
        }
        super.func_145843_s();
    }

    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (!this.field_145850_b.field_72995_K) {
            if (this.getNode() == null) {
                return false;
            }
            this.getNode().onBlockActivated(entityPlayer, side, vx, vy, vz);
            return true;
        }
        return true;
    }

    public void onNeighborBlockChange() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.getNode() == null) {
                return;
            }
            this.getNode().onNeighborBlockChange();
        }
    }

    public Node getNode() {
        if (this.field_145850_b.field_72995_K) {
            Utils.fatal();
            return null;
        }
        if (this.field_145850_b == null) {
            return null;
        }
        if (this.node == null) {
            this.node = (Node)NodeManager.instance.getNodeFromCoordonate(new Coordonate(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b));
            if (this.node == null) {
                DelayedBlockRemove.add(new Coordonate(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b));
            }
        }
        return this.node;
    }

    public static NodeBlockEntity getEntity(int x, int y, int z) {
        TileEntity entity = Minecraft.func_71410_x().field_71441_e.func_147438_o(x, y, z);
        if (entity != null && entity instanceof NodeBlockEntity) {
            return (NodeBlockEntity)entity;
        }
        return null;
    }

    public Packet func_145844_m() {
        Node node = this.getNode();
        if (node == null) {
            Utils.println("ASSERT NULL NODE public Packet getDescriptionPacket() nodeblock entity");
            return null;
        }
        return new S3FPacketCustomPayload("miaouMod", node.getPublishPacket().toByteArray());
    }

    public void preparePacketForServer(DataOutputStream stream) {
        try {
            stream.writeByte(16);
            stream.writeInt(this.field_145851_c);
            stream.writeInt(this.field_145848_d);
            stream.writeInt(this.field_145849_e);
            stream.writeByte(this.field_145850_b.field_73011_w.field_76574_g);
            stream.writeUTF(this.getNodeUuid());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sendPacketToServer(ByteArrayOutputStream bos) {
        UtilsClient.sendPacketToServer(bos);
    }

    public CableRenderDescriptor getCableRender(Direction side, LRDU lrdu) {
        return null;
    }

    public int getCableDry(Direction side, LRDU lrdu) {
        return 0;
    }

    public boolean canConnectRedstone(Direction xn) {
        if (this.field_145850_b.field_72995_K) {
            return this.redstone;
        }
        if (this.getNode() == null) {
            return false;
        }
        return this.getNode().canConnectRedstone();
    }

    public void clientRefresh(float deltaT) {
    }
}

