/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Utils;
import mods.eln.node.NodeBase;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeElement;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldSavedData;

public class NodeManager
extends WorldSavedData {
    public static NodeManager instance = null;
    private HashMap<Coordonate, NodeBase> nodesMap;
    private ArrayList<NodeBase> nodes;
    public static final HashMap<String, Class> UUIDToClass = new HashMap();
    Random rand = new Random();

    public HashMap<Coordonate, NodeBase> getNodeArray() {
        return this.nodesMap;
    }

    public ArrayList<NodeBase> getNodes() {
        return this.nodes;
    }

    public static void registerUuid(String uuid, Class classType) {
        UUIDToClass.put(uuid, classType);
    }

    Collection<NodeBase> getNodeList() {
        return this.nodesMap.values();
    }

    public NodeManager(String par1Str) {
        super(par1Str);
        this.nodesMap = new HashMap();
        this.nodes = new ArrayList();
        instance = this;
    }

    public void addNode(NodeBase node) {
        if (node.coordonate == null) {
            Utils.println("Null coordonate addnode");
            while (true) {
                // Infinite loop
            }
        }
        NodeBase old = this.nodesMap.put(node.coordonate, node);
        if (old != null) {
            this.nodes.remove(old);
        }
        this.nodes.add(node);
        Utils.println("NodeManager has " + this.nodesMap.size() + "node");
    }

    public void removeNode(NodeBase node) {
        if (node == null) {
            return;
        }
        this.nodesMap.remove(node.coordonate);
        this.nodes.remove(node);
        Utils.println("NodeManager has " + this.nodesMap.size() + "node");
    }

    public void removeCoordonate(Coordonate c) {
        NodeBase n = this.nodesMap.remove(c);
        if (n != null) {
            this.nodes.remove(n);
        }
        Utils.println("NodeManager has " + this.nodesMap.size() + "node");
    }

    public boolean func_76188_b() {
        return true;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int i = 0;
        ++i;
    }

    public void func_76187_b(NBTTagCompound nbt) {
    }

    public NodeBase getNodeFromCoordonate(Coordonate nodeCoordonate) {
        int idx = 0;
        ++idx;
        return this.nodesMap.get(nodeCoordonate);
    }

    public TransparentNodeElement getTransparentNodeFromCoordinate(Coordonate coord) {
        NodeBase base = this.getNodeFromCoordonate(coord);
        if (base instanceof TransparentNode) {
            TransparentNode n = (TransparentNode)base;
            return n.element;
        }
        return null;
    }

    public NodeBase getRandomNode() {
        if (this.nodes.isEmpty()) {
            return null;
        }
        return this.nodes.get(this.rand.nextInt(this.nodes.size()));
    }

    public void loadFromNbt(NBTTagCompound nbt) {
        ArrayList<NodeBase> addedNode = new ArrayList<NodeBase>();
        Iterator<Object> iterator2 = Utils.getTags(nbt).iterator();
        while (iterator2.hasNext()) {
            NBTTagCompound o;
            NBTTagCompound tag = o = iterator2.next();
            Class nodeClass = UUIDToClass.get(tag.func_74779_i("tag"));
            try {
                NodeBase node = (NodeBase)nodeClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                node.readFromNBT(tag);
                this.addNode(node);
                addedNode.add(node);
                node.initializeFromNBT();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (NodeBase n : addedNode) {
            n.globalBoot();
        }
    }

    public void saveToNbt(NBTTagCompound nbt, int dim) {
        int nodeCounter = 0;
        ArrayList<NodeBase> nodesCopy = new ArrayList<NodeBase>();
        nodesCopy.addAll(this.nodes);
        for (NodeBase node : nodesCopy) {
            try {
                if (!node.mustBeSaved() || dim != Integer.MIN_VALUE && node.coordonate.dimention != dim) continue;
                NBTTagCompound nbtNode = new NBTTagCompound();
                nbtNode.func_74778_a("tag", node.getNodeUuid());
                node.writeToNBT(nbtNode);
                nbt.func_74782_a("n" + nodeCounter++, (NBTBase)nbtNode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void clear() {
        this.nodes.clear();
        this.nodesMap.clear();
    }

    public void unload(int dimensionId) {
        Iterator<NodeBase> i = this.nodes.iterator();
        while (i.hasNext()) {
            NodeBase n = i.next();
            if (n.coordonate.dimention != dimensionId) continue;
            n.unload();
            i.remove();
            this.nodesMap.remove(n.coordonate);
        }
    }
}

