/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.simple;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import mods.eln.Eln;
import mods.eln.misc.DescriptorManager;
import mods.eln.misc.Direction;
import mods.eln.misc.INBTTReady;
import mods.eln.node.NodeBase;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalConnection;
import mods.eln.sim.mna.component.Component;
import mods.eln.sim.mna.state.State;
import mods.eln.sim.nbt.NbtThermalLoad;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class SimpleNode
extends NodeBase {
    public EntityPlayerMP removedByPlayer;
    String descriptorKey = "";
    private Direction front;
    public ArrayList<IProcess> slowProcessList = new ArrayList(4);
    public ArrayList<IProcess> electricalProcessList = new ArrayList(4);
    public ArrayList<Component> electricalComponentList = new ArrayList(4);
    public ArrayList<State> electricalLoadList = new ArrayList(4);
    public ArrayList<IProcess> thermalFastProcessList = new ArrayList(4);
    public ArrayList<IProcess> thermalSlowProcessList = new ArrayList(4);
    public ArrayList<ThermalConnection> thermalConnectionList = new ArrayList(4);
    public ArrayList<NbtThermalLoad> thermalLoadList = new ArrayList(4);

    protected void setDescriptorKey(String key) {
        this.descriptorKey = key;
    }

    protected Object getDescriptor() {
        return DescriptorManager.get(this.descriptorKey);
    }

    public Direction getFront() {
        return this.front;
    }

    public void setFront(Direction front) {
        this.front = front;
        if (this.applayFrontToMetadata()) {
            this.coordonate.setMetadata(front.getInt());
        }
    }

    protected boolean applayFrontToMetadata() {
        return false;
    }

    @Override
    public void initializeFromThat(Direction front, EntityLivingBase entityLiving, ItemStack itemStack) {
        this.setFront(front);
        this.initialize();
    }

    @Override
    public void initializeFromNBT() {
        this.initialize();
    }

    public abstract void initialize();

    @Override
    public void publishSerialize(DataOutputStream stream) {
        super.publishSerialize(stream);
        try {
            stream.writeByte(this.front.getInt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void connectJob() {
        super.connectJob();
        Eln.simulator.addAllSlowProcess(this.slowProcessList);
        Eln.simulator.addAllElectricalComponent(this.electricalComponentList);
        for (State state : this.electricalLoadList) {
            Eln.simulator.addElectricalLoad(state);
        }
        Eln.simulator.addAllElectricalProcess(this.electricalProcessList);
        Eln.simulator.addAllThermalConnection(this.thermalConnectionList);
        for (NbtThermalLoad nbtThermalLoad : this.thermalLoadList) {
            Eln.simulator.addThermalLoad(nbtThermalLoad);
        }
        Eln.simulator.addAllThermalFastProcess(this.thermalFastProcessList);
        Eln.simulator.addAllThermalSlowProcess(this.thermalSlowProcessList);
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        Eln.simulator.removeAllSlowProcess(this.slowProcessList);
        Eln.simulator.removeAllElectricalComponent(this.electricalComponentList);
        for (State state : this.electricalLoadList) {
            Eln.simulator.removeElectricalLoad(state);
        }
        Eln.simulator.removeAllElectricalProcess(this.electricalProcessList);
        Eln.simulator.removeAllThermalConnection(this.thermalConnectionList);
        for (NbtThermalLoad nbtThermalLoad : this.thermalLoadList) {
            Eln.simulator.removeThermalLoad(nbtThermalLoad);
        }
        Eln.simulator.removeAllThermalFastProcess(this.thermalFastProcessList);
        Eln.simulator.removeAllThermalSlowProcess(this.thermalSlowProcessList);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.front = Direction.readFromNBT(nbt, "SNfront");
        this.setDescriptorKey(nbt.func_74779_i("SNdescriptorKey"));
        for (State electricalLoad : this.electricalLoadList) {
            if (!(electricalLoad instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)electricalLoad)).readFromNBT(nbt, "");
        }
        for (NbtThermalLoad thermalLoad : this.thermalLoadList) {
            thermalLoad.readFromNBT(nbt, "");
        }
        for (Component c : this.electricalComponentList) {
            if (!(c instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)c)).readFromNBT(nbt, "");
        }
        for (IProcess process : this.slowProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).readFromNBT(nbt, "");
        }
        for (IProcess process : this.electricalProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).readFromNBT(nbt, "");
        }
        for (IProcess process : this.thermalFastProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).readFromNBT(nbt, "");
        }
        for (IProcess process : this.thermalSlowProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).readFromNBT(nbt, "");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.front.writeToNBT(nbt, "SNfront");
        nbt.func_74778_a("SNdescriptorKey", this.descriptorKey == null ? "" : this.descriptorKey);
        for (State electricalLoad : this.electricalLoadList) {
            if (!(electricalLoad instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)electricalLoad)).writeToNBT(nbt, "");
        }
        for (NbtThermalLoad thermalLoad : this.thermalLoadList) {
            thermalLoad.writeToNBT(nbt, "");
        }
        for (Component c : this.electricalComponentList) {
            if (!(c instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)c)).writeToNBT(nbt, "");
        }
        for (IProcess process : this.slowProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).writeToNBT(nbt, "");
        }
        for (IProcess process : this.electricalProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).writeToNBT(nbt, "");
        }
        for (IProcess process : this.thermalFastProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).writeToNBT(nbt, "");
        }
        for (IProcess process : this.thermalSlowProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).writeToNBT(nbt, "");
        }
    }
}

