/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.simple;

import mods.eln.misc.DescriptorBase;
import mods.eln.misc.Direction;
import mods.eln.misc.Utils;
import mods.eln.node.simple.SimpleNode;
import mods.eln.node.simple.SimpleNodeEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class SimpleNodeBlock
extends BlockContainer {
    String descriptorKey;

    protected SimpleNodeBlock(Material material) {
        super(material);
    }

    public SimpleNodeBlock setDescriptorKey(String descriptorKey) {
        this.descriptorKey = descriptorKey;
        return this;
    }

    public SimpleNodeBlock setDescriptor(DescriptorBase descriptor) {
        this.descriptorKey = descriptor.descriptorKey;
        return this;
    }

    Direction getFrontForPlacement(EntityLivingBase e) {
        return Utils.entityLivingViewDirection(e).getInverse();
    }

    protected abstract SimpleNode newNode();

    SimpleNode getNode(World world, int x, int y, int z) {
        SimpleNodeEntity entity = (SimpleNodeEntity)world.func_147438_o(x, y, z);
        if (entity != null) {
            return entity.getNode();
        }
        return null;
    }

    public SimpleNodeEntity getEntity(World world, int x, int y, int z) {
        SimpleNodeEntity entity = (SimpleNodeEntity)world.func_147438_o(x, y, z);
        return entity;
    }

    public boolean removedByPlayer(World world, EntityPlayer entityPlayer, int x, int y, int z) {
        SimpleNode node;
        if (!world.field_72995_K && (node = this.getNode(world, x, y, z)) != null) {
            node.removedByPlayer = (EntityPlayerMP)entityPlayer;
        }
        return super.removedByPlayer(world, entityPlayer, x, y, z);
    }

    public void func_149726_b(World par1World, int x, int y, int z) {
        if (!par1World.field_72995_K) {
            SimpleNodeEntity entity = (SimpleNodeEntity)par1World.func_147438_o(x, y, z);
            entity.onBlockAdded();
        }
    }

    public void func_149749_a(World par1World, int x, int y, int z, Block par5, int par6) {
        SimpleNodeEntity entity = (SimpleNodeEntity)par1World.func_147438_o(x, y, z);
        entity.onBreakBlock();
        super.func_149749_a(par1World, x, y, z, par5, par6);
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        if (!Utils.isRemote((IBlockAccess)world)) {
            SimpleNodeEntity entity = (SimpleNodeEntity)world.func_147438_o(x, y, z);
            entity.onNeighborBlockChange();
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float vx, float vy, float vz) {
        SimpleNodeEntity entity = (SimpleNodeEntity)world.func_147438_o(x, y, z);
        return entity.onBlockActivated(entityPlayer, Direction.fromIntMinecraftSide(side), vx, vy, vz);
    }
}

