/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.six;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUCubeMask;
import mods.eln.misc.Utils;
import mods.eln.node.ISixNodeCache;
import mods.eln.node.Node;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.sim.ElectricalConnection;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalConnection;
import mods.eln.sim.ThermalLoad;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.chunk.Chunk;

public class SixNode
extends Node {
    public static final ArrayList<ISixNodeCache> sixNodeCacheList = new ArrayList();
    public SixNodeElement[] sideElementList = new SixNodeElement[6];
    public int[] sideElementIdList = new int[6];
    public ArrayList<ElectricalConnection> internalElectricalConnectionList = new ArrayList(1);
    public ArrayList<ThermalConnection> internalThermalConnectionList = new ArrayList(1);
    public Block sixNodeCacheBlock = Blocks.field_150350_a;
    public byte sixNodeCacheBlockMeta = 0;
    public LRDUCubeMask lrduElementMask = new LRDUCubeMask();

    public SixNodeElement getElement(Direction side) {
        return this.sideElementList[side.getInt()];
    }

    @Override
    public boolean canConnectRedstone() {
        for (SixNodeElement element : this.sideElementList) {
            if (element == null || !element.canConnectRedstone()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int isProvidingWeakPower(Direction side) {
        int value = 0;
        for (SixNodeElement element : this.sideElementList) {
            int eValue;
            if (element == null || (eValue = element.isProvidingWeakPower()) <= value) continue;
            value = eValue;
        }
        return value;
    }

    public SixNode() {
        for (int idx = 0; idx < 6; ++idx) {
            this.sideElementList[idx] = null;
            this.sideElementIdList[idx] = 0;
        }
        this.lrduElementMask.clear();
    }

    public boolean createSubBlock(ItemStack itemStack, Direction direction, EntityPlayer player) {
        SixNodeDescriptor descriptor = (SixNodeDescriptor)Eln.sixNodeItem.getDescriptor(itemStack);
        if (this.sideElementList[direction.getInt()] != null) {
            return false;
        }
        try {
            this.sideElementIdList[direction.getInt()] = itemStack.func_77960_j();
            this.sideElementList[direction.getInt()] = (SixNodeElement)descriptor.ElementClass.getConstructor(SixNode.class, Direction.class, SixNodeDescriptor.class).newInstance(new Object[]{this, direction, descriptor});
            this.sideElementIdList[direction.getInt()] = 0;
            this.disconnect();
            this.sideElementList[direction.getInt()].front = descriptor.getFrontFromPlace(direction, player);
            this.sideElementList[direction.getInt()].initialize();
            this.sideElementIdList[direction.getInt()] = itemStack.func_77960_j();
            this.connect();
            Utils.println("createSubBlock " + this.sideElementIdList[direction.getInt()] + " " + (Object)((Object)direction));
            this.setNeedPublish(true);
            return true;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean playerAskToBreakSubBlock(EntityPlayerMP entityPlayer, Direction direction) {
        if (this.sideElementList[direction.getInt()] == null) {
            return this.deleteSubBlock(entityPlayer, direction);
        }
        if (this.sideElementList[direction.getInt()].playerAskToBreak()) {
            return this.deleteSubBlock(entityPlayer, direction);
        }
        return false;
    }

    public boolean deleteSubBlock(EntityPlayerMP entityPlayer, Direction direction) {
        if (this.sideElementList[direction.getInt()] == null) {
            return false;
        }
        Utils.println("deleteSubBlock  " + (Object)((Object)direction));
        this.disconnect();
        SixNodeElement e = this.sideElementList[direction.getInt()];
        this.sideElementList[direction.getInt()] = null;
        this.sideElementIdList[direction.getInt()] = 0;
        e.destroy(entityPlayer);
        this.connect();
        this.recalculateLightValue();
        this.setNeedPublish(true);
        return true;
    }

    public boolean getIfSideRemain() {
        for (SixNodeElement sideElement : this.sideElementList) {
            if (sideElement == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt.func_74775_l("node"));
        this.sixNodeCacheBlock = Block.func_149729_e((int)nbt.func_74762_e("cacheBlockId"));
        this.sixNodeCacheBlockMeta = nbt.func_74771_c("cacheBlockMeta");
        for (int idx = 0; idx < 6; ++idx) {
            short sideElementId = nbt.func_74765_d("EID" + idx);
            if (sideElementId == 0) {
                this.sideElementList[idx] = null;
                this.sideElementIdList[idx] = 0;
                continue;
            }
            try {
                SixNodeDescriptor descriptor = (SixNodeDescriptor)Eln.sixNodeItem.getDescriptor(sideElementId);
                this.sideElementIdList[idx] = sideElementId;
                this.sideElementList[idx] = (SixNodeElement)descriptor.ElementClass.getConstructor(SixNode.class, Direction.class, SixNodeDescriptor.class).newInstance(new Object[]{this, Direction.fromInt(idx), descriptor});
                this.sideElementList[idx].readFromNBT(nbt.func_74775_l("ED" + idx));
                this.sideElementList[idx].initialize();
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                continue;
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        this.initializeFromNBT();
    }

    @Override
    public boolean nodeAutoSave() {
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        int idx = 0;
        nbt.func_74768_a("cacheBlockId", Block.func_149682_b((Block)this.sixNodeCacheBlock));
        nbt.func_74774_a("cacheBlockMeta", this.sixNodeCacheBlockMeta);
        for (SixNodeElement sideElement : this.sideElementList) {
            if (sideElement == null) {
                nbt.func_74777_a("EID" + idx, (short)0);
            } else {
                nbt.func_74777_a("EID" + idx, (short)this.sideElementIdList[idx]);
                sideElement.writeToNBT(Utils.newNbtTagCompund(nbt, "ED" + idx));
            }
            ++idx;
        }
        NBTTagCompound nodeNbt = new NBTTagCompound();
        super.writeToNBT(nodeNbt);
        nbt.func_74782_a("node", (NBTBase)nodeNbt);
    }

    public boolean getSideEnable(Direction direction) {
        return this.sideElementList[direction.getInt()] != null;
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        Direction elementSide = side.applyLRDU(lrdu);
        SixNodeElement element = this.sideElementList[elementSide.getInt()];
        if (element == null) {
            return null;
        }
        return element.getElectricalLoad(elementSide.getLRDUGoingTo(side));
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrdu) {
        Direction elementSide = side.applyLRDU(lrdu);
        SixNodeElement element = this.sideElementList[elementSide.getInt()];
        if (element == null) {
            return null;
        }
        return element.getThermalLoad(elementSide.getLRDUGoingTo(side));
    }

    @Override
    public int getSideConnectionMask(Direction side, LRDU lrdu) {
        Direction elementSide = side.applyLRDU(lrdu);
        SixNodeElement element = this.sideElementList[elementSide.getInt()];
        if (element == null) {
            return 0;
        }
        return element.getConnectionMask(elementSide.getLRDUGoingTo(side));
    }

    @Override
    public String multiMeterString(Direction side) {
        SixNodeElement element = this.sideElementList[side.getInt()];
        if (element == null) {
            return "";
        }
        return element.multiMeterString();
    }

    @Override
    public String thermoMeterString(Direction side) {
        SixNodeElement element = this.sideElementList[side.getInt()];
        if (element == null) {
            return "";
        }
        return element.thermoMeterString();
    }

    @Override
    public void publishSerialize(DataOutputStream stream) {
        super.publishSerialize(stream);
        try {
            int idx = 0;
            stream.writeInt(Block.func_149682_b((Block)this.sixNodeCacheBlock));
            stream.writeByte(this.sixNodeCacheBlockMeta);
            for (SixNodeElement sideElement : this.sideElementList) {
                if (sideElement == null) {
                    stream.writeShort(0);
                } else {
                    stream.writeShort((short)this.sideElementIdList[idx]);
                    sideElement.networkSerialize(stream);
                }
                ++idx;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void preparePacketForClient(DataOutputStream stream, SixNodeElement e) {
        try {
            super.preparePacketForClient(stream);
            int side = e.side.getInt();
            stream.writeByte(side);
            stream.writeShort(e.sixNodeElementDescriptor.parentItemDamage);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void initializeFromThat(Direction front, EntityLivingBase entityLiving, ItemStack itemStack) {
        this.neighborBlockRead();
    }

    @Override
    public void initializeFromNBT() {
        this.connect();
    }

    @Override
    public void connectInit() {
        super.connectInit();
        this.internalElectricalConnectionList.clear();
        this.internalThermalConnectionList.clear();
        this.lrduElementMask.clear();
    }

    @Override
    public void connectJob() {
        LRDU otherLRDU;
        SixNodeElement otherElement;
        Direction otherSide;
        super.connectJob();
        for (SixNodeElement element2 : this.sideElementList) {
            if (element2 == null) continue;
            element2.connectJob();
        }
        Direction side = Direction.YN;
        SixNodeElement element = this.sideElementList[side.getInt()];
        if (element != null) {
            LRDU[] lRDUArray = LRDU.values();
            int element2 = lRDUArray.length;
            for (int i = 0; i < element2; ++i) {
                LRDU lrdu = lRDUArray[i];
                otherSide = side.applyLRDU(lrdu);
                otherElement = this.sideElementList[otherSide.getInt()];
                if (otherElement == null) continue;
                otherLRDU = otherSide.getLRDUGoingTo(side);
                this.tryConnectTwoInternalElement(side, element, lrdu, otherSide, otherElement, otherLRDU);
            }
        }
        if ((element = this.sideElementList[(side = Direction.YP).getInt()]) != null) {
            for (LRDU lrdu : LRDU.values()) {
                otherSide = side.applyLRDU(lrdu);
                otherElement = this.sideElementList[otherSide.getInt()];
                if (otherElement == null) continue;
                otherLRDU = otherSide.getLRDUGoingTo(side);
                this.tryConnectTwoInternalElement(side, element, lrdu, otherSide, otherElement, otherLRDU);
            }
        }
        side = Direction.XN;
        for (int idx = 0; idx < 4; ++idx) {
            Direction otherSide2 = side.right();
            SixNodeElement element3 = this.sideElementList[side.getInt()];
            SixNodeElement otherElement2 = this.sideElementList[otherSide2.getInt()];
            if (element3 != null && otherElement2 != null) {
                this.tryConnectTwoInternalElement(side, element3, LRDU.Right, otherSide2, otherElement2, LRDU.Left);
            }
            side = otherSide2;
        }
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        for (SixNodeElement element : this.sideElementList) {
            if (element == null) continue;
            element.disconnectJob();
        }
        Eln.simulator.removeAllElectricalConnection(this.internalElectricalConnectionList);
        Eln.simulator.removeAllThermalConnection(this.internalThermalConnectionList);
    }

    public void tryConnectTwoInternalElement(Direction side, SixNodeElement element, LRDU lrdu, Direction otherSide, SixNodeElement otherElement, LRDU otherLRDU) {
        if (SixNode.compareConnectionMask(element.getConnectionMask(lrdu), otherElement.getConnectionMask(otherLRDU))) {
            ThermalLoad otherTLoad;
            ThermalLoad tLoad;
            ElectricalLoad otherELoad;
            this.lrduElementMask.set(side, lrdu, true);
            this.lrduElementMask.set(otherSide, otherLRDU, true);
            ElectricalLoad eLoad = element.getElectricalLoad(lrdu);
            if (eLoad != null && (otherELoad = otherElement.getElectricalLoad(otherLRDU)) != null) {
                ElectricalConnection eCon = new ElectricalConnection(eLoad, otherELoad);
                Eln.simulator.addElectricalComponent(eCon);
                this.internalElectricalConnectionList.add(eCon);
            }
            if ((tLoad = this.getThermalLoad(side, lrdu)) != null && (otherTLoad = element.getThermalLoad(otherLRDU)) != null) {
                ThermalConnection tCon = new ThermalConnection(tLoad, otherTLoad);
                Eln.simulator.addThermalConnection(tCon);
                this.internalThermalConnectionList.add(tCon);
            }
        }
    }

    @Override
    public void newConnectionAt(Direction side, LRDU lrdu) {
        Direction elementSide = side.applyLRDU(lrdu);
        SixNodeElement element = this.sideElementList[elementSide.getInt()];
        if (element == null) {
            Utils.println("sixnode newConnectionAt error");
            while (true) {
                // Infinite loop
            }
        }
        this.lrduElementMask.set(elementSide, elementSide.getLRDUGoingTo(side), true);
    }

    @Override
    public void externalDisconnect(Direction side, LRDU lrdu) {
        Direction elementSide = side.applyLRDU(lrdu);
        SixNodeElement element = this.sideElementList[elementSide.getInt()];
        if (element == null) {
            Utils.println("sixnode newConnectionAt error");
            while (true) {
                // Infinite loop
            }
        }
        this.lrduElementMask.set(elementSide, elementSide.getLRDUGoingTo(side), false);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (this.sixNodeCacheBlock != Blocks.field_150350_a) {
            return false;
        }
        ItemStack stack = entityPlayer.func_71045_bC();
        Block b = Blocks.field_150350_a;
        if (stack != null) {
            b = Block.func_149634_a((Item)stack.func_77973_b());
        }
        boolean accepted = false;
        if (Eln.playerManager.get(entityPlayer).getInteractEnable() && stack != null) {
            for (ISixNodeCache a : sixNodeCacheList) {
                if (!a.accept(stack)) continue;
                accepted = true;
                this.sixNodeCacheBlock = b;
                this.sixNodeCacheBlockMeta = (byte)a.getMeta(stack);
                break;
            }
        }
        if (accepted) {
            Utils.println("ACACAC");
            this.setNeedPublish(true);
            if (!Utils.isCreative((EntityPlayerMP)entityPlayer)) {
                entityPlayer.field_71071_by.func_70298_a(entityPlayer.field_71071_by.field_70461_c, 1);
            }
            Chunk chunk = this.coordonate.world().func_72938_d(this.coordonate.x, this.coordonate.z);
            Utils.generateHeightMap(chunk);
            Utils.updateSkylight(chunk);
            chunk.func_76603_b();
            Utils.updateAllLightTypes(this.coordonate.world(), this.coordonate.x, this.coordonate.y, this.coordonate.z);
            return true;
        }
        SixNodeElement element = this.sideElementList[side.getInt()];
        if (element == null) {
            return false;
        }
        if (element.onBlockActivated(entityPlayer, side, vx, vy, vz)) {
            return true;
        }
        return super.onBlockActivated(entityPlayer, side, vx, vy, vz);
    }

    @Override
    public boolean hasGui(Direction side) {
        if (this.sideElementList[side.getInt()] == null) {
            return false;
        }
        return this.sideElementList[side.getInt()].hasGui();
    }

    public IInventory getInventory(Direction side) {
        if (this.sideElementList[side.getInt()] == null) {
            return null;
        }
        return this.sideElementList[side.getInt()].getInventory();
    }

    public Container newContainer(Direction side, EntityPlayer player) {
        if (this.sideElementList[side.getInt()] == null) {
            return null;
        }
        return this.sideElementList[side.getInt()].newContainer(side, player);
    }

    public float physicalSelfDestructionExplosionStrength() {
        return 1.0f;
    }

    public void recalculateLightValue() {
        int light = 0;
        for (SixNodeElement element : this.sideElementList) {
            int eLight;
            if (element == null || (eLight = element.getLightValue()) <= light) continue;
            light = eLight;
        }
        this.setLightValue(light);
    }

    @Override
    public void networkUnserialize(DataInputStream stream, EntityPlayerMP player) {
        super.networkUnserialize(stream, player);
        try {
            Direction side = Direction.fromInt(stream.readByte());
            if (side != null & this.sideElementIdList[side.getInt()] == stream.readShort()) {
                this.sideElementList[side.getInt()].networkUnserialize(stream, player);
            } else {
                Utils.println("sixnode unserialize miss");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean hasVolume() {
        for (SixNodeElement element : this.sideElementList) {
            if (element == null || !element.sixNodeElementDescriptor.hasVolume()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getNodeUuid() {
        return Eln.sixNodeBlock.getNodeUuid();
    }

    @Override
    public void globalBoot() {
        super.globalBoot();
        for (SixNodeElement e : this.sideElementList) {
            if (e == null) continue;
            e.globalBoot();
        }
    }

    @Override
    public void unload() {
        super.unload();
        for (SixNodeElement e : this.sideElementList) {
            if (e == null) continue;
            e.unload();
        }
    }
}

