/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.six;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.Utils;
import mods.eln.node.Node;
import mods.eln.node.NodeBlock;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class SixNodeBlock
extends NodeBlock {
    double w = 0.0;
    boolean[] booltemp = new boolean[6];

    public SixNodeBlock(Material material, Class tileEntityClass) {
        super(material, tileEntityClass, 0);
    }

    public void func_149651_a(IIconRegister r) {
        super.func_149651_a(r);
        this.field_149761_L = r.func_94245_a("eln:air");
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        if (this.nodeHasCache((IBlockAccess)par1World, par2, par3, par4) || this.hasVolume(par1World, par2, par3, par4)) {
            return super.func_149668_a(par1World, par2, par3, par4);
        }
        return null;
    }

    public boolean hasVolume(World world, int x, int y, int z) {
        SixNodeEntity entity = this.getEntity(world, x, y, z);
        if (entity == null) {
            return false;
        }
        return entity.hasVolume(world, x, y, z);
    }

    @Override
    public float func_149712_f(World world, int x, int y, int z) {
        return 0.3f;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        if (world == null) {
            return 0;
        }
        SixNodeEntity entity = this.getEntity(world, x, y, z);
        return entity == null ? 0 : entity.getDamageValue(world, x, y, z);
    }

    SixNodeEntity getEntity(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity instanceof SixNodeEntity) {
            return (SixNodeEntity)tileEntity;
        }
        Utils.println("ASSERTSixNodeEntity getEntity() null");
        return null;
    }

    public void func_149666_a(Item par1, CreativeTabs tab, List subItems) {
        Eln.sixNodeItem.func_150895_a(par1, tab, subItems);
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return true;
    }

    @Override
    public int func_149645_b() {
        return 0;
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return null;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess w, int x, int y, int z, int side) {
        TileEntity e = w.func_147438_o(x, y, z);
        if (e == null) {
            return this.field_149761_L;
        }
        SixNodeEntity sne = (SixNodeEntity)e;
        Block b = sne.sixNodeCacheBlock;
        if (b == Blocks.field_150350_a) {
            return this.field_149761_L;
        }
        try {
            return b.func_149691_a(side, (int)sne.sixNodeCacheBlockMeta);
        }
        catch (Exception e2) {
            return this.field_149761_L;
        }
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean func_149707_d(World par1World, int par2, int par3, int par4, int par5) {
        return true;
    }

    public boolean func_149742_c(World par1World, int par2, int par3, int par4) {
        Utils.println("CACATOTAL1");
        while (true) {
            // Infinite loop
        }
    }

    @Override
    public boolean onBlockPlacedBy(World world, int x, int y, int z, Direction direction, EntityLivingBase entityLiving, int metadata) {
        return true;
    }

    public boolean removedByPlayer(World world, EntityPlayer entityPlayer, int x, int y, int z) {
        if (world.field_72995_K) {
            return false;
        }
        SixNodeEntity tileEntity = (SixNodeEntity)world.func_147438_o(x, y, z);
        MovingObjectPosition MOP = this.collisionRayTrace(world, x, y, z, entityPlayer);
        if (MOP == null) {
            return false;
        }
        SixNode sixNode = (SixNode)tileEntity.getNode();
        if (sixNode == null) {
            return true;
        }
        if (sixNode.sixNodeCacheBlock != Blocks.field_150350_a) {
            if (!Utils.isCreative((EntityPlayerMP)entityPlayer)) {
                ItemStack stack = new ItemStack(sixNode.sixNodeCacheBlock, 1, (int)sixNode.sixNodeCacheBlockMeta);
                sixNode.dropItem(stack);
            }
            sixNode.sixNodeCacheBlock = Blocks.field_150350_a;
            Chunk chunk = world.func_72938_d(x, z);
            Utils.generateHeightMap(chunk);
            Utils.updateSkylight(chunk);
            chunk.func_76603_b();
            Utils.updateAllLightTypes(world, x, y, z);
            sixNode.setNeedPublish(true);
            return false;
        }
        if (!sixNode.playerAskToBreakSubBlock((EntityPlayerMP)entityPlayer, Direction.fromIntMinecraftSide(MOP.field_72310_e))) {
            return false;
        }
        if (sixNode.getIfSideRemain()) {
            return true;
        }
        return super.removedByPlayer(world, entityPlayer, x, y, z);
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        if (!world.field_72995_K) {
            SixNodeEntity tileEntity = (SixNodeEntity)world.func_147438_o(x, y, z);
            SixNode sixNode = (SixNode)tileEntity.getNode();
            if (sixNode == null) {
                return;
            }
            for (Direction direction : Direction.values()) {
                if (!sixNode.getSideEnable(direction)) continue;
                sixNode.deleteSubBlock(null, direction);
            }
        }
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block par5) {
        SixNodeEntity tileEntity = (SixNodeEntity)world.func_147438_o(x, y, z);
        SixNode sixNode = (SixNode)tileEntity.getNode();
        if (sixNode == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            if (!sixNode.getSideEnable(direction) || this.getIfOtherBlockIsSolid(world, x, y, z, direction)) continue;
            sixNode.deleteSubBlock(null, direction);
        }
        if (!sixNode.getIfSideRemain()) {
            world.func_147468_f(x, y, z);
        } else {
            super.func_149695_a(world, x, y, z, par5);
        }
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start2, Vec3 end) {
        double hitZ;
        double ratio;
        if (this.nodeHasCache((IBlockAccess)world, x, y, z)) {
            return super.func_149731_a(world, x, y, z, start2, end);
        }
        SixNodeEntity tileEntity = (SixNodeEntity)world.func_147438_o(x, y, z);
        if (tileEntity == null) {
            return null;
        }
        if (world.field_72995_K) {
            SixNodeElementRender element;
            this.booltemp[0] = tileEntity.getSyncronizedSideEnable(Direction.XN);
            this.booltemp[1] = tileEntity.getSyncronizedSideEnable(Direction.XP);
            this.booltemp[2] = tileEntity.getSyncronizedSideEnable(Direction.YN);
            this.booltemp[3] = tileEntity.getSyncronizedSideEnable(Direction.YP);
            this.booltemp[4] = tileEntity.getSyncronizedSideEnable(Direction.ZN);
            this.booltemp[5] = tileEntity.getSyncronizedSideEnable(Direction.ZP);
            SixNodeEntity entity = this.getEntity(world, x, y, z);
            if (entity != null && (element = entity.elementRenderList[Direction.YN.getInt()]) != null && element.sixNodeDescriptor.hasVolume()) {
                return new MovingObjectPosition(x, y, z, Direction.YN.toSideValue(), Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5));
            }
        } else {
            SixNodeElement element;
            Node node;
            SixNode sixNode = (SixNode)tileEntity.getNode();
            if (sixNode == null) {
                return null;
            }
            this.booltemp[0] = sixNode.getSideEnable(Direction.XN);
            this.booltemp[1] = sixNode.getSideEnable(Direction.XP);
            this.booltemp[2] = sixNode.getSideEnable(Direction.YN);
            this.booltemp[3] = sixNode.getSideEnable(Direction.YP);
            this.booltemp[4] = sixNode.getSideEnable(Direction.ZN);
            this.booltemp[5] = sixNode.getSideEnable(Direction.ZP);
            SixNodeEntity entity = this.getEntity(world, x, y, z);
            if (entity != null && (node = entity.getNode()) != null && node instanceof SixNode && (element = ((SixNode)node).sideElementList[Direction.YN.getInt()]) != null && element.sixNodeElementDescriptor.hasVolume()) {
                return new MovingObjectPosition(x, y, z, Direction.YN.toSideValue(), Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5));
            }
        }
        if (SixNodeBlock.isIn(x, end.field_72450_a, start2.field_72450_a) && this.booltemp[0] && (ratio = ((double)x - start2.field_72450_a) / (end.field_72450_a - start2.field_72450_a)) <= 1.1) {
            double hitX = start2.field_72450_a + ratio * (end.field_72450_a - start2.field_72450_a);
            double hitY = start2.field_72448_b + ratio * (end.field_72448_b - start2.field_72448_b);
            hitZ = start2.field_72449_c + ratio * (end.field_72449_c - start2.field_72449_c);
            if (SixNodeBlock.isIn(hitY, (double)y + this.w, (double)(y + 1) - this.w) && SixNodeBlock.isIn(hitZ, (double)z + this.w, (double)(z + 1) - this.w)) {
                return new MovingObjectPosition(x, y, z, Direction.XN.toSideValue(), Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ));
            }
        }
        if (SixNodeBlock.isIn(x + 1, start2.field_72450_a, end.field_72450_a) && this.booltemp[1] && (ratio = ((double)(x + 1) - start2.field_72450_a) / (end.field_72450_a - start2.field_72450_a)) <= 1.1) {
            double hitX = start2.field_72450_a + ratio * (end.field_72450_a - start2.field_72450_a);
            double hitY = start2.field_72448_b + ratio * (end.field_72448_b - start2.field_72448_b);
            hitZ = start2.field_72449_c + ratio * (end.field_72449_c - start2.field_72449_c);
            if (SixNodeBlock.isIn(hitY, (double)y + this.w, (double)(y + 1) - this.w) && SixNodeBlock.isIn(hitZ, (double)z + this.w, (double)(z + 1) - this.w)) {
                return new MovingObjectPosition(x, y, z, Direction.XP.toSideValue(), Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ));
            }
        }
        if (SixNodeBlock.isIn(y, end.field_72448_b, start2.field_72448_b) && this.booltemp[2] && (ratio = ((double)y - start2.field_72448_b) / (end.field_72448_b - start2.field_72448_b)) <= 1.1) {
            double hitX = start2.field_72450_a + ratio * (end.field_72450_a - start2.field_72450_a);
            double hitY = start2.field_72448_b + ratio * (end.field_72448_b - start2.field_72448_b);
            hitZ = start2.field_72449_c + ratio * (end.field_72449_c - start2.field_72449_c);
            if (SixNodeBlock.isIn(hitX, (double)x + this.w, (double)(x + 1) - this.w) && SixNodeBlock.isIn(hitZ, (double)z + this.w, (double)(z + 1) - this.w)) {
                return new MovingObjectPosition(x, y, z, Direction.YN.toSideValue(), Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ));
            }
        }
        if (SixNodeBlock.isIn(y + 1, start2.field_72448_b, end.field_72448_b) && this.booltemp[3] && (ratio = ((double)(y + 1) - start2.field_72448_b) / (end.field_72448_b - start2.field_72448_b)) <= 1.1) {
            double hitX = start2.field_72450_a + ratio * (end.field_72450_a - start2.field_72450_a);
            double hitY = start2.field_72448_b + ratio * (end.field_72448_b - start2.field_72448_b);
            hitZ = start2.field_72449_c + ratio * (end.field_72449_c - start2.field_72449_c);
            if (SixNodeBlock.isIn(hitX, (double)x + this.w, (double)(x + 1) - this.w) && SixNodeBlock.isIn(hitZ, (double)z + this.w, (double)(z + 1) - this.w)) {
                return new MovingObjectPosition(x, y, z, Direction.YP.toSideValue(), Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ));
            }
        }
        if (SixNodeBlock.isIn(z, end.field_72449_c, start2.field_72449_c) && this.booltemp[4] && (ratio = ((double)z - start2.field_72449_c) / (end.field_72449_c - start2.field_72449_c)) <= 1.1) {
            double hitX = start2.field_72450_a + ratio * (end.field_72450_a - start2.field_72450_a);
            double hitY = start2.field_72448_b + ratio * (end.field_72448_b - start2.field_72448_b);
            hitZ = start2.field_72449_c + ratio * (end.field_72449_c - start2.field_72449_c);
            if (SixNodeBlock.isIn(hitY, (double)y + this.w, (double)(y + 1) - this.w) && SixNodeBlock.isIn(hitX, (double)x + this.w, (double)(x + 1) - this.w)) {
                return new MovingObjectPosition(x, y, z, Direction.ZN.toSideValue(), Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ));
            }
        }
        if (SixNodeBlock.isIn(z + 1, start2.field_72449_c, end.field_72449_c) && this.booltemp[5] && (ratio = ((double)(z + 1) - start2.field_72449_c) / (end.field_72449_c - start2.field_72449_c)) <= 1.1) {
            double hitX = start2.field_72450_a + ratio * (end.field_72450_a - start2.field_72450_a);
            double hitY = start2.field_72448_b + ratio * (end.field_72448_b - start2.field_72448_b);
            hitZ = start2.field_72449_c + ratio * (end.field_72449_c - start2.field_72449_c);
            if (SixNodeBlock.isIn(hitY, (double)y + this.w, (double)(y + 1) - this.w) && SixNodeBlock.isIn(hitX, (double)x + this.w, (double)(x + 1) - this.w)) {
                return new MovingObjectPosition(x, y, z, Direction.ZP.toSideValue(), Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ));
            }
        }
        return null;
    }

    public static boolean isIn(double value, double min, double max) {
        return value >= min && value <= max;
    }

    public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, EntityPlayer entityLiving) {
        double distanceMax = 5.0;
        Vec3 start2 = Vec3.func_72443_a((double)entityLiving.field_70165_t, (double)entityLiving.field_70163_u, (double)entityLiving.field_70161_v);
        if (!world.field_72995_K) {
            start2.field_72448_b += 1.62;
        }
        Vec3 var5 = entityLiving.func_70676_i(0.5f);
        Vec3 end = start2.func_72441_c(var5.field_72450_a * distanceMax, var5.field_72448_b * distanceMax, var5.field_72449_c * distanceMax);
        return this.func_149731_a(world, x, y, z, start2, end);
    }

    public boolean getIfOtherBlockIsSolid(World world, int x, int y, int z, Direction direction) {
        int[] vect = new int[]{x, y, z};
        direction.applyTo(vect, 1);
        Block block = world.func_147439_a(vect[0], vect[1], vect[2]);
        if (block == Blocks.field_150350_a) {
            return false;
        }
        return block.func_149662_c();
    }

    public boolean nodeHasCache(IBlockAccess world, int x, int y, int z) {
        if (Utils.isRemote(world)) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity != null && tileEntity instanceof SixNodeEntity) {
                return ((SixNodeEntity)tileEntity).sixNodeCacheBlock != Blocks.field_150350_a;
            }
            Utils.println("ASSERT B public boolean nodeHasCache(World world, int x, int y, int z) ");
        } else {
            SixNodeEntity tileEntity = (SixNodeEntity)world.func_147438_o(x, y, z);
            SixNode sixNode = (SixNode)tileEntity.getNode();
            if (sixNode != null) {
                return sixNode.sixNodeCacheBlock != Blocks.field_150350_a;
            }
            Utils.println("ASSERT A public boolean nodeHasCache(World world, int x, int y, int z) ");
        }
        return false;
    }

    public int getLightOpacity(IBlockAccess w, int x, int y, int z) {
        TileEntity e = w.func_147438_o(x, y, z);
        if (e == null) {
            return 0;
        }
        SixNodeEntity sne = (SixNodeEntity)e;
        Block b = sne.sixNodeCacheBlock;
        if (b == Blocks.field_150350_a) {
            return 0;
        }
        try {
            return b.func_149717_k();
        }
        catch (Exception e2) {
            return 255;
        }
    }

    public String getNodeUuid() {
        return "s";
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World w, int x, int y, int z) {
        if (this.hasVolume(w, x, y, z)) {
            return super.func_149633_g(w, x, y, z);
        }
        MovingObjectPosition col = this.collisionRayTrace(w, x, y, z, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        double h = 0.2;
        double hn = 1.0 - h;
        double b = 0.02;
        double bn = 0.98;
        if (col != null) {
            switch (Direction.fromIntMinecraftSide(col.field_72310_e)) {
                case XN: {
                    return AxisAlignedBB.func_72330_a((double)((double)x + b), (double)y, (double)z, (double)((double)x + h), (double)((double)y + 1.0), (double)((double)z + 1.0));
                }
                case XP: {
                    return AxisAlignedBB.func_72330_a((double)((double)x + hn), (double)y, (double)z, (double)((double)x + bn), (double)((double)y + 1.0), (double)((double)z + 1.0));
                }
                case YN: {
                    return AxisAlignedBB.func_72330_a((double)x, (double)((double)y + b), (double)z, (double)((double)x + 1.0), (double)((double)y + h), (double)((double)z + 1.0));
                }
                case YP: {
                    return AxisAlignedBB.func_72330_a((double)x, (double)((double)y + hn), (double)z, (double)((double)x + 1.0), (double)((double)y + bn), (double)((double)z + 1.0));
                }
                case ZN: {
                    return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)((double)z + b), (double)((double)x + 1.0), (double)((double)y + 1.0), (double)((double)z + h));
                }
                case ZP: {
                    return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)((double)z + hn), (double)((double)x + 1.0), (double)((double)y + 1.0), (double)((double)z + bn));
                }
            }
        }
        return AxisAlignedBB.func_72330_a((double)0.5, (double)0.5, (double)0.5, (double)0.5, (double)0.5, (double)0.5);
    }
}

