/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.six;

import mods.eln.generic.GenericItemBlockUsingDamageDescriptor;
import mods.eln.ghost.GhostGroup;
import mods.eln.i18n.I18N;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;

public class SixNodeDescriptor
extends GenericItemBlockUsingDamageDescriptor
implements IItemRenderer {
    public Class ElementClass;
    public Class RenderClass;
    public VoltageLevelColor voltageLevelColor = VoltageLevelColor.None;
    protected GhostGroup ghostGroup = null;
    protected Direction[] placeDirection = null;

    public SixNodeDescriptor(String name, Class ElementClass, Class RenderClass) {
        super(name);
        this.ElementClass = ElementClass;
        this.RenderClass = RenderClass;
    }

    public SixNodeDescriptor(String name, Class ElementClass, Class RenderClass, String iconName) {
        super(name, iconName);
        this.ElementClass = ElementClass;
        this.RenderClass = RenderClass;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.INVENTORY ? false : !this.use2DIcon();
    }

    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return !this.use2DIcon();
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (this.getIcon() == null) {
            return;
        }
        this.voltageLevelColor.drawIconBackground(type);
        String icon = this.getIcon().func_94215_i().substring(4);
        UtilsClient.drawIcon(type, new ResourceLocation("eln", "textures/blocks/" + icon + ".png"));
    }

    public boolean hasVolume() {
        return false;
    }

    public boolean canBePlacedOnSide(EntityPlayer player, Coordonate c, Direction side) {
        return this.canBePlacedOnSide(player, side);
    }

    public boolean canBePlacedOnSide(EntityPlayer player, Direction side) {
        if (this.placeDirection != null) {
            for (Direction d : this.placeDirection) {
                if (d != side) continue;
                return true;
            }
            Utils.addChatMessage(player, I18N.tr("You can't place this block at this side", new Object[0]));
            return false;
        }
        return true;
    }

    public void setGhostGroup(GhostGroup ghostGroup) {
        this.ghostGroup = ghostGroup;
    }

    public boolean hasGhostGroup() {
        return this.ghostGroup != null;
    }

    public GhostGroup getGhostGroup(Direction side, LRDU front) {
        if (this.ghostGroup == null) {
            return null;
        }
        return this.ghostGroup.newRotate(side, front);
    }

    public int getGhostGroupUuid() {
        return -1;
    }

    public void setPlaceDirection(Direction d) {
        this.placeDirection = new Direction[]{d};
    }

    public void setPlaceDirection(Direction[] d) {
        this.placeDirection = d;
    }

    public String checkCanPlace(Coordonate coord, Direction direction, LRDU front) {
        GhostGroup ghostGroup;
        if (this.placeDirection != null) {
            boolean ok = false;
            for (Direction d : this.placeDirection) {
                if (d != direction) continue;
                ok = true;
                break;
            }
            if (!ok) {
                return I18N.tr("You can't place this block at this side", new Object[0]);
            }
        }
        if ((ghostGroup = this.getGhostGroup(direction, front)) != null && !ghostGroup.canBePloted(coord)) {
            return I18N.tr("Not enough space for this block", new Object[0]);
        }
        return null;
    }

    public LRDU getFrontFromPlace(Direction side, EntityPlayer player) {
        switch (side) {
            case YN: 
            case YP: {
                Direction viewDirection = Utils.entityLivingHorizontalViewDirection((EntityLivingBase)player);
                LRDU front = side.getLRDUGoingTo(viewDirection);
                return side == Direction.YN ? front : front.inverse();
            }
        }
        return LRDU.Up;
    }
}

