/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.six;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import mods.eln.Eln;
import mods.eln.ghost.GhostObserver;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.Publishable;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalConnection;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Component;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sound.IPlayer;
import mods.eln.sound.SoundCommand;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class SixNodeElement
implements GhostObserver,
IPlayer,
Publishable {
    public ArrayList<IProcess> slowProcessList = new ArrayList(4);
    public ArrayList<IProcess> electricalProcessList = new ArrayList(4);
    public ArrayList<Component> electricalComponentList = new ArrayList(4);
    public ArrayList<NbtElectricalLoad> electricalLoadList = new ArrayList(4);
    public ArrayList<IProcess> thermalProcessList = new ArrayList(4);
    public ArrayList<IProcess> thermalSlowProcessList = new ArrayList(4);
    public ArrayList<ThermalConnection> thermalConnectionList = new ArrayList(4);
    public ArrayList<NbtThermalLoad> thermalLoadList = new ArrayList(4);
    public SixNode sixNode;
    public Direction side;
    public SixNodeDescriptor sixNodeElementDescriptor;
    public LRDU front = LRDU.Up;
    private int itemStackDamageId;
    private int uuid = 0;

    public int isProvidingWeakPower() {
        return 0;
    }

    protected void inventoryChanged() {
    }

    @Override
    public void play(SoundCommand s) {
        s.addUuid(this.getUuid());
        s.set(this.sixNode.coordonate);
        s.play();
    }

    public Coordonate getCoordonate() {
        return this.sixNode.coordonate;
    }

    protected boolean onBlockActivatedRotate(EntityPlayer entityPlayer) {
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.front = this.front.getNextClockwise();
            this.sixNode.reconnect();
            this.sixNode.setNeedPublish(true);
            return true;
        }
        return false;
    }

    public void sendPacketToAllClient(ByteArrayOutputStream bos) {
        this.sixNode.sendPacketToAllClient(bos);
    }

    public void sendPacketToAllClient(ByteArrayOutputStream bos, double range) {
        this.sixNode.sendPacketToAllClient(bos, range);
    }

    public void sendPacketToClient(ByteArrayOutputStream bos, EntityPlayerMP player) {
        this.sixNode.sendPacketToClient(bos, player);
    }

    public void notifyNeighbor() {
        this.sixNode.notifyNeighbor();
    }

    public void connectJob() {
        Eln.simulator.addAllElectricalComponent(this.electricalComponentList);
        Eln.simulator.addAllThermalConnection(this.thermalConnectionList);
        for (NbtElectricalLoad nbtElectricalLoad : this.electricalLoadList) {
            Eln.simulator.addElectricalLoad(nbtElectricalLoad);
        }
        for (NbtThermalLoad nbtThermalLoad : this.thermalLoadList) {
            Eln.simulator.addThermalLoad(nbtThermalLoad);
        }
        for (IProcess iProcess : this.slowProcessList) {
            Eln.simulator.addSlowProcess(iProcess);
        }
        for (IProcess iProcess : this.electricalProcessList) {
            Eln.simulator.addElectricalProcess(iProcess);
        }
        for (IProcess iProcess : this.thermalProcessList) {
            Eln.simulator.addThermalFastProcess(iProcess);
        }
        for (IProcess iProcess : this.thermalSlowProcessList) {
            Eln.simulator.addThermalSlowProcess(iProcess);
        }
    }

    public void networkUnserialize(DataInputStream stream) {
    }

    public void networkUnserialize(DataInputStream stream, EntityPlayerMP player) {
        this.networkUnserialize(stream);
    }

    public int getLightValue() {
        return 0;
    }

    public boolean hasGui() {
        return false;
    }

    public IInventory getInventory() {
        return null;
    }

    public Container newContainer(Direction side, EntityPlayer player) {
        return null;
    }

    public SixNodeElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        this.sixNode = sixNode;
        this.side = side;
        this.sixNodeElementDescriptor = descriptor;
        this.itemStackDamageId = sixNode.sideElementIdList[side.getInt()];
        if (descriptor.hasGhostGroup()) {
            Eln.ghostManager.addObserver(this);
        }
    }

    public void preparePacketForClient(DataOutputStream stream) {
        this.sixNode.preparePacketForClient(stream, this);
    }

    public abstract ElectricalLoad getElectricalLoad(LRDU var1);

    public abstract ThermalLoad getThermalLoad(LRDU var1);

    public abstract int getConnectionMask(LRDU var1);

    public abstract String multiMeterString();

    public abstract String thermoMeterString();

    public void networkSerialize(DataOutputStream stream) {
        try {
            stream.writeByte(this.sixNode.lrduElementMask.get((Direction)this.side).mask + (this.front.dir << 4));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public abstract void initialize();

    @Override
    public void stop(int uuid) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
        DataOutputStream stream = new DataOutputStream(bos);
        try {
            stream.writeByte(20);
            stream.writeInt(uuid);
            this.sendPacketToAllClient(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void destroy(EntityPlayerMP entityPlayer) {
        if (this.useUuid()) {
            this.stop(this.uuid);
        }
        if (this.sixNodeElementDescriptor.hasGhostGroup()) {
            Eln.ghostManager.removeObserver(this.sixNode.coordonate);
            this.sixNodeElementDescriptor.getGhostGroup(this.side, this.front).erase(this.sixNode.coordonate);
        }
        this.sixNode.dropInventory(this.getInventory());
        if (Utils.mustDropItem(entityPlayer)) {
            this.sixNode.dropItem(this.getDropItemStack());
        }
    }

    public abstract boolean onBlockActivated(EntityPlayer var1, Direction var2, float var3, float var4, float var5);

    public ItemStack getDropItemStack() {
        return new ItemStack((Block)Eln.sixNodeBlock, 1, this.itemStackDamageId);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.front = LRDU.readFromNBT(nbt, "sixFront");
        IInventory inv = this.getInventory();
        if (inv != null) {
            Utils.readFromNBT(nbt, "inv", inv);
        }
        for (NbtElectricalLoad electricalLoad : this.electricalLoadList) {
            electricalLoad.readFromNBT(nbt, "");
        }
        for (NbtThermalLoad thermalLoad : this.thermalLoadList) {
            thermalLoad.readFromNBT(nbt, "");
        }
        for (Component c : this.electricalComponentList) {
            if (!(c instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)c)).readFromNBT(nbt, "");
        }
        for (IProcess process : this.slowProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).readFromNBT(nbt, "");
        }
        for (IProcess process : this.electricalProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).readFromNBT(nbt, "");
        }
        for (IProcess process : this.thermalProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).readFromNBT(nbt, "");
        }
        for (IProcess process : this.thermalSlowProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).readFromNBT(nbt, "");
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.front.writeToNBT(nbt, "sixFront");
        IInventory inv = this.getInventory();
        if (inv != null) {
            Utils.writeToNBT(nbt, "inv", inv);
        }
        for (NbtElectricalLoad electricalLoad : this.electricalLoadList) {
            electricalLoad.writeToNBT(nbt, "");
        }
        for (NbtThermalLoad thermalLoad : this.thermalLoadList) {
            thermalLoad.writeToNBT(nbt, "");
        }
        for (Component c : this.electricalComponentList) {
            if (!(c instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)c)).writeToNBT(nbt, "");
        }
        for (IProcess process : this.slowProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).writeToNBT(nbt, "");
        }
        for (IProcess process : this.electricalProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).writeToNBT(nbt, "");
        }
        for (IProcess process : this.thermalProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).writeToNBT(nbt, "");
        }
        for (IProcess process : this.thermalSlowProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).writeToNBT(nbt, "");
        }
    }

    public void reconnect() {
        this.sixNode.reconnect();
    }

    @Override
    public void needPublish() {
        this.sixNode.setNeedPublish(true);
    }

    public void disconnectJob() {
        Eln.simulator.removeAllElectricalComponent(this.electricalComponentList);
        Eln.simulator.removeAllThermalConnection(this.thermalConnectionList);
        for (NbtElectricalLoad nbtElectricalLoad : this.electricalLoadList) {
            Eln.simulator.removeElectricalLoad(nbtElectricalLoad);
        }
        for (NbtThermalLoad nbtThermalLoad : this.thermalLoadList) {
            Eln.simulator.removeThermalLoad(nbtThermalLoad);
        }
        for (IProcess iProcess : this.slowProcessList) {
            Eln.simulator.removeSlowProcess(iProcess);
        }
        for (IProcess iProcess : this.electricalProcessList) {
            Eln.simulator.removeElectricalProcess(iProcess);
        }
        for (IProcess iProcess : this.thermalProcessList) {
            Eln.simulator.removeThermalFastProcess(iProcess);
        }
        for (IProcess iProcess : this.thermalSlowProcessList) {
            Eln.simulator.removeThermalSlowProcess(iProcess);
        }
    }

    public boolean canConnectRedstone() {
        return false;
    }

    @Override
    public Coordonate getGhostObserverCoordonate() {
        return this.sixNode.coordonate;
    }

    @Override
    public void ghostDestroyed(int UUID2) {
        if (UUID2 == this.sixNodeElementDescriptor.getGhostGroupUuid()) {
            this.selfDestroy();
        }
    }

    @Override
    public boolean ghostBlockActivated(int UUID2, EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (UUID2 == this.sixNodeElementDescriptor.getGhostGroupUuid()) {
            this.sixNode.onBlockActivated(entityPlayer, this.side, vx, vy, vz);
        }
        return false;
    }

    private void selfDestroy() {
        this.sixNode.deleteSubBlock(null, this.side);
    }

    public int getUuid() {
        if (this.uuid == 0) {
            this.uuid = Utils.getUuid();
        }
        return this.uuid;
    }

    public boolean useUuid() {
        return this.uuid != 0;
    }

    public void globalBoot() {
    }

    public void unload() {
    }

    public boolean playerAskToBreak() {
        return true;
    }
}

