/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.six;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.cable.CableRender;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.cable.CableRenderType;
import mods.eln.client.ClientProxy;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUMask;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sound.SoundCommand;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import org.lwjgl.opengl.GL11;

public abstract class SixNodeElementRender {
    public SixNodeEntity tileEntity;
    public Direction side;
    public LRDUMask connectedSide = new LRDUMask();
    int glList;
    int[] cableList;
    boolean[] cableListReady = new boolean[]{false, false, false, false};
    boolean glListReady = false;
    boolean needRedraw;
    public LRDU front;
    CableRenderType connectionType;
    public SixNodeDescriptor sixNodeDescriptor;
    private int uuid = 0;

    public SixNodeElementRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        this.sixNodeDescriptor = descriptor;
        this.tileEntity = tileEntity;
        this.side = side;
        this.cableList = new int[4];
        if (this.glListEnable()) {
            this.glList = UtilsClient.glGenListsSafe();
        }
        this.cableList[0] = UtilsClient.glGenListsSafe();
        this.cableList[1] = UtilsClient.glGenListsSafe();
        this.cableList[2] = UtilsClient.glGenListsSafe();
        this.cableList[3] = UtilsClient.glGenListsSafe();
    }

    public void needRedrawCable() {
        this.needRedraw = true;
    }

    public void drawPowerPin(float[] d) {
        this.drawPowerPin(this.front, d);
    }

    public void drawPowerPin(LRDU front, float[] d) {
        if (UtilsClient.distanceFromClientPlayer(this.tileEntity) > 20.0f) {
            return;
        }
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        UtilsClient.drawConnectionPinSixNode(front, d, 1.8f, 0.9f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawPowerPinWhite(LRDU front, float[] d) {
        if (UtilsClient.distanceFromClientPlayer(this.tileEntity) > 20.0f) {
            return;
        }
        UtilsClient.drawConnectionPinSixNode(front, d, 1.8f, 0.9f);
    }

    public void drawSignalPin(float[] d) {
        this.drawSignalPin(this.front, d);
    }

    public void drawSignalPin(LRDU front, float[] d) {
        if (UtilsClient.distanceFromClientPlayer(this.tileEntity) > 20.0f) {
            return;
        }
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        UtilsClient.drawConnectionPinSixNode(front, d, 0.9f, 0.9f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void newConnectionType(CableRenderType connectionType) {
    }

    public void draw() {
        int idx;
        if (this.needRedraw) {
            this.needRedraw = false;
            this.connectionType = CableRender.connectionType(this, this.side);
            this.newConnectionType(this.connectionType);
            if (this.drawCableAuto()) {
                for (idx = 0; idx < 4; ++idx) {
                    CableRenderDescriptor render = this.getCableRender(LRDU.fromInt(idx));
                    this.cableListReady[idx] = false;
                    if (render == null || (this.connectedSide.mask & 1 << idx) == 0) continue;
                    GL11.glNewList((int)this.cableList[idx], (int)4864);
                    CableRender.drawCable(render, new LRDUMask(1 << idx), this.connectionType);
                    GL11.glEndList();
                    this.cableListReady[idx] = true;
                }
            }
        }
        for (idx = 0; idx < 4; ++idx) {
            Utils.setGlColorFromDye(this.connectionType.otherdry[idx]);
            if (!this.cableListReady[idx]) continue;
            UtilsClient.bindTexture(this.getCableRender((LRDU)LRDU.fromInt((int)idx)).cableTexture);
            GL11.glCallList((int)this.cableList[idx]);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean drawCableAuto() {
        return true;
    }

    public boolean glListEnable() {
        return true;
    }

    public void glListCall() {
        if (!this.glListEnable()) {
            return;
        }
        if (!this.glListReady) {
            GL11.glNewList((int)this.glList, (int)4864);
            this.glListDraw();
            GL11.glEndList();
            this.glListReady = true;
        }
        GL11.glCallList((int)this.glList);
    }

    public void glListDraw() {
    }

    public int isProvidingWeakPower(Direction side) {
        return 0;
    }

    public void publishUnserialize(DataInputStream stream) {
        try {
            byte b = stream.readByte();
            this.connectedSide.set(b & 0xF);
            this.front = LRDU.fromInt(b >> 4 & 3);
            this.needRedraw = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.glListReady = false;
    }

    public void singleUnserialize(DataInputStream stream) {
    }

    public int getUuid() {
        if (this.uuid == 0) {
            this.uuid = UtilsClient.getUuid();
        }
        return this.uuid;
    }

    public boolean usedUuid() {
        return this.uuid != 0;
    }

    public void play(SoundCommand s) {
        s.addUuid(this.getUuid());
        s.set(this.tileEntity);
        s.play();
    }

    public void destructor() {
        if (this.usedUuid()) {
            ClientProxy.uuidManager.kill(this.uuid);
        }
        if (this.glListEnable()) {
            UtilsClient.glDeleteListsSafe(this.glList);
        }
        UtilsClient.glDeleteListsSafe(this.cableList[0]);
        UtilsClient.glDeleteListsSafe(this.cableList[1]);
        UtilsClient.glDeleteListsSafe(this.cableList[2]);
        UtilsClient.glDeleteListsSafe(this.cableList[3]);
    }

    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return null;
    }

    public IInventory getInventory() {
        return null;
    }

    public void preparePacketForServer(DataOutputStream stream) {
        try {
            this.tileEntity.preparePacketForServer(stream);
            stream.writeByte(this.side.getInt());
            stream.writeShort(this.tileEntity.elementRenderIdList[this.side.getInt()]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sendPacketToServer(ByteArrayOutputStream bos) {
        this.tileEntity.sendPacketToServer(bos);
    }

    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        return null;
    }

    public int getCableDry(LRDU lrdu) {
        return 0;
    }

    public void clientSetFloat(int id, float value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            stream.writeFloat(value);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clientSetFloat(int id, float value1, float value2) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            stream.writeFloat(value1);
            stream.writeFloat(value2);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clientSetDouble(byte id, double value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            stream.writeDouble(value);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clientSetString(byte id, String text) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            stream.writeUTF(text);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clientSetInt(byte id, int value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            stream.writeInt(value);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clientSetByte(byte id, byte value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            stream.writeByte(value);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clientSend(int id) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean cameraDrawOptimisation() {
        return true;
    }

    public void serverPacketUnserialize(DataInputStream stream) throws IOException {
    }

    public void notifyNeighborSpawn() {
        this.needRedraw = true;
    }

    public void refresh(float deltaT) {
    }
}

