/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.six;

import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodeBlockEntity;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class SixNodeEntity
extends NodeBlockEntity {
    public SixNodeElementRender[] elementRenderList = new SixNodeElementRender[6];
    short[] elementRenderIdList = new short[6];
    public Block sixNodeCacheBlock = Blocks.field_150350_a;
    public byte sixNodeCacheBlockMeta = 0;
    public static final int singleTargetId = 2;

    public SixNodeEntity() {
        for (int idx = 0; idx < 6; ++idx) {
            this.elementRenderList[idx] = null;
            this.elementRenderIdList[idx] = 0;
        }
    }

    @Override
    public void serverPublishUnserialize(DataInputStream stream) {
        Block sixNodeCacheBlockOld = this.sixNodeCacheBlock;
        super.serverPublishUnserialize(stream);
        try {
            this.sixNodeCacheBlock = Block.func_149729_e((int)stream.readInt());
            this.sixNodeCacheBlockMeta = stream.readByte();
            for (int idx = 0; idx < 6; ++idx) {
                short id = stream.readShort();
                if (id == 0) {
                    this.elementRenderIdList[idx] = 0;
                    this.elementRenderList[idx] = null;
                    continue;
                }
                if (id != this.elementRenderIdList[idx]) {
                    this.elementRenderIdList[idx] = id;
                    SixNodeDescriptor descriptor = (SixNodeDescriptor)Eln.sixNodeItem.getDescriptor(id);
                    this.elementRenderList[idx] = (SixNodeElementRender)descriptor.RenderClass.getConstructor(SixNodeEntity.class, Direction.class, SixNodeDescriptor.class).newInstance(new Object[]{this, Direction.fromInt(idx), descriptor});
                }
                this.elementRenderList[idx].publishUnserialize(stream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        if (this.sixNodeCacheBlock != sixNodeCacheBlockOld) {
            Chunk chunk = this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e);
            chunk.func_76590_a();
            Utils.updateSkylight(chunk);
            chunk.func_76603_b();
            Utils.updateAllLightTypes(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void serverPacketUnserialize(DataInputStream stream) {
        super.serverPacketUnserialize(stream);
        try {
            byte side = stream.readByte();
            short id = stream.readShort();
            if (this.elementRenderIdList[side] == id) {
                this.elementRenderList[side].serverPacketUnserialize(stream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean getSyncronizedSideEnable(Direction direction) {
        return this.elementRenderList[direction.getInt()] != null;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        SixNode n = (SixNode)this.getNode();
        if (n == null) {
            return null;
        }
        return n.newContainer(side, player);
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return this.elementRenderList[side.getInt()].newGuiDraw(side, player);
    }

    @Override
    public CableRenderDescriptor getCableRender(Direction side, LRDU lrdu) {
        if (this.elementRenderList[(side = side.applyLRDU(lrdu)).getInt()] == null) {
            return null;
        }
        return this.elementRenderList[side.getInt()].getCableRender(lrdu);
    }

    @Override
    public int getCableDry(Direction side, LRDU lrdu) {
        if (this.elementRenderList[(side = side.applyLRDU(lrdu)).getInt()] == null) {
            return 0;
        }
        return this.elementRenderList[side.getInt()].getCableDry(lrdu);
    }

    @Override
    public boolean cameraDrawOptimisation() {
        for (SixNodeElementRender e : this.elementRenderList) {
            if (e == null || e.cameraDrawOptimisation()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void destructor() {
        for (SixNodeElementRender render : this.elementRenderList) {
            if (render == null) continue;
            render.destructor();
        }
        super.destructor();
    }

    public int getDamageValue(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            for (int idx = 0; idx < 6; ++idx) {
                if (this.elementRenderList[idx] == null) continue;
                return this.elementRenderIdList[idx];
            }
        }
        return 0;
    }

    public boolean hasVolume(World world, int x, int y, int z) {
        if (this.field_145850_b.field_72995_K) {
            for (SixNodeElementRender e : this.elementRenderList) {
                if (e == null || !e.sixNodeDescriptor.hasVolume()) continue;
                return true;
            }
            return false;
        }
        SixNode node = (SixNode)this.getNode();
        if (node == null) {
            return false;
        }
        return node.hasVolume();
    }

    @Override
    public void tileEntityNeighborSpawn() {
        for (SixNodeElementRender e : this.elementRenderList) {
            if (e == null) continue;
            e.notifyNeighborSpawn();
        }
    }

    @Override
    public String getNodeUuid() {
        return Eln.sixNodeBlock.getNodeUuid();
    }

    @Override
    public void clientRefresh(float deltaT) {
        for (SixNodeElementRender e : this.elementRenderList) {
            if (e == null) continue;
            e.refresh(deltaT);
        }
    }

    @Override
    public int isProvidingWeakPower(Direction side) {
        if (this.field_145850_b.field_72995_K) {
            int max = 0;
            for (SixNodeElementRender r : this.elementRenderList) {
                if (r == null || max >= r.isProvidingWeakPower(side)) continue;
                max = r.isProvidingWeakPower(side);
            }
            return max;
        }
        if (this.getNode() == null) {
            return 0;
        }
        return this.getNode().isProvidingWeakPower(side);
    }
}

