/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.transparent;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.Node;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.IFluidHandler;

public class TransparentNode
extends Node {
    public TransparentNodeElement element;
    public int elementId;
    public EntityPlayerMP removedByPlayer;

    @Override
    public boolean nodeAutoSave() {
        return false;
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.element.onNeighborBlockChange();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt.func_74775_l("node"));
        this.elementId = nbt.func_74765_d("eid");
        try {
            TransparentNodeDescriptor descriptor = (TransparentNodeDescriptor)Eln.transparentNodeItem.getDescriptor(this.elementId);
            this.element = (TransparentNodeElement)descriptor.ElementClass.getConstructor(TransparentNode.class, TransparentNodeDescriptor.class).newInstance(this, descriptor);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        this.element.readFromNBT(nbt.func_74775_l("element"));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(Utils.newNbtTagCompund(nbt, "node"));
        nbt.func_74777_a("eid", (short)this.elementId);
        this.element.writeToNBT(Utils.newNbtTagCompund(nbt, "element"));
    }

    @Override
    public void onBreakBlock() {
        this.element.onBreakElement();
        super.onBreakBlock();
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        return this.element.getElectricalLoad(side, lrdu);
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrdu) {
        return this.element.getThermalLoad(side, lrdu);
    }

    @Override
    public int getSideConnectionMask(Direction side, LRDU lrdu) {
        return this.element.getConnectionMask(side, lrdu);
    }

    @Override
    public String multiMeterString(Direction side) {
        return this.element.multiMeterString(side);
    }

    @Override
    public String thermoMeterString(Direction side) {
        return this.element.thermoMeterString(side);
    }

    public IFluidHandler getFluidHandler() {
        return this.element.getFluidHandler();
    }

    @Override
    public void publishSerialize(DataOutputStream stream) {
        super.publishSerialize(stream);
        try {
            stream.writeShort(this.elementId);
            this.element.networkSerialize(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initializeFromThat(Direction side, EntityLivingBase entityLiving, ItemStack itemStack) {
        try {
            int metadata;
            TransparentNodeDescriptor descriptor = (TransparentNodeDescriptor)Eln.transparentNodeItem.getDescriptor(itemStack);
            this.elementId = metadata = itemStack.func_77960_j();
            this.element = (TransparentNodeElement)descriptor.ElementClass.getConstructor(TransparentNode.class, TransparentNodeDescriptor.class).newInstance(this, descriptor);
            this.element.initializeFromThat(side, entityLiving, itemStack.func_77978_p());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initializeFromNBT() {
        this.element.initialize();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (this.element.onBlockActivated(entityPlayer, side, vx, vy, vz)) {
            return true;
        }
        return super.onBlockActivated(entityPlayer, side, vx, vy, vz);
    }

    @Override
    public boolean hasGui(Direction side) {
        if (this.element == null) {
            return false;
        }
        return this.element.hasGui();
    }

    public IInventory getInventory(Direction side) {
        if (this.element == null) {
            return null;
        }
        return this.element.getInventory();
    }

    public Container newContainer(Direction side, EntityPlayer player) {
        if (this.element == null) {
            return null;
        }
        return this.element.newContainer(side, player);
    }

    @Override
    public int getBlockMetadata() {
        return this.element.transparentNodeDescriptor.tileEntityMetaTag.meta;
    }

    @Override
    public void networkUnserialize(DataInputStream stream, EntityPlayerMP player) {
        super.networkUnserialize(stream, player);
        try {
            if (this.elementId == stream.readShort()) {
                this.element.networkUnserialize(stream, player);
            } else {
                Utils.println("Transparent node unserialize miss");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void connectJob() {
        super.connectJob();
        this.element.connectJob();
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        this.element.disconnectJob();
    }

    @Override
    public void checkCanStay(boolean onCreate) {
        super.checkCanStay(onCreate);
        this.element.checkCanStay(onCreate);
    }

    public void dropElement(EntityPlayerMP entityPlayer) {
        if (this.element != null && Utils.mustDropItem(entityPlayer)) {
            this.dropItem(this.element.getDropItemStack());
        }
    }

    @Override
    public String getNodeUuid() {
        return Eln.transparentNodeBlock.getNodeUuid();
    }

    @Override
    public void unload() {
        super.unload();
        if (this.element != null) {
            this.element.unload();
        }
    }

    public static enum FrontType {
        BlockSide,
        PlayerView,
        PlayerViewHorizontal,
        BlockSideInv;

    }
}

