/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.transparent;

import java.util.List;
import mods.eln.generic.GenericItemBlockUsingDamageDescriptor;
import mods.eln.ghost.GhostGroup;
import mods.eln.i18n.I18N;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.EntityMetaTag;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHopper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class TransparentNodeDescriptor
extends GenericItemBlockUsingDamageDescriptor
implements IItemRenderer {
    public Class ElementClass;
    public Class RenderClass;
    protected VoltageLevelColor voltageLevelColor = VoltageLevelColor.None;
    public final EntityMetaTag tileEntityMetaTag;
    protected GhostGroup ghostGroup = null;

    public TransparentNodeDescriptor(String name, Class ElementClass, Class RenderClass, EntityMetaTag tag) {
        super(name);
        this.ElementClass = ElementClass;
        this.RenderClass = RenderClass;
        this.tileEntityMetaTag = tag;
    }

    public TransparentNodeDescriptor(String name, Class ElementClass, Class RenderClass) {
        this(name, ElementClass, RenderClass, EntityMetaTag.Basic);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.INVENTORY ? false : !this.use2DIcon();
    }

    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return !this.use2DIcon();
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (this.getIcon() == null) {
            return;
        }
        this.voltageLevelColor.drawIconBackground(type);
        String icon = this.getIcon().func_94215_i().substring(4);
        UtilsClient.drawIcon(type, new ResourceLocation("eln", "textures/blocks/" + icon + ".png"));
    }

    public void objItemScale(Obj3D obj) {
        if (obj == null) {
            return;
        }
        float factor = obj.yDim * 0.6f;
        factor = Math.max(factor, (Math.max(obj.zMax, -obj.xMin) + Math.max(obj.xMax, -obj.zMin)) * 0.7f);
        factor = 1.0f / factor;
        GL11.glScalef((float)factor, (float)factor, (float)factor);
        GL11.glTranslatef((float)((Math.min(obj.zMin, obj.xMin) + Math.max(obj.xMax, obj.zMax)) / 2.0f - (obj.xMax + obj.xMin) / 2.0f), (float)(1.0f - (obj.xMax + obj.xMin) / 2.0f - (obj.zMax + obj.zMin) / 2.0f - (obj.yMax + obj.yMin) / 2.0f), (float)0.0f);
    }

    public TransparentNode.FrontType getFrontType() {
        return TransparentNode.FrontType.PlayerViewHorizontal;
    }

    public boolean mustHaveFloor() {
        return true;
    }

    public boolean mustHaveCeiling() {
        return false;
    }

    public boolean mustHaveWall() {
        return false;
    }

    public boolean mustHaveWallFrontInverse() {
        return false;
    }

    public String checkCanPlace(Coordonate coord, Direction front) {
        GhostGroup ghostGroup;
        Block block;
        Coordonate temp;
        boolean needDestroy = false;
        if (this.mustHaveFloor()) {
            temp = new Coordonate(coord);
            temp.move(Direction.YN);
            block = temp.getBlock();
            if (block == null || !block.func_149662_c() && !(block instanceof BlockHopper)) {
                return I18N.tr("You can't place this block at this side", new Object[0]);
            }
        }
        if (this.mustHaveCeiling()) {
            temp = new Coordonate(coord);
            temp.move(Direction.YP);
            block = temp.getBlock();
            if (block == null || !block.func_149662_c()) {
                return I18N.tr("You can't place this block at this side", new Object[0]);
            }
        }
        if (this.mustHaveWallFrontInverse()) {
            temp = new Coordonate(coord);
            temp.move(front.getInverse());
            block = temp.getBlock();
            if (block == null || !block.func_149662_c()) {
                return I18N.tr("You can't place this block at this side", new Object[0]);
            }
        }
        if (this.mustHaveWall()) {
            boolean wall = false;
            temp = new Coordonate(coord);
            temp.move(Direction.XN);
            block = temp.getBlock();
            if (block != null && block.func_149662_c()) {
                wall = true;
            }
            temp = new Coordonate(coord);
            temp.move(Direction.XP);
            block = temp.getBlock();
            if (block != null && block.func_149662_c()) {
                wall = true;
            }
            temp = new Coordonate(coord);
            temp.move(Direction.ZN);
            block = temp.getBlock();
            if (block != null && block.func_149662_c()) {
                wall = true;
            }
            temp = new Coordonate(coord);
            temp.move(Direction.ZP);
            block = temp.getBlock();
            if (block != null && block.func_149662_c()) {
                wall = true;
            }
            if (!wall) {
                return I18N.tr("You can't place this block at this side", new Object[0]);
            }
        }
        if ((ghostGroup = this.getGhostGroup(front)) != null && !ghostGroup.canBePloted(coord)) {
            return I18N.tr("Not enough space for this block", new Object[0]);
        }
        return null;
    }

    public Direction getFrontFromPlace(Direction side, EntityLivingBase entityLiving) {
        Direction front = Direction.XN;
        switch (this.getFrontType()) {
            case BlockSide: {
                front = side;
                break;
            }
            case BlockSideInv: {
                front = side.getInverse();
                break;
            }
            case PlayerView: {
                front = Utils.entityLivingViewDirection(entityLiving).getInverse();
                break;
            }
            case PlayerViewHorizontal: {
                front = Utils.entityLivingHorizontalViewDirection(entityLiving).getInverse();
            }
        }
        return front;
    }

    public boolean hasGhostGroup() {
        return this.ghostGroup != null;
    }

    public GhostGroup getGhostGroup(Direction front) {
        if (this.ghostGroup == null) {
            return null;
        }
        return this.ghostGroup.newRotate(front);
    }

    public int getGhostGroupUuid() {
        return -1;
    }

    public int getSpawnDeltaX() {
        return 0;
    }

    public int getSpawnDeltaY() {
        return 0;
    }

    public int getSpawnDeltaZ() {
        return 0;
    }

    public void addCollisionBoxesToList(AxisAlignedBB par5AxisAlignedBB, List list, TransparentNodeEntity entity) {
        AxisAlignedBB bb = Blocks.field_150348_b.func_149668_a(entity.func_145831_w(), entity.field_145851_c, entity.field_145848_d, entity.field_145849_e);
        if (par5AxisAlignedBB.func_72326_a(bb)) {
            list.add(bb);
        }
    }

    public void setGhostGroup(GhostGroup ghostGroup) {
        this.ghostGroup = ghostGroup;
    }
}

