/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.transparent;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.ghost.GhostObserver;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.Publishable;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalConnection;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Component;
import mods.eln.sim.mna.state.State;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sound.IPlayer;
import mods.eln.sound.SoundCommand;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class TransparentNodeElement
implements GhostObserver,
IPlayer,
Publishable {
    public ArrayList<IProcess> slowProcessList = new ArrayList(4);
    public ArrayList<IProcess> electricalProcessList = new ArrayList(4);
    public ArrayList<Component> electricalComponentList = new ArrayList(4);
    public ArrayList<State> electricalLoadList = new ArrayList(4);
    public ArrayList<IProcess> thermalFastProcessList = new ArrayList(4);
    public ArrayList<ThermalConnection> thermalConnectionList = new ArrayList(4);
    public ArrayList<NbtThermalLoad> thermalLoadList = new ArrayList(4);
    public static final byte unserializeGroundedId = -127;
    public static final byte unserializeNulldId = -128;
    TransparentNodeDescriptor transparentNodeDescriptor;
    public TransparentNode node;
    public Direction front;
    public boolean grounded = true;
    private int uuid = 0;

    public TransparentNodeDescriptor getDescriptor() {
        return this.transparentNodeDescriptor;
    }

    protected void serialiseItemStack(DataOutputStream stream, ItemStack stack) throws IOException {
        Utils.serialiseItemStack(stream, stack);
    }

    public void connectJob() {
        Eln.simulator.addAllSlowProcess(this.slowProcessList);
        Eln.simulator.addAllElectricalComponent(this.electricalComponentList);
        for (State state : this.electricalLoadList) {
            Eln.simulator.addElectricalLoad(state);
        }
        Eln.simulator.addAllElectricalProcess(this.electricalProcessList);
        Eln.simulator.addAllThermalConnection(this.thermalConnectionList);
        for (NbtThermalLoad nbtThermalLoad : this.thermalLoadList) {
            Eln.simulator.addThermalLoad(nbtThermalLoad);
        }
        Eln.simulator.addAllThermalFastProcess(this.thermalFastProcessList);
    }

    public void disconnectJob() {
        Eln.simulator.removeAllSlowProcess(this.slowProcessList);
        Eln.simulator.removeAllElectricalComponent(this.electricalComponentList);
        for (State state : this.electricalLoadList) {
            Eln.simulator.removeElectricalLoad(state);
        }
        Eln.simulator.removeAllElectricalProcess(this.electricalProcessList);
        Eln.simulator.removeAllThermalConnection(this.thermalConnectionList);
        for (NbtThermalLoad nbtThermalLoad : this.thermalLoadList) {
            Eln.simulator.removeThermalLoad(nbtThermalLoad);
        }
        Eln.simulator.removeAllThermalFastProcess(this.thermalFastProcessList);
    }

    public void onGroundedChangedByClient() {
        this.needPublish();
    }

    public byte networkUnserialize(DataInputStream stream, EntityPlayerMP player) {
        return this.networkUnserialize(stream);
    }

    public byte networkUnserialize(DataInputStream stream) {
        try {
            byte readed = stream.readByte();
            switch (readed) {
                case -127: {
                    this.grounded = stream.readByte() != 0;
                    this.onGroundedChangedByClient();
                    return -128;
                }
            }
            return readed;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -128;
        }
    }

    public int getLightValue() {
        return 0;
    }

    public boolean hasGui() {
        return false;
    }

    public IInventory getInventory() {
        return null;
    }

    public void preparePacketForClient(DataOutputStream stream) {
        this.node.preparePacketForClient(stream);
    }

    public void sendIdToAllClient(byte id) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
        DataOutputStream packet = new DataOutputStream(bos);
        this.preparePacketForClient(packet);
        try {
            packet.writeByte(id);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sendPacketToAllClient(bos);
    }

    public void sendStringToAllClient(byte id, String str) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
        DataOutputStream packet = new DataOutputStream(bos);
        this.preparePacketForClient(packet);
        try {
            packet.writeByte(id);
            packet.writeUTF(str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sendPacketToAllClient(bos);
    }

    private void sendPacketToAllClient(ByteArrayOutputStream bos) {
        this.node.sendPacketToAllClient(bos);
    }

    public Container newContainer(Direction side, EntityPlayer player) {
        return null;
    }

    public TransparentNodeElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        this.node = transparentNode;
        this.transparentNodeDescriptor = descriptor;
        if (descriptor.hasGhostGroup()) {
            Eln.ghostManager.addObserver(this);
        }
    }

    public IFluidHandler getFluidHandler() {
        return null;
    }

    public void onNeighborBlockChange() {
        this.checkCanStay(false);
    }

    public void checkCanStay(boolean onCreate) {
        boolean needDestroy = false;
        if (this.transparentNodeDescriptor.mustHaveFloor() && !this.node.isBlockOpaque(Direction.YN)) {
            needDestroy = true;
        }
        if (this.transparentNodeDescriptor.mustHaveCeiling() && !this.node.isBlockOpaque(Direction.YP)) {
            needDestroy = true;
        }
        if (this.transparentNodeDescriptor.mustHaveWallFrontInverse() && !this.node.isBlockOpaque(this.front.getInverse())) {
            needDestroy = true;
        }
        if (this.transparentNodeDescriptor.mustHaveWall()) {
            boolean wall = false;
            if (this.node.isBlockOpaque(Direction.XN)) {
                wall = true;
            }
            if (this.node.isBlockOpaque(Direction.XP)) {
                wall = true;
            }
            if (this.node.isBlockOpaque(Direction.ZN)) {
                wall = true;
            }
            if (this.node.isBlockOpaque(Direction.ZP)) {
                wall = true;
            }
            if (!wall) {
                needDestroy = true;
            }
        }
        if (needDestroy) {
            this.selfDestroy();
        }
    }

    public void selfDestroy() {
        this.node.physicalSelfDestruction(0.0f);
    }

    @Override
    public void stop(int uuid) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
        DataOutputStream stream = new DataOutputStream(bos);
        try {
            stream.writeByte(20);
            stream.writeInt(uuid);
            this.sendPacketToAllClient(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onBreakElement() {
        if (this.useUuid()) {
            this.stop(this.uuid);
        }
        if (this.transparentNodeDescriptor.hasGhostGroup()) {
            Eln.ghostManager.removeObserver(this.node.coordonate);
            Eln.ghostManager.removeGhostAndBlockWithObserver(this.node.coordonate);
        }
        this.node.dropInventory(this.getInventory());
        this.node.dropElement(this.node.removedByPlayer);
    }

    public ItemStack getDropItemStack() {
        ItemStack itemStack = new ItemStack((Block)Eln.transparentNodeBlock, 1, this.node.elementId);
        itemStack.func_77982_d(this.getItemStackNBT());
        return itemStack;
    }

    public NBTTagCompound getItemStackNBT() {
        return null;
    }

    public abstract ElectricalLoad getElectricalLoad(Direction var1, LRDU var2);

    public abstract ThermalLoad getThermalLoad(Direction var1, LRDU var2);

    public abstract int getConnectionMask(Direction var1, LRDU var2);

    public abstract String multiMeterString(Direction var1);

    public abstract String thermoMeterString(Direction var1);

    public void networkSerialize(DataOutputStream stream) {
        try {
            stream.writeByte(this.front.getInt() + (this.grounded ? 8 : 0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initializeFromThat(Direction front, EntityLivingBase entityLiving, NBTTagCompound itemStackNbt) {
        this.front = front;
        this.readItemStackNBT(itemStackNbt);
        this.initialize();
    }

    public abstract void initialize();

    public void readItemStackNBT(NBTTagCompound nbt) {
    }

    public abstract boolean onBlockActivated(EntityPlayer var1, Direction var2, float var3, float var4, float var5);

    public void readFromNBT(NBTTagCompound nbt) {
        IInventory inv = this.getInventory();
        if (inv != null) {
            Utils.readFromNBT(nbt, "inv", inv);
        }
        boolean idx = false;
        for (State electricalLoad : this.electricalLoadList) {
            if (!(electricalLoad instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)electricalLoad)).readFromNBT(nbt, "");
        }
        for (NbtThermalLoad thermalLoad : this.thermalLoadList) {
            thermalLoad.readFromNBT(nbt, "");
        }
        for (Component c : this.electricalComponentList) {
            if (!(c instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)c)).readFromNBT(nbt, "");
        }
        for (IProcess process : this.slowProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).readFromNBT(nbt, "");
        }
        for (IProcess process : this.electricalProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).readFromNBT(nbt, "");
        }
        for (IProcess process : this.thermalFastProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).readFromNBT(nbt, "");
        }
        byte b = nbt.func_74771_c("others");
        this.front = Direction.fromInt(b & 7);
        this.grounded = (b & 8) != 0;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        boolean idx = false;
        IInventory inv = this.getInventory();
        if (inv != null) {
            Utils.writeToNBT(nbt, "inv", inv);
        }
        for (State electricalLoad : this.electricalLoadList) {
            if (!(electricalLoad instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)electricalLoad)).writeToNBT(nbt, "");
        }
        for (NbtThermalLoad thermalLoad : this.thermalLoadList) {
            thermalLoad.writeToNBT(nbt, "");
        }
        for (Component c : this.electricalComponentList) {
            if (!(c instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)c)).writeToNBT(nbt, "");
        }
        for (IProcess process : this.slowProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).writeToNBT(nbt, "");
        }
        for (IProcess process : this.electricalProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).writeToNBT(nbt, "");
        }
        for (IProcess process : this.thermalFastProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).writeToNBT(nbt, "");
        }
        nbt.func_74774_a("others", (byte)(this.front.getInt() + (this.grounded ? 8 : 0)));
    }

    public void reconnect() {
        this.node.reconnect();
    }

    @Override
    public void needPublish() {
        this.node.setNeedPublish(true);
    }

    public void connect() {
        this.node.connect();
    }

    public void disconnect() {
        this.node.disconnect();
    }

    public void inventoryChange(IInventory inventory) {
    }

    public float getLightOpacity() {
        return 0.0f;
    }

    @Override
    public Coordonate getGhostObserverCoordonate() {
        return this.node.coordonate;
    }

    @Override
    public void ghostDestroyed(int UUID2) {
        if (UUID2 == this.transparentNodeDescriptor.getGhostGroupUuid()) {
            this.selfDestroy();
        }
    }

    @Override
    public boolean ghostBlockActivated(int UUID2, EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (UUID2 == this.transparentNodeDescriptor.getGhostGroupUuid()) {
            return this.node.onBlockActivated(entityPlayer, side, vx, vy, vz);
        }
        return false;
    }

    public World world() {
        return this.node.coordonate.world();
    }

    public Coordonate coordonate() {
        return this.node.coordonate;
    }

    public int getUuid() {
        if (this.uuid == 0) {
            this.uuid = Utils.getUuid();
        }
        return this.uuid;
    }

    public boolean useUuid() {
        return this.uuid != 0;
    }

    @Override
    public void play(SoundCommand s) {
        s.addUuid(this.getUuid());
        s.set(this.node.coordonate);
        s.play();
    }

    public void unload() {
    }

    public Map<String, String> getWaila() {
        HashMap<String, String> wailaList = new HashMap<String, String>();
        wailaList.put("Info", this.multiMeterString(this.front));
        return wailaList;
    }
}

