/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.transparent;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.cable.CableRender;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.cable.CableRenderType;
import mods.eln.client.ClientProxy;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUMask;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.sound.SoundCommand;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import org.lwjgl.opengl.GL11;

public abstract class TransparentNodeElementRender {
    public TransparentNodeEntity tileEntity;
    public Direction front;
    public boolean grounded;
    public TransparentNodeDescriptor transparentNodedescriptor;
    static final LRDUMask maskTempDraw = new LRDUMask();
    private int uuid = 0;

    public TransparentNodeElementRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        this.tileEntity = tileEntity;
        this.transparentNodedescriptor = descriptor;
    }

    protected EntityItem unserializeItemStackToEntityItem(DataInputStream stream, EntityItem old) throws IOException {
        return Utils.unserializeItemStackToEntityItem(stream, old, this.tileEntity);
    }

    public void drawEntityItem(EntityItem entityItem, double x, double y, double z, float roty, float scale) {
        UtilsClient.drawEntityItem(entityItem, x, y, z, roty, scale);
    }

    public void glCableTransforme(Direction inverse) {
        inverse.glTranslate(0.5f);
        inverse.glRotateXnRef();
    }

    public abstract void draw();

    public void networkUnserialize(DataInputStream stream) {
        try {
            byte b = stream.readByte();
            this.front = Direction.fromInt(b & 7);
            this.grounded = (b & 8) != 0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return null;
    }

    public IInventory getInventory() {
        return null;
    }

    public void preparePacketForServer(DataOutputStream stream) {
        this.tileEntity.preparePacketForServer(stream);
    }

    public void sendPacketToServer(ByteArrayOutputStream bos) {
        this.tileEntity.sendPacketToServer(bos);
    }

    public void clientSetGrounded(boolean value) {
        this.clientSendBoolean((byte)-127, value);
    }

    public void clientSendBoolean(Byte id, boolean value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id.byteValue());
            stream.writeByte(value ? 1 : 0);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clientSendId(Byte id) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id.byteValue());
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clientSendString(Byte id, String str) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id.byteValue());
            stream.writeUTF(str);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clientSendFloat(Byte id, float str) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id.byteValue());
            stream.writeFloat(str);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clientSendInt(Byte id, int str) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id.byteValue());
            stream.writeInt(str);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean cameraDrawOptimisation() {
        return true;
    }

    public CableRenderDescriptor getCableRender(Direction side, LRDU lrdu) {
        return null;
    }

    public CableRenderType drawCable(Direction side, CableRenderDescriptor render, LRDUMask connection, CableRenderType renderPreProcess) {
        if (render == null) {
            return renderPreProcess;
        }
        if (renderPreProcess == null) {
            renderPreProcess = CableRender.connectionType(this.tileEntity, connection, side);
        }
        GL11.glPushMatrix();
        this.glCableTransforme(side);
        render.bindCableTexture();
        for (LRDU lrdu : LRDU.values()) {
            Utils.setGlColorFromDye(renderPreProcess.otherdry[lrdu.toInt()]);
            if (!connection.get(lrdu)) continue;
            maskTempDraw.set(1 << lrdu.toInt());
            CableRender.drawCable(render, maskTempDraw, renderPreProcess);
        }
        GL11.glPopMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        return renderPreProcess;
    }

    public void notifyNeighborSpawn() {
    }

    public void serverPacketUnserialize(DataInputStream stream) {
    }

    protected Coordonate coordonate() {
        return new Coordonate(this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e, this.tileEntity.func_145831_w());
    }

    public int getUuid() {
        if (this.uuid == 0) {
            this.uuid = UtilsClient.getUuid();
        }
        return this.uuid;
    }

    public boolean usedUuid() {
        return this.uuid != 0;
    }

    public void play(SoundCommand s) {
        s.addUuid(this.getUuid());
        s.set(this.tileEntity);
        s.play();
    }

    public void destructor() {
        if (this.usedUuid()) {
            ClientProxy.uuidManager.kill(this.uuid);
        }
    }

    public void refresh(float deltaT) {
    }
}

