/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.transparent;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.FakeSideInventory;
import mods.eln.misc.LRDU;
import mods.eln.node.Node;
import mods.eln.node.NodeBlockEntity;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementRender;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TransparentNodeEntity
extends NodeBlockEntity
implements ISidedInventory {
    TransparentNodeElementRender elementRender = null;
    short elementRenderId;

    @Override
    public CableRenderDescriptor getCableRender(Direction side, LRDU lrdu) {
        if (this.elementRender == null) {
            return null;
        }
        return this.elementRender.getCableRender(side, lrdu);
    }

    @Override
    public void serverPublishUnserialize(DataInputStream stream) {
        super.serverPublishUnserialize(stream);
        try {
            Short id = stream.readShort();
            if (id == 0) {
                this.elementRenderId = 0;
                this.elementRender = null;
            } else {
                if (id != this.elementRenderId) {
                    this.elementRenderId = id;
                    TransparentNodeDescriptor descriptor = (TransparentNodeDescriptor)Eln.transparentNodeItem.getDescriptor(id.shortValue());
                    this.elementRender = (TransparentNodeElementRender)descriptor.RenderClass.getConstructor(TransparentNodeEntity.class, TransparentNodeDescriptor.class).newInstance(this, descriptor);
                }
                this.elementRender.networkUnserialize(stream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        TransparentNode n = (TransparentNode)this.getNode();
        if (n == null) {
            return null;
        }
        return n.newContainer(side, player);
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return this.elementRender.newGuiDraw(side, player);
    }

    @Override
    public void preparePacketForServer(DataOutputStream stream) {
        try {
            super.preparePacketForServer(stream);
            stream.writeShort(this.elementRenderId);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendPacketToServer(ByteArrayOutputStream bos) {
        super.sendPacketToServer(bos);
    }

    @Override
    public boolean cameraDrawOptimisation() {
        if (this.elementRender == null) {
            return super.cameraDrawOptimisation();
        }
        return this.elementRender.cameraDrawOptimisation();
    }

    public int getDamageValue(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return this.elementRenderId;
        }
        return 0;
    }

    @Override
    public void tileEntityNeighborSpawn() {
        if (this.elementRender != null) {
            this.elementRender.notifyNeighborSpawn();
        }
    }

    public void addCollisionBoxesToList(AxisAlignedBB par5AxisAlignedBB, List list) {
        if (this.field_145850_b.field_72995_K) {
            if (this.elementRender == null) {
                AxisAlignedBB bb = Blocks.field_150348_b.func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (par5AxisAlignedBB.func_72326_a(bb)) {
                    list.add(bb);
                }
            } else {
                this.elementRender.transparentNodedescriptor.addCollisionBoxesToList(par5AxisAlignedBB, list, this);
            }
        } else {
            TransparentNode node = (TransparentNode)this.getNode();
            if (node == null) {
                AxisAlignedBB bb = Blocks.field_150348_b.func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (par5AxisAlignedBB.func_72326_a(bb)) {
                    list.add(bb);
                }
            } else {
                node.element.transparentNodeDescriptor.addCollisionBoxesToList(par5AxisAlignedBB, list, this);
            }
        }
    }

    @Override
    public void serverPacketUnserialize(DataInputStream stream) {
        super.serverPacketUnserialize(stream);
        if (this.elementRender != null) {
            this.elementRender.serverPacketUnserialize(stream);
        }
    }

    @Override
    public String getNodeUuid() {
        return Eln.transparentNodeBlock.getNodeUuid();
    }

    @Override
    public void destructor() {
        if (this.elementRender != null) {
            this.elementRender.destructor();
        }
        super.destructor();
    }

    @Override
    public void clientRefresh(float deltaT) {
        if (this.elementRender != null) {
            this.elementRender.refresh(deltaT);
        }
    }

    @Override
    public int isProvidingWeakPower(Direction side) {
        return 0;
    }

    ISidedInventory getSidedInventory() {
        if (this.field_145850_b.field_72995_K) {
            if (this.elementRender == null) {
                return FakeSideInventory.getInstance();
            }
            IInventory i = this.elementRender.getInventory();
            if (i != null && i instanceof ISidedInventory) {
                return (ISidedInventory)i;
            }
        } else {
            TransparentNode tn;
            IInventory i;
            Node node = this.getNode();
            if (node != null && node instanceof TransparentNode && (i = (tn = (TransparentNode)node).getInventory(null)) != null && i instanceof ISidedInventory) {
                return (ISidedInventory)i;
            }
        }
        return FakeSideInventory.getInstance();
    }

    public int func_70302_i_() {
        return this.getSidedInventory().func_70302_i_();
    }

    public ItemStack func_70301_a(int var1) {
        return this.getSidedInventory().func_70301_a(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return this.getSidedInventory().func_70298_a(var1, var2);
    }

    public ItemStack func_70304_b(int var1) {
        return this.getSidedInventory().func_70304_b(var1);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.getSidedInventory().func_70299_a(var1, var2);
    }

    public String func_145825_b() {
        return this.getSidedInventory().func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.getSidedInventory().func_145818_k_();
    }

    public int func_70297_j_() {
        return this.getSidedInventory().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.getSidedInventory().func_70300_a(var1);
    }

    public void func_70295_k_() {
        this.getSidedInventory().func_70295_k_();
    }

    public void func_70305_f() {
        this.getSidedInventory().func_70305_f();
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return this.getSidedInventory().func_94041_b(var1, var2);
    }

    public int[] func_94128_d(int var1) {
        return this.getSidedInventory().func_94128_d(var1);
    }

    public boolean func_102007_a(int var1, ItemStack var2, int var3) {
        return this.getSidedInventory().func_102007_a(var1, var2, var3);
    }

    public boolean func_102008_b(int var1, ItemStack var2, int var3) {
        return this.getSidedInventory().func_102008_b(var1, var2, var3);
    }
}

