/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.transparent;

import mods.eln.generic.GenericItemBlockUsingDamage;
import mods.eln.ghost.GhostGroup;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.Utils;
import mods.eln.node.NodeBlock;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class TransparentNodeItem
extends GenericItemBlockUsingDamage<TransparentNodeDescriptor>
implements IItemRenderer {
    public TransparentNodeItem(Block b) {
        super(b);
        this.func_77627_a(true);
        this.func_77655_b("TransparentNodeItem");
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        Coordonate coord;
        String error;
        if (world.field_72995_K) {
            return false;
        }
        TransparentNodeDescriptor descriptor = (TransparentNodeDescriptor)this.getDescriptor(stack);
        Direction direction = Direction.fromIntMinecraftSide(side).getInverse();
        Direction front = descriptor.getFrontFromPlace(direction, (EntityLivingBase)player);
        int[] v = new int[]{descriptor.getSpawnDeltaX(), descriptor.getSpawnDeltaY(), descriptor.getSpawnDeltaZ()};
        front.rotateFromXN(v);
        Block bb = world.func_147439_a(x += v[0], y += v[1], z += v[2]);
        if (bb.isReplaceable((IBlockAccess)world, x, y, z)) {
            // empty if block
        }
        if ((error = descriptor.checkCanPlace(coord = new Coordonate(x, y, z, world), front)) != null) {
            Utils.addChatMessage(player, error);
            return false;
        }
        GhostGroup ghostgroup = descriptor.getGhostGroup(front);
        if (ghostgroup != null) {
            ghostgroup.plot(coord, coord, descriptor.getGhostGroupUuid());
        }
        TransparentNode node = new TransparentNode();
        node.onBlockPlacedBy(new Coordonate(x, y, z, world), front, (EntityLivingBase)player, stack);
        world.func_147465_d(x, y, z, Block.func_149634_a((Item)this), node.getBlockMetadata(), 3);
        ((NodeBlock)Block.func_149634_a((Item)this)).onBlockPlacedBy(world, x, y, z, direction, (EntityLivingBase)player, metadata);
        node.checkCanStay(true);
        return true;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        TransparentNodeDescriptor d = (TransparentNodeDescriptor)this.getDescriptor(item);
        if (Utils.nullCheck(d)) {
            return false;
        }
        return d.handleRenderType(item, type);
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return ((TransparentNodeDescriptor)this.getDescriptor(item)).shouldUseRenderHelper(type, item, helper);
    }

    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return ((TransparentNodeDescriptor)this.getDescriptor(item)).shouldUseRenderHelperEln(type, item, helper);
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        Minecraft.func_71410_x().field_71424_I.func_76320_a("TransparentNodeItem");
        if (this.shouldUseRenderHelperEln(type, item, null)) {
            switch (type) {
                case ENTITY: {
                    GL11.glTranslatef((float)0.0f, (float)0.3f, (float)0.0f);
                    break;
                }
                case EQUIPPED_FIRST_PERSON: {
                    GL11.glTranslatef((float)0.5f, (float)1.0f, (float)0.5f);
                    break;
                }
                case EQUIPPED: {
                    GL11.glTranslatef((float)0.5f, (float)1.0f, (float)0.5f);
                    break;
                }
                case FIRST_PERSON_MAP: {
                    break;
                }
                case INVENTORY: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
            }
        }
        ((TransparentNodeDescriptor)this.getDescriptor(item)).renderItem(type, item, data);
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }
}

