/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.ore;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.Random;
import mods.eln.Eln;
import mods.eln.generic.GenericItemBlockUsingDamageDescriptor;
import mods.eln.wiki.Data;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class OreDescriptor
extends GenericItemBlockUsingDamageDescriptor
implements IWorldGenerator {
    int metadata;
    int spawnRate;
    int spawnSizeMax;
    int spawnSizeMin;
    int spawnHeightMin;
    int spawnHeightMax;

    public OreDescriptor(String name, int metadata, int spawnRate, int spawnSizeMin, int spawnSizeMax, int spawnHeightMin, int spawnHeightMax) {
        super(name);
        this.metadata = metadata;
        this.spawnHeightMax = spawnHeightMax;
        this.spawnHeightMin = spawnHeightMin;
        this.spawnRate = spawnRate;
        this.spawnSizeMin = spawnSizeMin;
        this.spawnSizeMax = spawnSizeMax;
    }

    public IIcon getBlockIconId(int side, int damage) {
        return this.getIcon();
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addOre(this.newItemStack());
    }

    public ArrayList<ItemStack> getBlockDropped(int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((Item)Eln.oreItem, 1, this.metadata));
        return list;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.func_76569_d()) {
            this.generateSurface(random, chunkX * 16, chunkZ * 16, world);
        }
    }

    public void generateSurface(Random random, int x, int z, World w) {
        if (w.func_72912_H().func_76067_t() == WorldType.field_77138_c) {
            return;
        }
        for (int ii = 0; ii < this.spawnRate; ++ii) {
            int posX = x + random.nextInt(16);
            int posY = this.spawnHeightMin + random.nextInt(this.spawnHeightMax - this.spawnHeightMin);
            int posZ = z + random.nextInt(16);
            int size = this.spawnSizeMin + random.nextInt(this.spawnSizeMax - this.spawnSizeMin);
            new WorldGenMinable((Block)Eln.oreBlock, this.metadata, size, Blocks.field_150348_b).func_76484_a(w, random, posX, posY, posZ);
        }
    }
}

